
#include "RPCTest.hxx"

CODE_MODULE_DECLARATION( RPCTest, RPCTest );

RPCTest::RPCTest(catomID _hostCatom) : RPCCodeModule<RPCTest>(_hostCatom)
{}

void RPCTest::thread() {
  for( unsigned int i=1; i<NUM_FEATURES; i++ ) {

    RPCNeighbor<RPCTest>* neighbor = this->getNeighbor(i);

    if( neighbor != NULL ) {
      worldPtr->oStart();
      cout << "Using RPC on feature " << i <<endl;
      worldPtr->oEnd();
      
      RPCTest* tmp = (neighbor->get());
      tmp->contact();
    }

  }

  worldPtr->oStart();
  cout << "Catom is finished." <<endl;
  worldPtr->oEnd();  
}

void RPCTest::contact() {
  ENTER_RPC_METHOD;

  worldPtr->oStart();
  cout << "Catom  contacted via RPC!" <<endl;
  worldPtr->oEnd();  

  RPC_RETURN;
}
