// RPCCodeModuleStatic.hxx
// Nels Beckman
// March 22, 2007 (Now more like 5:30am!)

#ifndef __RPC_CODE_STATIC
#define __RPC_CODE_STATIC

#include <pthread.h>
#include <set>

#include "FailureSimulator.hxx"
#include "Network.hxx"
#include "CodeModule.hxx"

#define RPCMsgID unsigned long long

class SendFail {};

class RPCAckMsg : public Message {
public:
  static const MailboxID RPC_ACK_BOX;

  RPCAckMsg();
  RPCAckMsg(unsigned long long);

  virtual Message* clone();
};

class RPCCodeModuleStatic : public CodeModule {

protected:  
  pthread_cond_t rpcConVar;
  pthread_mutex_t rpcMutex;
  
  // This boolean flag is set to true when the sleeping rpc thread
  //   should be woken up by the periodic thread. Should be protected
  //   with rpcMutex.
  bool wakeRPCThread;

  FailureSimulator failureSim;

  pair< catomID, featureID > readyMove;
  int moveCountdown;

  //map<pthread_t, int> rpcMethodStacks;

  bool moveReady();
  void makeReadyMove();

  void sched_move( catomID, featureID );

  // Mutex protects the following static members.
  static pthread_mutex_t rpcGlobalMTX;
  static map<catomID, RPCCodeModuleStatic*> wakeFlags;
  
  // Where was this thread created?
  static map<pthread_t, catomID> threadHomeMap;
  
  // On what catom is this thread currently located?
  static map<pthread_t, catomID> threadLocationMap;
  
  // Messages that have already arrived at this given host.
  static map<catomID, set<RPCMsgID> > arrivedMsgs;
  
  // See the randomizer with a value from the exp file, or the time.
  static void seedRandomizer();

  // The first method called by new rpc threads.
  //   Similar to the old codeModulePerThreadMain
  static void* rpcThreadMain(void*);
  
  // Starts a thread, but has a 'this'
  void rpcThreadBegin();

  // Called by the non-rpc thread in the start simulation method.
  //   Similar to the old startCodeModulePerThread
  void startRPCThread();

public:
  RPCCodeModuleStatic(catomID _hostCatom);

  // In the spirit of SmartYield::doYield
  //   This method is called by a yielding rpc thread.
  virtual void doRPCYield();

  virtual void simulationStart();

  // So we don't have to do all the annoying work every time we want
  //   to send a message. Also does extra stuff.
  static bool sendMsg(catomID, featureID, Message*);

  // Wakes an arbitrary catom RPC thread.
  static void setThreadWake(catomID c);

  static void clearThreadWake(catomID c);

  // Runs the long-running thread. Runs to yield.
  virtual void thread();

  // Sets a flag to wake the rpc thread at the next tick.
  void wakeRPCThreadLazy();

  void clearRPCThreadWake();

  pthread_mutex_t& getMutex();

  pthread_cond_t& getConVar();

  // Returns the home catom for the currently running thread.
  static catomID getThreadHome();

  // One what catom is this thread currently located?
  static catomID getThreadLocation();

  // Has the message IDed by the given ID arrived at the given
  //   catom?
  static bool hasMsgArrived(catomID, RPCMsgID);

  // Inserts the given message id into the set for the given catom.
  //   Signifies the fact that the message has arrived at the catom.
  static void setMsgHasArrived(catomID, RPCMsgID);
  
  // Set the location of the current thread.
  static void setThreadLocation(catomID);

};

#endif
