#ifndef __POINT_H
#define __POINT_H

#include <math.h>

#define POINT_EPSILON 0.001

class Point
{
public: 
  double x, y, z;

  Point();
  Point(double x, double y, double z);
  Point operator+ (const Point &p);
  Point operator- (const Point &p);
  Point operator* (const Point &p);
  Point operator* (double d);
  Point operator* (int i);
  bool operator== (const Point &p);
  bool operator!= (const Point &p);
};

double dot(const Point &p, const Point &q);
double magnitude(const Point &p);
ostream& operator<< (ostream &out, Point &p);

#endif
