#include "Debugging/signpost.hxx"
#include <iostream>
#include "Point.hxx"

Point::Point()
{
  this->x = 0;
  this->y = 0;
  this->z = 0;
}

Point::Point(double x, double y, double z)
{
  this->x = x;
  this->y = y;
  this->z = z;
}

Point Point::operator+ (const Point &p)
{
  return Point(x + p.x, y + p.y, z + p.z);
}

Point Point::operator- (const Point &p)
{
  return Point(x - p.x, y - p.y, z - p.z);
}

Point Point::operator* (const Point &p)
{
  return Point(y * p.z - z * p.y,
	       z * p.x - x * p.z,
	       x * p.y - y * p.x);
}

Point Point::operator* (double d)
{
  return Point (d * x, d * y, d * z);
}

Point Point::operator* (int i)
{
  return Point (i * x, i * y, i * z);
}

bool Point::operator== (const Point &p)
{
  return (x + POINT_EPSILON > p.x &&
	  x < p.x + POINT_EPSILON &&
	  y + POINT_EPSILON > p.y &&
	  y < p.y + POINT_EPSILON &&
	  z + POINT_EPSILON > p.z &&
	  z < p.z + POINT_EPSILON);
}

bool Point::operator!= (const Point &p)
{
  return !(*this == p);

}

double dot(const Point &p, const Point &q)
{
  return p.x * q.x + p.y * q.y + p.z * q.z;
}

double magnitude(const Point &p)
{
  return sqrt(dot(p, p));
}

ostream& operator<< (ostream &out, Point &p)
{
  return out << "(" << p.x << ", " << p.y << ", " << p.z << ")";
}
