#ifndef P2CATOMBASE_H
#define P2CATOMBASE_H

#include "CodeModule.hxx"
#include "Point.hxx"
#include "Network.hxx"
#include "CatomWorld.hxx"
#include "CatomSim.hxx"
#include "Util.hxx"

// instrumentation constants
// times are expressed in micro-seconds
#define ONE_HOP_LATENCY 100
#define BYTES_PER_MICRO_SECOND .5
#define MS 1000000/CLOCKS_PER_SEC

#define TAG_NEIGHBOR 0
#define TAG_NEIGHBORCOUNT 1
#define TAG_VACANT 2
#define TAG_POSITION 3
#define TAG_HELLO 4
#define TAG_STATE 5
#define TAG_RESOURCES 6
#define TAG_USERDEFINED_START 7

typedef catomID addr;

struct queueItem {
  int type;
  bool del;
  void *data;

  queueItem(int type, void *data, bool del)
    : type(type), del(del), data(data)
  {}
};

class P2Msg : public Message
{
public:
  double time;
  int type;
  bool del;
  void *data;
  list<unsigned int> route;

  catomID from;

  P2Msg(MailboxID box, double time, list<unsigned int> route, int type, bool del, void *data, catomID from)
    : Message(box), time(time), type(type), del(del), data(data), from(from)
  {
    this->route = route;
  }

  // what is this used for? do we need to clone data? maybe we should
  // make the P2 messages explicit subclasses of this instead.
  virtual Message* clone() {
    return new P2Msg(mailboxID, time, route, type, del, data, from);
  }
};

class P2CatomBase : public CodeModule
{
private:

  map<catomID,featureID> links;
  map<featureID,catomID> myNeighbors;
  map<featureID,int> myExists;

  bool messageHandler(P2Msg *msg);

  void display();
  void accumTime(double t);

  // variables for instrumentation
  unsigned int messages_sent;
  unsigned int traffic_sent;
  unsigned int vector_elements_sent; // sum of all message sizes
  double current_time;
  double cpu_time;
  double current_find_time;
  double find_time;
protected:
  unsigned int queries;
private:
  unsigned int memory_usage;

  // static variable to determine root
  static unsigned int root;

  // static variables with global information
  static unsigned int global_messages_sent;
  static unsigned int global_vector_elements_sent;
  static unsigned int global_traffic_sent;
  static double global_max_current_time;
  static double global_max_cpu_time;
  static double global_max_find_time;
  static unsigned int global_max_queries;
  static unsigned int global_max_memory_usage;

  int resetTime;

  int oldResources;

protected:
  // compiled code callbacks
  void sendMsg(list <unsigned int> &, int, bool, void *, unsigned int);
  void sendMsg(unsigned int, int, bool, void *, unsigned int);
  void startFindTime();
  void endFindTime();

  virtual void newTick();
  virtual void endTick();

  virtual void handleMsg(int, void *, bool) = 0;
  virtual void deleteAll() = 0;
  virtual void cleanup(catomID) = 0;
  virtual int memoryUsage() = 0;

  list<queueItem *> msgQueue;

  bool useMetaModuleHack(void);
  void doMetaInit(void);
  void doMetaGive(void *);
  void doMetaCreate(void *);
  void doMetaDestroy(void *);


public:
  P2CatomBase(catomID cid);

  void reset();
  void simulationStart();
  void simulationEnd();
};



#endif
