#include <iostream>

#include "P2CatomBase.hxx"

#include "CatomWorld.hxx"
#include "CatomSim.hxx"
#include "Util.hxx"

#include <time.h>
#include "cyclecount.hxx"

MailboxID P2Box = "P2Box";

using namespace std;

// initialization of global variables
unsigned int P2CatomBase::global_messages_sent = 0;
unsigned int P2CatomBase::global_vector_elements_sent = 0;
double P2CatomBase::global_max_current_time = 0;
double P2CatomBase::global_max_cpu_time = 0;
double P2CatomBase::global_max_find_time = 0;
unsigned int P2CatomBase::global_traffic_sent = 0;
unsigned int P2CatomBase::global_max_memory_usage = 0;
unsigned int P2CatomBase::global_max_queries = 0;
unsigned int P2CatomBase::root = 0;

P2CatomBase::P2CatomBase(catomID cid) : CodeModule(cid)
{
}

static bool sourceworldloaded = false;
static hash_set<Point3D, HashPoint3D, EqualPoint3D> sourceWorldMap;

bool loadSourceWorld()
{
  sourceworldloaded = true;

  // init target
  string fname = worldPtr->search_key_value_list("STARTFILE");
  if (fname == "") {
    die("Need to specify a STARTFILE=fname key/value pair");
    return false;
  }
  if (loadPointHash(fname, sourceWorldMap) == false) {
    die("Couldn't load %s", fname.c_str());
  }
  hash_set<Point3D, HashPoint3D, EqualPoint3D>::iterator I;
  for (I=sourceWorldMap.begin(); I!=sourceWorldMap.end(); I++) {
    Point3D p = *I;
    cerr << p << "\n";
  }
  return true;
}

void P2CatomBase::simulationStart()
{
  Catom *thisCatom = &(worldPtr->catomHash[hostCatom]->C);

  thisCatom->mailboxManager.registerHandler(P2Box,
					    this,
					    (msgHandlerPtr)&P2CatomBase::messageHandler);

  resetTime = -1;

  // initialize instrumentation variables
  messages_sent = 0;
  traffic_sent = 0;
  vector_elements_sent = 0;
  current_time = 0;
  cpu_time = 0;
  find_time = 0;
  memory_usage = 0;
  queries = 0;


  oldResources = -1;

  HOSTCATOM.setColor(128,128,128,0);

  string rootID = worldPtr->search_key_value_list("FINALCATOM");
  if (rootID == "") {
    root = -1;
    //die("Need to specify a FINALCATOM=catomid key/value pair");
  }
  else
    root = atoi(rootID.c_str());

  doMetaInit();
}

void P2CatomBase::simulationEnd()
{
  // calculate memory usage
  memory_usage = memoryUsage();

  // collect global information

  worldPtr->oStart();
  global_messages_sent += messages_sent;
  global_traffic_sent += traffic_sent;
  global_max_current_time = max(current_time,
				global_max_current_time);
  global_max_cpu_time = max(cpu_time,
			    global_max_cpu_time);
  global_max_find_time = max((cpu_time - find_time),
			     global_max_find_time);
  global_max_memory_usage = max(memory_usage,
				global_max_memory_usage);
  global_max_queries = max(queries,
			   global_max_queries);
    worldPtr->oEnd();

  // display

  display();
}

// hack: we need to insert initial tuples for the links, so we'll just
// declare the same class here. tag_link better be 0 (compiler does this).

/* TODO: Fix this HACK such that it is auto-generated by compiler or else "right" */

struct tuple_state {
  int refCount;
  addr var_0;
  int var_1;

  tuple_state (addr var_0, int var_1)
  {
    refCount = 1;
    this->var_0 = var_0;
    this->var_1 = var_1;
  }
};

struct tuple_neighbor {
  int refCount;
  addr var_0;
  addr var_1;
  Point var_2;

  tuple_neighbor (addr var_0, addr var_1, Point var_2)
  {
    (refCount=(1));
    (this->var_0=(var_0));
    (this->var_1=(var_1));
    (this->var_2=(var_2));
  }
};

struct tuple_vacant {
  int refCount;
  addr var_0;
  Point var_1;

  tuple_vacant (addr var_0, Point var_1)
  {
    (refCount=(1));
    (this->var_0=(var_0));
    (this->var_1=(var_1));
  }
};

struct tuple_pos {
  int refCount;
  addr var_0;
  Point var_1;

  tuple_pos (addr var_0, Point var_1)
  {
    (refCount=(1));
    (this->var_0=(var_0));
    (this->var_1=(var_1));
  }
};

struct tuple_neighborCount {
  int refCount;
  addr var_0;
  int var_1;

  tuple_neighborCount (addr var_0, int var_1)
  {
    (refCount=(1));
    (this->var_0=(var_0));
    (this->var_1=(var_1));
  }
};

/* END: TODO */

/* TODO:MPAR:REMOVE ME */
#include "pathsupport.hxx"

void P2CatomBase::reset()
{
  Catom *thisCatom = &(worldPtr->catomHash[hostCatom]->C);

  resetTime = worldPtr->current_time;

  int neighbors = 0;

  deleteAll();
  msgQueue.clear();

  // initialize position
  Point3D loc = thisCatom->getLocation();
  Point location = Point(loc.getX(), loc.getY(), loc.getZ());
  
  handleMsg(TAG_POSITION, new tuple_pos(hostCatom, location), false);
  handleMsg(TAG_RESOURCES, new tuple_state(hostCatom, HOSTCATOM.resources), false);
  
  if (hostCatom == root) {
    handleMsg(TAG_STATE, new tuple_state(hostCatom, 0), false);
  }

  Feature* map = HOSTCATOM.getFeatureMap();
  
  for (int i = 1; i <= NUM_FEATURES; i++)
    {
      featureID nfid = i;
      catomID ncid = thisCatom->getNeighbor(nfid);
      myNeighbors[nfid] = ncid;
      myExists[nfid] = ncid ? (worldPtr->catomHash[ncid]->C.resources - 1) / 2 + 1: 0;

      /* If there is no catom there or the catom there does not exist... */
      if (ncid == 0 || worldPtr->catomHash[ncid]->C.resources == -1)
	{
	  links[ncid] = -1;
	  Point3D loc = thisCatom->getNeighborCenter(nfid);
	  Point location = Point(loc.getX(), loc.getY(), loc.getZ());
	  
	  //cout << "Empty: " << loc.getX() << loc.getY() << loc.getZ() << " <-- \n";
	  
	  tuple_vacant *tup = new tuple_vacant(hostCatom, location);
	  
	  handleMsg(TAG_VACANT, tup, false);
	}
      else
	{
	  links[ncid] = nfid;
	  neighbors++;
	  Point3D loc = HOSTCATOM.getNeighborCenter(nfid);
	  Point location = Point(loc.getX(), loc.getY(), loc.getZ());
	  
	  //cout << "Neighbor: " << loc.getX() << loc.getY() << loc.getZ() << " <-- \n";
	  handleMsg(TAG_NEIGHBOR, new tuple_neighbor(hostCatom, ncid, location), false);
	}
    }
  
  handleMsg(TAG_NEIGHBORCOUNT, new tuple_neighborCount(hostCatom, neighbors), false);
}

void P2CatomBase::newTick()
{
  //  cout << hostCatom << "::handling tick " << worldPtr->current_time << endl;
  int dark;

  if (worldPtr->current_time < 0)
    return;

  if (useMetaModuleHack()) {
    worldPtr->catomHash[hostCatom]->HACK_metamodule = HOSTCATOM.resources + 1;
  }

  if (HOSTCATOM.resources == -1)
  {	
    HOSTCATOM.setColor(0,0,0,255);
    return;
  }
  else if (HOSTCATOM.resources == 1)
  {
	dark = 64;
  }
  else
  {
	dark = 0;
  }

  if (inTargetShape(HOSTCATOM.getLocation(), "TARGETFILE"))
    HOSTCATOM.setColor(0,128+dark,128+dark,0);
  else
    HOSTCATOM.setColor(128+dark,128+dark,0,0);

  startTiming();

  if (oldResources != -1 && 
      oldResources != HOSTCATOM.resources) {
	
    handleMsg(TAG_RESOURCES, new tuple_state(hostCatom, oldResources), true);
    handleMsg(TAG_RESOURCES, new tuple_state(hostCatom, HOSTCATOM.resources), false);
      

    oldResources = HOSTCATOM.resources;
  }


  Catom *thisCatom = &(worldPtr->catomHash[hostCatom]->C);

  if (worldPtr->current_time == 0 || HOSTCATOM.resources != -1 && oldResources == -1)
  {
    reset();
  }
  else {
    int neighbors = 0;

    // Do all the deletes
    for (int i = 1; i <= NUM_FEATURES; i++)
      {
	featureID nfid = i;
	catomID ncid = thisCatom->getNeighbor(nfid);
	int nExists = ncid ? (worldPtr->catomHash[ncid]->C.resources - 1) / 2 + 1: 0;

	/* If there is no catom there or the catom there does not exist... */
	if (ncid != myNeighbors[nfid] || nExists != myExists[nfid])
	  {
	    catomID oldNeighbor = myNeighbors[nfid];

	    Point3D loc = HOSTCATOM.getNeighborCenter(nfid);
	    Point location = Point(loc.getX(), loc.getY(), loc.getZ());

	    if (oldNeighbor == 0 || myExists[nfid] == 0) {
	      handleMsg(TAG_VACANT, new tuple_vacant(hostCatom, location), true);
	    }
	    else {
	      links[oldNeighbor] = 0;
	      handleMsg(TAG_NEIGHBOR, new tuple_neighbor(hostCatom, oldNeighbor, location), true);
	      cleanup(oldNeighbor);
	    }
	  }

      }

    // Then do all the creates
    for (int i = 1; i <= NUM_FEATURES; i++)
      {
	featureID nfid = i;
	catomID ncid = thisCatom->getNeighbor(nfid);
	int nExists = ncid ? (worldPtr->catomHash[ncid]->C.resources - 1) / 2 + 1: 0;

	/* If there is no catom there or the catom there does not exist... */
	if (ncid != myNeighbors[nfid] || nExists != myExists[nfid])
	  {
	    myNeighbors[nfid]=ncid;
	    myExists[nfid] = nExists;

	    Point3D loc = HOSTCATOM.getNeighborCenter(nfid);
	    Point location = Point(loc.getX(), loc.getY(), loc.getZ());

	    if (ncid == 0 || nExists == 0) {
	      handleMsg(TAG_VACANT, new tuple_vacant(hostCatom, location), false);
	    }
	    else {
	      links[ncid] = nfid;
	      sendMsg(ncid, TAG_HELLO, false, NULL, sizeof(catomID));
	      handleMsg(TAG_NEIGHBOR, new tuple_neighbor(hostCatom, ncid, location), false);
	    }
	  }

      }
  }

  oldResources = HOSTCATOM.resources;    

  /* TODO: Decide if this is right. It handles all facts generated
     as a result of this message... */
  while(!msgQueue.empty())
    {
      queueItem *item = msgQueue.front();
      msgQueue.pop_front();
      handleMsg(item->type, item->data, item->del);
      delete item;
    }

  accumTime(endTiming());
    // *** instrumentation
}

void P2CatomBase::endTick()
{
}

bool P2CatomBase::messageHandler(P2Msg *msg)
{
  if (links[msg->from] <= 0) {
    return false;
  }

  /* MPAR: HACK HACK HACK */
  if (resetTime == worldPtr->current_time)
    return false;

  startTiming();

  if (!msg->route.empty())
    {
      sendMsg(msg->route, msg->type, msg->del, msg->data, 0 /* THIS IS WRONG */);
      accumTime(endTiming());
      return false;
    }

  if (msg->type == TAG_HELLO) {
    cleanup(msg->from);
    accumTime(endTiming());
    return false;
  }

  // Advance the clock (instrumentation)
  current_time = max(current_time, msg->time);

  // instrumentation
  current_time += ONE_HOP_LATENCY;

  // XXX need to get message size from subclass
  //current_time += (unsigned int)((8 + msg->distances.size() * 8) / BYTES_PER_MICRO_SECOND);

  handleMsg(msg->type, msg->data, msg->del);

  /* TODO: Decide if this is right. It handles all facts generated
     as a result of this message... */
  while(!msgQueue.empty())
    {
      queueItem *item = msgQueue.front();
      msgQueue.pop_front();
      handleMsg(item->type, item->data, item->del);
      delete item;
    }

  accumTime(endTiming());
  // *** instrumentation

  return false;
}

/* TODO:MPAR */
void P2CatomBase::sendMsg(unsigned int ncid, int type, bool del, void *data, unsigned int size)
{
      list <unsigned int> route;
      route.push_front(ncid);
      sendMsg(route, type, del, data, size);
}


void P2CatomBase::sendMsg(list <unsigned int> &route, int type, bool del, void *data, unsigned int size)
{
  Catom *thisCatom = &(worldPtr->catomHash[hostCatom]->C);
  Feature *featureMap = thisCatom->getFeatureMap();

  list<unsigned int> route2(route.begin(), route.end());
  int to = route2.front();
  route2.pop_front();

  P2Msg *msg = new P2Msg(P2Box, current_time, route2, type, del, data, hostCatom);

  messages_sent++;
  vector_elements_sent++;
  traffic_sent += size;

  /* The neighbor moved, but we haven't deleted it yet - drop message */
  if (links[to] <= 0) {
    return;
  }
  catomID ncid = thisCatom->getNeighbor(links[to]);
  if (ncid <= 0) {
    return;
  }

  // it's a compiler bug if links[to] doesn't exist. stl docs say we
  // get a default obj (featureID 0?) if not.
  featureMap[links[to]].getNetworkAdapter()->sendMessage(msg);
}

void P2CatomBase::startFindTime()
{
  current_find_time = clock();
}

void P2CatomBase::endFindTime()
{
  find_time += (clock() - current_find_time);
}

void P2CatomBase::accumTime(double t) {
  cpu_time += t;
  current_time += t;
}

void P2CatomBase::display() {
  worldPtr->oStart();

  cerr << "MY STATS" << endl;
  cerr << "--------" << endl;
  cerr << "Messages sent: " << messages_sent << endl;
  cerr << "Current time: " << current_time << endl;
  cerr << "CPU time: " << cpu_time << endl;
  cerr << "Queries: " << queries << endl;
  cerr << "Find time: " << find_time << endl;
  cerr << "Memory usage: " << memory_usage << endl;
  cerr << endl;

  cerr << "GLOBAL STATS" << endl;
  cerr << "--------" << endl;
  cerr << "Messages sent: " << P2CatomBase::global_messages_sent << endl;
  cerr << "Traffic sent: " << P2CatomBase::global_traffic_sent << " bytes"
       << endl;
  cerr << "End time: " << P2CatomBase::global_max_current_time << endl;
  cerr << "Max CPU time: " << P2CatomBase::global_max_cpu_time << endl;
  cerr << "Max Queries: " << P2CatomBase::global_max_queries << endl;
  cerr << "Max find time: " << P2CatomBase::global_max_find_time << endl;
  cerr << "Max memory usage: " << P2CatomBase::global_max_memory_usage << endl;
  cerr << endl;

  worldPtr->oEnd();
}



struct tuple_give {
  int refCount;
  addr var_0;
  addr var_1;

  tuple_give (addr var_0, addr var_1)
  {
    refCount = 1;
    this->var_0 = var_0;
    this->var_1 = var_1;
  }
};

struct tuple_create {
  int refCount;
  addr var_0;
  Point var_1;

  tuple_create (addr var_0, Point var_1)
  {
    refCount = 1;
    this->var_0 = var_0;
    this->var_1 = var_1;
  }
};

struct tuple_destroy {
  int refCount;
  addr var_0;
  addr var_1;

  tuple_destroy (addr var_0, addr var_1)
  {
    refCount = 1;
    this->var_0 = var_0;
    this->var_1 = var_1;
  }
};

void P2CatomBase::doMetaInit()
{
    if (inTargetShape(HOSTCATOM.getLocation(),"STARTFILE")) {
      HOSTCATOM.resources = rand() % 2;
    }
    else {
      HOSTCATOM.resources = -1;
    } 

//  HOSTCATOM.metamodule = 1 + (rand() % 2);
}

void P2CatomBase::doMetaGive(void *arg)
{
	tuple_give *tuple = (tuple_give *)arg;
	Catom *target = &(worldPtr->catomHash[tuple->var_1]->C);

	// Cannot give
	if (HOSTCATOM.resources != 1 ||
	    target->resources != 0)
		return;

	HOSTCATOM.resources = 0;
	target->resources = 1;
}

void P2CatomBase::doMetaCreate(void *arg)
{
	tuple_create *tuple = (tuple_create *)arg;
	Point3D p = Point3D(tuple->var_1.x, tuple->var_1.y, tuple->var_1.z);

	Catom *target = &(worldPtr->catomHash[HOSTCATOM.getNeighbor(HOSTCATOM.getNearestFeature(p))]->C);

	if (HOSTCATOM.resources != 1 ||
	    target->resources != -1)
		return;

	HOSTCATOM.resources = 0;
	target->resources = 0;
}

void P2CatomBase::doMetaDestroy(void *arg)
{
	tuple_destroy *tuple = (tuple_destroy *)arg;
	Catom *target = &(worldPtr->catomHash[tuple->var_1]->C);

	if (HOSTCATOM.resources != 0 ||
	    target->resources != 0)
		return;

	HOSTCATOM.resources = -1;
	target->resources = 1;
}

bool P2CatomBase::useMetaModuleHack(void)
{
  static bool useMetamodules = false;
  static bool inited = false;

  if (!inited) {
    inited = true;
    
    string val = worldPtr->search_key_value_list("USEMETAMODULEHACK");
    if (val == "true") {
      useMetamodules = true;
    }
  }

  return useMetamodules;
}
