///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Corporation and Carnegie Mellon University    //
// Contacts: raam @ cmu.edu                                                  //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

// DO NOT USE BEFORE CONSULTING ME. - RAM

// Not updated to work consistently with changes to routing speculation.
// clone() needs to maintain original messageID.
//   -- bdr

#ifndef MESSAGE_STRUCTURE_HXX
#define MESSAGE_STRUCTURE_HXX

#include "CodeModule.hxx"
#include "Network.hxx"
#include "LockInfo.hxx"
#include <list>

class Catom; 
class Message;
class LockInfo;
class STMessage;

using namespace std;

typedef int TreeID;

enum eLockPriority{
  LOW,
  NORMAL,
  HIGH,
  CRITICAL
};

enum EVENTTYPE {
  SEND_MESSAGE,
  RECEIVE_MESSAGE,
  PRINT_GLOBAL_METRICS,
  RENDER, 
  EXPLORE_ECHO,
  EXPLORE_ECHO_REGIONAL, 
  EXPLORE_REGIONAL_PC,
  EXPLORE_REGIONAL_CP,
  EXPLORE_REGIONAL_SURFACE_PC,
  EXPLORE_REGIONAL_SURFACE_CP,
  EXPLORE_GEOMETRIC_PC,
  EXPLORE_GEOMETRIC_CP,

  MESSAGE_TREE,
  MESSAGE_SURFACE_TREE_,
  MESSAGE_TO_ROOT,
  MESSAGE_TO_SURFACE_ROOT, 
  SUCK_HOLE,           // this creates a small tree to broadcast  to everyone and gets information from everyone
  SETUP_HOLE_CREATION, // in this mode we tell everyone where to move (motion planning)
  MOVE_MODE,			 // in this mode catoms actively try to move to one of the locations
  MOVE_STATUS_REQUEST,  // for querying a neigbor about a move status
  MOVE_STATUS_REPLY,  // for querying a neigbor about a move status
  MESSAGE_NEIGHBOR,   // this message is to be sent to  my neighbors
  STATE_MACHINE,
  TREE_BROADCAST,
  MOVE_HOLE,
  MESSAGE_FLASH,
  SMOOTH_CATOM_MOVE,  // Obsolete: This event was created to aid smooth catom move render events.
  DELETE_HOLE,
  TIMER
};

enum message_type {
  MSG_GLOBAL_SPANNING_TREE=0,
  MSG_GLOBAL_SPANNING_TREE_ACK,
  MSG_GLOBAL_SPANNING_TREE_NACK,
	
  MSG_REGIONAL_SPANNING_TREE,
  MSG_REGIONAL_SPANNING_TREE_CHG_PARENT,
  MSG_REGIONAL_SPANNING_TREE_ACK,
  MSG_REGIONAL_SPANNING_TREE_NACK,
	
  MSG_REGIONAL_SPANNING_TREE_WITH_LOCK,
  MSG_REGIONAL_SPANNING_TREE_WITH_LOCK_CHG_PARENT,
  MSG_REGIONAL_SPANNING_TREE_WITH_LOCK_ACK,
  MSG_REGIONAL_SPANNING_TREE_WITH_LOCK_NACK,
  MSG_REGIONAL_SPANNING_TREE_WITH_LOCK_ALREADY_LOCKED,	
	
  MSG_GEOMETRIC_SPANNING_TREE_WITH_LOCK,
  MSG_GEOMETRIC_SPANNING_TREE_WITH_LOCK_CHG_PARENT,
  MSG_GEOMETRIC_SPANNING_TREE_WITH_LOCK_ACK,
  MSG_GEOMETRIC_SPANNING_TREE_WITH_LOCK_NACK,
  MSG_GEOMETRIC_SPANNING_TREE_WITH_LOCK_ALREADY_LOCKED,
	
  MSG_GEOMETRIC_SPANNING_TREE_BROADCAST,
  MSG_GEOMETRIC_SPANNING_TREE_BROADCAST_LOC,
	
  MSG_SURFACE_SPANNING_TREE,
			
			
  MSG_LINK_FID_REQ,
  MSG_LINK_FID_ACC,
  MSG_LINK_FID_DEN,
	
  MSG_REMOVE_LINK_FID_REQ,
  MSG_REMOVE_LINK_FID_ACC,
  MSG_REMOVE_LINK_FID_DEN,
		
  MSG_UNLINK_FID_REQ,
  MSG_UNLINK_FID_ACC,
  MSG_UNLINK_FID_DEN,
	
  MSG_REMOVE_UNLINK_FID_REQ,
  MSG_REMOVE_UNLINK_FID_ACC,
  MSG_REMOVE_UNLINK_FID_DEN,
	
  MSG_HOLE_TREE,
  MSG_HOLE_TREE_ACK,
  MSG_LEADER_ELECT,
  MSG_LEADER_ELECT_ACK,
	
  MSG_INTERNAL_HOLE_MVMT,
  MSG_ADD_TO_TREE,
  MSG_REM_FROM_TREE,
	
  MSG_DESTROY_TREE,
	
  MSG_SHAPE_CM_SEND,
  MSG_SHAPE_CM_REQ,
	
  MSG_SHAPE_CM_DELTA_SEND,
  MSG_SHAPE_CM_DELTA_REQ,
	
  MSG_SHAPE_CM_DELTA_ACK
	    
	    
};


// this is for messaging
enum MESSAGE_TYPE {SEND_INFO,MY_INFO,MOVE_COMMAND,BARRIER_INFO, ELECT_LEADER, LEADER_ELECTED, UNLOCK_MESSAGE};

// movement barrier type
enum MOVEMENT_BARRIER_TYPE {DUMMY, HOLE_CREATION_ATTEMPT, HOLE_CREATION, HOLE_MOVEMENT, HOLE_RELEASE, LEADER_ELECTION, HOLE_DELETION };

// Leadertype while electing leader
enum LEADERTYPE {DIRECTION_LEADER};

// catom's current role
enum CATOM_ROLE {FREE_CATOM, HOLE_MEMBER, HOLE_CREATING, SMOOTHING};


class LockStructMessage
{
  public:
    long lockId;
    long lockClassID;
    catomID owner;
    long int timeout;
    eLockPriority lPriority;


};

class ConsensusMessage : public Message {
  public:

    catomID from;
    message_type mtype;
    map<long,double> stateInfo;
    catomID largestUID;
  
  
    ConsensusMessage(MailboxID _id,catomID _from,message_type _mtype) : Message(_id),
    from(_from),
    mtype(_mtype)
    {

    }
  
    ConsensusMessage(MailboxID _id,catomID _from,message_type _mtype,
		     map<long ,double> _mp,catomID _largestID=0) : Message(_id),
    from(_from),
    mtype(_mtype),
    stateInfo(_mp),
    largestUID(_largestID)
    {

    }
    
    virtual Message* clone()
    {
      ConsensusMessage *cm = new ConsensusMessage(Message::mailboxID,from,
	  mtype,stateInfo,largestUID);
      return cm;
    }

};
class STMessage : public Message {
  public:
  // Put getters and setters.
    catomID root;
    catomID from;
    message_type mtype;
    TreeID treeID;
    unsigned int hopsToRoot;
    unsigned int treeRadius;
    LockStructMessage lockInfo;
    unsigned int childrenCount;
    Point3D rootLoc;
    float geomRadius;
    vector<Point3D> childrenLoc;
    bool resend;
    vector<Point3D> data1; // need to clean up this and put this in holemessage
    vector<Point3D> data2;
    void (*ptr2Func)(void*,vector<Point3D>,int);
    void (*callbackWhenDone)(void*,int);
    void* callbackObject;
    catomID replyFrom;
    bool boolData;
  
  
    STMessage(MailboxID _id): Message(_id) 
    {
      hopsToRoot = 0;
      resend = false;
    //	lockInfo = NULL;
    }
    ~STMessage()
    {
      data1.clear();
      childrenLoc.clear();
    
    }
  
    STMessage(MailboxID _id,catomID _root,catomID _from,message_type _mtype,TreeID _treeID) : Message(_id),
    root(_root), 
    from(_from),
    mtype(_mtype),
    treeID(_treeID)
    {
      childrenCount = 0;
      resend = false;
      boolData = false;
    }
    void setLockInfo(long _lid, long _cid, catomID _cown, long int _tout, eLockPriority _l)
    {
      lockInfo.lockId=_lid;
      lockInfo.lockClassID = _cid;
      lockInfo.owner = _cown;
      lockInfo.timeout = _tout;
      lockInfo.lPriority = _l;
    }

    virtual Message* clone()
    {
      STMessage* msg =  new STMessage(Message::mailboxID);
    
      msg->root= root;
      msg->from = from;
      msg->mtype = mtype;
      msg->treeID = treeID;
      msg->hopsToRoot = hopsToRoot;
      msg->treeRadius = treeRadius;
      msg->lockInfo = lockInfo;
      msg->childrenCount = childrenCount;
      msg->rootLoc = rootLoc;
      msg->geomRadius = geomRadius;
      msg->childrenLoc = childrenLoc;
      msg->resend = resend;
  //void* data1;
      msg->data1 = data1; // need to clean up this and put this in holemessage
      msg->data2 = data2;
      msg->ptr2Func = ptr2Func;
      msg->callbackWhenDone = callbackWhenDone;
      msg->callbackObject = callbackObject;
      msg->replyFrom = replyFrom;
      msg->boolData = boolData;
    
      return msg;

    }
  
};

class LockMessage : public Message {
  public:
  // Put getters and setters.
    catomID from;
    message_type mtype;
    unsigned int lockID;
  
  
    LockMessage(MailboxID _id): Message(_id) 
    {
    }
  
    LockMessage(MailboxID _id,catomID _from,message_type _mtype,
		unsigned int _lockId) : Message(_id),
    from(_from),
    mtype(_mtype),
    lockID(_lockId){ }
				      
    virtual Message* clone()
    {
      LockMessage* msg =  new LockMessage(Message::mailboxID);
      
      msg->from = from;
      msg->mtype = mtype;
      msg->lockID = lockID;
      
      return msg;
    }
  
};

    class HoleMessage : public Message {
      public:
  // Put getters and setters.
	catomID from;
	message_type mtype;
	unsigned int holeID;
  
  
	HoleMessage(MailboxID _id): Message(_id) 
	{
	}
  
	HoleMessage(MailboxID _id,catomID _from,message_type _mtype,
		    unsigned int _holeId) : Message(_id),
	from(_from),
	mtype(_mtype),
	holeID(_holeId){ }
	
	virtual Message* clone()
	{
	  HoleMessage* hm = new HoleMessage(Message::mailboxID);
	  hm->from = from;
	  hm->mtype = mtype;
	  hm->holeID = holeID;
	  
	  return hm;
	  
	  
	}
  
    };
#endif
