///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Coproration and Carnegie Mellon University    //
// Contacts: raam @ cmu.edu                                                  //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef LOCK_INFO_HXX
#define LOCK_INFO_HXX

#include <list>
#include <map>
#include <algorithm>

#include "GlobalConstants.hxx"
#include "MessageStructure.hxx"
#include "CatomWorld.hxx"
#include "CodeModule.hxx"

#ifndef LOCK_MOTION_CLASS
#define LOCK_MOTION_CLASS 8
#endif

class CatomWorld;

extern CatomWorld* worldptr;

// delete todo:
// use SoftwareTimer to forcibly unlock locks that have timed out
// remove prirotuty
// rename to pthread compat
// rename classID to lockID and lockID to _userData. Do away with owner catom info.
// put them in a seprate codemodule.
// separate out the fid state locks.


enum fidState{
	UNLOCKED,
	LOCKED_LINKED,
	LOCKED_UNLINKED
};

// enum LockClassType{
// 	GENERIC_SPANNING_TREE_WITH_LOCK
// 
// };


using namespace std;

const long LOCK_HOLE = 2341;

const int TIMEOUT_DEFAULT = 100000;
const int FEATURE_COUNT = 6; //FIX ME //NUM_FEATURES;

class __lockInfo
{
	public:
		long lockClassID; // identify the kind of lock - used to check if co-existence is possible.
		catomID ownerCatomID; // who owns this lock.
		long int timeout;	// time until which this lock is valid.
		eLockPriority lockPriority; // Priority of lock.
		map<featureID,bool> fidlinked;// list and states of locks on the fid.
		
};

class __fidLockInfo
{
	
	public:
		list<long>  linkedFID; // list of CatomIDs for this locked fid
		list<long>  unlinkedFID; // list of CatomIDs for this unlocked fid
		

};

typedef void(CodeModule::*lockHandlerPtr)(uint,featureID,bool); // _lockId,_fid,success/failure
typedef map<long,__lockInfo/*,greater<long>*/ > LockMap;


class LockInfo {
	public:
		LockMap locks;
		map<long,long> logicalClassID;
		__fidLockInfo fidLocks[FEATURE_COUNT];
		pthread_mutex_t objectMutex; 
		catomID myself;
		Feature* featureMap;
		map<unsigned int, 
		pair<CodeModule*, 
		pair<lockHandlerPtr, lockHandlerPtr> > > lockHandlers;
		long randVal;
		

		bool _addLockInternal(long _lockId,long _lockClassID, catomID _owner, long int _timeout,eLockPriority lockP);
		bool _removeLockInternal(long _lockId);
		void _lock();
		void _unlock();
		void _registerLockHandler(uint, CodeModule*, lockHandlerPtr,lockHandlerPtr);
		bool _lockable(long _classID,eLockPriority _lP);

	public:
		LockInfo(catomID _cid);
		LockInfo(){}
		bool addLock(long _lockId,long _lockClassID,catomID _owner, long int _timeout=TIMEOUT_DEFAULT,eLockPriority _lP= NORMAL );
		bool upgradeLock(long _lockId,long _lockClassID,catomID _owner, 
				 long int _timeout,eLockPriority _lP);
		bool removeLock(long _lockId);
		bool lockable(long _classID,eLockPriority _lP = NORMAL);
		bool addFIDLock(long _lockId,featureID _fid,bool _state,
				CodeModule* cm,lockHandlerPtr _lkPtr,lockHandlerPtr _ulkPtr,
				eLockPriority _lP = NORMAL);
		bool removeFIDLock(long _lockId,featureID _fid);
		bool _removeFIDLock(long _lockId,featureID _fid);
		fidState getFIDLockState(featureID _fid);
		void printLocks();
		bool messageHandler(LockMessage *msg);
		const long getLockClass(long _lockID);
		const long getTimeout(long _lockID);
		const catomID getOwnerCatomID(long _lockID);
		const eLockPriority getLockPriority(long _lockID);
		
};

#endif
