///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Coproration and Carnegie Mellon University    //
// Contacts: raam @ cmu.edu                                                  //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include <LockInfo.hxx>
#include "CatomSim.hxx"

const long LockInfo::getTimeout(long _lockID)
{

  if(locks.find(_lockID)==locks.end())
    return -1;
  else
    return locks[_lockID].timeout;
  
}
const catomID LockInfo::getOwnerCatomID(long _lockID)
{
  if(locks.find(_lockID)==locks.end())
    return -1;
  else
    return locks[_lockID].ownerCatomID;

}
const eLockPriority LockInfo::getLockPriority(long _lockID)
{
  if(locks.find(_lockID)==locks.end())
    return LOW;
  else
    return locks[_lockID].lockPriority;
}
		
void LockInfo::printLocks()
{
  worldPtr->oStart();
  map<long,long>::iterator iter = logicalClassID.begin();

  if(iter==logicalClassID.end())
    cerr<<"No lock found"<<endl;
  while(iter!=logicalClassID.end())
  {
    cerr<<iter->first<<" maps to "<<iter->second<<endl;
    iter++;  
  }
  
  worldPtr->oEnd();
}
bool LockInfo::_addLockInternal(long _lockId,long _lockClassID, catomID _owner, long int _timeout,eLockPriority lockP)
{
	__lockInfo lock_temp;
	lock_temp.lockClassID = _lockClassID;
	lock_temp.ownerCatomID = _owner;
	lock_temp.timeout = _timeout;
	lock_temp.lockPriority = lockP;
	
	locks[_lockId] = lock_temp;
	logicalClassID[_lockClassID]=_lockId;
	return true;	
}

const long LockInfo::getLockClass(long _lockId)
{
  if(locks.find(_lockId)==locks.end())
    return -1;
  else
    return locks[_lockId].lockClassID;
}

bool LockInfo::_removeLockInternal(long _lockId)
{
	LockMap::iterator lmiter = locks.find(_lockId);
	if(lmiter==locks.end())
		return true; // removed an inexisting lock.
	logicalClassID.erase(logicalClassID.find(lmiter->second.lockClassID));	
	locks.erase(lmiter);
	return true;
}

void LockInfo::_lock()
{
	int err = pthread_mutex_lock(&objectMutex);
	if(err) {
		worldPtr->oStart();
		cerr << "can't lock mutex5 : " << strerror(errno) << endl;
		worldPtr->oEnd();
		exit(1);
	}
}

void LockInfo::_unlock()
{
	int err = pthread_mutex_unlock(&objectMutex);
	if(err) {
		cerr << "can't unlock mutex : " << strerror(errno) << endl;
		exit(1);
	}
}

void LockInfo::_registerLockHandler(uint _lid, CodeModule* cm, lockHandlerPtr lhPtr,lockHandlerPtr ulhPtr)
{
	lockHandlers[_lid]=make_pair(cm,make_pair(lhPtr,ulhPtr));
}


LockInfo::LockInfo(catomID _cid): myself(_cid)
{
	pthread_mutex_init(&objectMutex, NULL);
	featureMap = worldPtr->catomHash[_cid]->C.getFeatureMap();
	randVal = rand();
}

fidState LockInfo::getFIDLockState(featureID _fid)
{
	fidState retval;
	_lock();
	if((fidLocks[_fid].linkedFID.size()-fidLocks[_fid].unlinkedFID.size())>0)
		retval = LOCKED_LINKED;
	else if((fidLocks[_fid].linkedFID.size()-fidLocks[_fid].unlinkedFID.size())<0)
		retval = LOCKED_UNLINKED;
	else if((fidLocks[_fid].linkedFID.size()-fidLocks[_fid].unlinkedFID.size())==0)
		retval = UNLOCKED;	
	_unlock();
	return retval;
}

bool LockInfo::addFIDLock(long _lockId,featureID _fid,bool _state,
			  CodeModule* cm,lockHandlerPtr _lkPtr,lockHandlerPtr _ulkPtr,eLockPriority _lP)
{
	_lock();
	message_type mtype;
	if(_state)
		mtype = MSG_LINK_FID_REQ;
	else
		mtype = MSG_UNLINK_FID_REQ;
	LockMessage *sendmess = new LockMessage("lockMessageHandlerLock",myself,mtype,_lockId);
	if(!featureMap[_fid].getNetworkAdapter()->sendMessage(sendmess))
  	;//delete sendmess;	
	else
	{
		_registerLockHandler(_lockId,cm,_lkPtr,_ulkPtr);
		_unlock();
		return true;
	}
	_unlock();
	return false;
}

bool LockInfo::_removeFIDLock(long _lockId,featureID _fid)
{
  message_type mtype;
  if(locks[_lockId].fidlinked[_fid])
    mtype = MSG_REMOVE_LINK_FID_REQ;
  else
    mtype = MSG_REMOVE_UNLINK_FID_REQ;
  LockMessage *sendmess = new LockMessage("lockMessageHandlerLock",myself,mtype,_lockId);	
  if(!featureMap[_fid].getNetworkAdapter()->sendMessage(sendmess))
    ;//delete sendmess;	
  else
  {
    return true;
  }
  return false;	
}

bool LockInfo::removeFIDLock(long _lockId,featureID _fid)
{
	_lock();
	message_type mtype;
	if(locks[_lockId].fidlinked[_fid])
		mtype = MSG_REMOVE_LINK_FID_REQ;
	else
		mtype = MSG_REMOVE_UNLINK_FID_REQ;
	LockMessage *sendmess = new LockMessage("lockMessageHandlerLock",myself,mtype,_lockId);	
	if(!featureMap[_fid].getNetworkAdapter()->sendMessage(sendmess))
  	;//delete sendmess;	
	else
	{
		_unlock();
		return true;
	}
	_unlock();
	return false;	
}

bool LockInfo::upgradeLock(long _lockId,long _lockClassID,catomID _owner, long int _timeout,eLockPriority _lP)
{
  _lock();
  if(_lockable(_lockClassID,_lP))
  {
    bool retval = _addLockInternal(_lockId,_lockClassID,_owner,_timeout,_lP);
    _unlock();
    return retval;
  }
  else
  {
    LockMap::iterator lmiter = locks.find(_lockId);
    if(lmiter==locks.end())
    {
      _unlock();
      return false; // removed an inexisting lock.
    }
    long cID = lmiter->second.lockClassID;
    map<long,long>::iterator iter = logicalClassID.find(cID);
    logicalClassID.erase(iter);
    logicalClassID[_lockClassID]=_lockId;

    lmiter->second.lockClassID = _lockClassID;
    lmiter->second.ownerCatomID = _owner;
    lmiter->second.timeout = _timeout;
    lmiter->second.lockPriority = _lP;    
    _unlock();
    return true;
  }
  
//  _unlock();
//  return false;
}
bool LockInfo::addLock(long _lockId,long _lockClassID,catomID _owner, long int _timeout,eLockPriority _lP )
{
	_lock();
	if(_lockable(_lockClassID,_lP))
	{
		bool retval = _addLockInternal(_lockId,_lockClassID,_owner,_timeout,_lP);
		_unlock();
		return retval;
	}
	_unlock();
	return false;
}

bool LockInfo::removeLock(long _lockId)
{
	_lock();
	LockMap::iterator lmiter = locks.find(_lockId);
	if(lmiter==locks.end())
	{
		_unlock();
		return true; // removed an inexisting lock.
	}
	long cID = lmiter->second.lockClassID;
	map<long,long>::iterator iter = logicalClassID.find(cID);
	logicalClassID.erase(iter);
	
	
// 	map<featureID,bool>::iterator miter = locks[iter->second].fidlinked.begin();
// 	while(miter!=locks[iter->second].fidlinked.end())
// 	{
// 		//_removeFIDLock(iter->second,miter->first);
// 		miter++;
// 	}
// 	
// 	locks.erase(lmiter);
		
	_unlock();		
	return true;
}

bool LockInfo::_lockable(long _classID,eLockPriority _lP)
{
	//_lock();
	map<long,long>::iterator iter = logicalClassID.find(_classID);
	if(iter==logicalClassID.end() || locks[iter->second].lockPriority<_lP) // if classID is not found.
	{
		//_unlock();
		return true;
	}
	if(locks[iter->second].timeout <= worldPtr->current_time) // if lock has expired, delete and return true
	{
		map<featureID,bool>::iterator miter = locks[iter->second].fidlinked.begin();
		while(miter!=locks[iter->second].fidlinked.end())
		{
			removeFIDLock(iter->second,miter->first);
			miter++;
		}
		locks.erase(locks.find(iter->second));
		logicalClassID.erase(iter);
		//_unlock();	
		return true;
	}
	//_unlock();
	return false; // else lock exists and hasn't expired.'
}



bool LockInfo::lockable(long _classID,eLockPriority _lP)
{
	_lock();
	map<long,long>::iterator iter = logicalClassID.find(_classID);
	if(iter==logicalClassID.end() || 
		  (locks[iter->second].lockPriority<_lP && 
		  locks[iter->second].timeout >= worldPtr->current_time
		  )) // if classID is not found.
	{
		_unlock();
		return true;
	}

	if(locks[iter->second].timeout <= worldPtr->current_time) // if lock has expired, delete and return true
	{
		map<featureID,bool>::iterator miter = locks[iter->second].fidlinked.begin();
		while(miter!=locks[iter->second].fidlinked.end())
		{
			removeFIDLock(iter->second,miter->first);
			miter++;
		}
		locks.erase(locks.find(iter->second));
		logicalClassID.erase(iter);
		_unlock();	
		return true;
	}
	_unlock();
	return false; // else lock exists and hasn't expired.'
}
		
bool LockInfo::messageHandler(LockMessage *msg)
{

  return false;
}


