///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Coproration and Carnegie Mellon University    //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef __LOCALIZE2_H
#define __LOCALIZE2_H

#include "CodeModule.hxx"
#include "CatomWorld.hxx"
#include "mymailbox.hxx"
#include <fstream>

CODE_MODULE_PROTOTYPE( Localize2, Localize2 );
using namespace std;

extern CatomWorld *worldPtr;

struct position {
	double x;
	double y;
	double theta;
	//position& operator=( const position& a ) { x=a.x; y=a.y; theta=a.theta; return *this; };
	position& operator+=( const position& a ) { x+=a.x; y+=a.y; theta+=a.theta; return *this; };
	position& operator-=( const position& a ) { x-=a.x; y-=a.y; theta-=a.theta; return *this; };
	position& operator*=( double s ) { x*=s; y*=s; theta*=s; return *this; };
	position& operator/=( double s ) { x/=s; y/=s; theta/=s; return *this; };
	position operator+(const position& a) const { position x=*this; return x+=a; };
	position operator-(const position& a) const { position x=*this; return x-=a; };
	position operator-() const { position x; return x-=*this; }		// unary -
	position operator*(double s) const { position x=*this; return x*=s; };
	position operator/(double s) const { position x=*this; return x/=s; };
};

struct box {
	position min;
	position max;
};

struct obs {  // observation angle theta, and reverse observation theta
	double loc;
	double rem;
};

typedef list<obs> obslist;  // list of observations between a catom and one neighbor

typedef map< pair<catomID,catomID>, set< pair<catomID,catomID> > > edgemap;




class Localize2 : public CodeModule {
	static pthread_mutex_t lock; // some ODE operations are not thread safe
	static enum mode_type { MODE_NULL, MODE_INIT_NULL, MODE_INIT_REAL, MODE_HIER, 
				MODE_TREE, MODE_BOXPROP, MODE_GRADIENT, MODE_TREE_GRADIENT }
		mode;  // artificial global synchronization through mode
	static int num_msgs_this_tick;
	static int num_msgs;
	static bool debug;
	static bool color_by_root;
	static bool use_rk4;
	static bool randtheta;
	static bool usevel;
	static bool move_catoms;
	static bool msgs_pending;
	static bool use_hier_s;
	static double veldamp;
	static double init_scale;
	static double root_P;
	static catomID root_node;
	static unsigned int prop_delay;
	static unsigned int binout_last_m;
	static int grad_steps;
	static bool binout_allgrad;
	static double group_k;
	static set<catomID> pieces;
	static ofstream binout;
	unsigned int prop_delay_count;
	map<catomID,position> my_nei;
	map<catomID,obslist> my_obs;
	box my_box;
	position my_x;  // x,y,theta
	catomID my_root;
	set<catomID> members;
	static edgemap all_edges;
	set<catomID> my_edges;
	position savedpos;
	position my_vel;
	bool prop_constraints;
	bool box_done;
	int max_ttl;
	int pgroup;
	class mymsg {
	public:
		enum { M_EMPTY, M_BOX, M_GRAD} type;
		union {
			struct {
				catomID i;
				int ttl;
				box box_i;
			} boxmsg;
			struct {
				catomID i;
				catomID root;
				position x_i;
			} gradmsg;
		};
		mymsg() : type(M_EMPTY) {};
	};
	mymailbox<mymsg> mail;
	void fix_position( double x, double y, double theta );
	void fix_position();
	void move_catom();
	void do_binout();
public:
	Localize2(catomID _hostCatom) : CodeModule(_hostCatom) {
		if (mode==MODE_NULL) {
			mode = MODE_BOXPROP;
			string tmp;
			tmp = worldPtr->search_key_value_list( "Localize2_root_node" );
			if (tmp!="") root_node = strtoul( tmp.c_str(), 0, 0 );
			tmp = worldPtr->search_key_value_list( "Localize2_root_P" );
			if (tmp!="") root_P = strtod( tmp.c_str(), 0 );
			tmp = worldPtr->search_key_value_list( "Localize2_color_by_root" );
			if (tmp=="true") color_by_root = true;
			else if (tmp=="false") color_by_root = false;
			tmp = worldPtr->search_key_value_list( "Localize2_move_catoms" );
			if (tmp=="true") move_catoms = true;
			else if (tmp=="false") move_catoms = false;
			tmp = worldPtr->search_key_value_list( "Localize2_debug" );
			if (tmp=="true") debug = true;
			else if (tmp=="false") debug = false;
			tmp = worldPtr->search_key_value_list( "Localize2_init" );
			if (tmp=="null" || tmp=="NULL") mode=MODE_INIT_NULL;
			else if (tmp=="real") mode=MODE_INIT_REAL;
			else if (tmp=="tree") mode=MODE_TREE;
			else if (tmp=="box") mode=MODE_BOXPROP;
			else if (tmp=="treegrad") mode=MODE_TREE_GRADIENT;
			else if (tmp=="hier") { mode=MODE_HIER; use_hier_s=false; }
			else if (tmp=="hier_s") { mode=MODE_HIER; use_hier_s=true; }
			tmp = worldPtr->search_key_value_list( "Localize2_rk4" );
			if (tmp=="true") use_rk4=true;
			else if (tmp=="false") use_rk4=false;
			tmp = worldPtr->search_key_value_list( "Localize2_randtheta" );
			if (tmp=="true") randtheta=true;
			else if (tmp=="false") randtheta=false;
			tmp = worldPtr->search_key_value_list( "Localize2_usevel" );
			if (tmp=="true") usevel=true;
			else if (tmp=="false") usevel=false;
			tmp = worldPtr->search_key_value_list( "Localize2_prop_delay" );
			if (tmp!="") prop_delay = strtoul( tmp.c_str(), 0, 0 );
			tmp = worldPtr->search_key_value_list( "Localize2_grad_steps" );
			if (tmp!="") grad_steps = strtoul( tmp.c_str(), 0, 0 );
			tmp = worldPtr->search_key_value_list( "Localize2_binout_allgrad" );
			if (tmp=="true") binout_allgrad = true;
			else if (tmp=="false") binout_allgrad = false;
			tmp = worldPtr->search_key_value_list( "Localize2_damp" );
			if (tmp!="") veldamp = strtod( tmp.c_str(), 0);
			tmp = worldPtr->search_key_value_list( "Localize2_init_scale" );
			if (tmp!="") init_scale = strtod( tmp.c_str(), 0);
			tmp = worldPtr->search_key_value_list( "Localize2_group_k" );
			if (tmp!="") group_k = strtod( tmp.c_str(), 0);
			tmp = worldPtr->search_key_value_list( "Localize2_binout_last_m" );
			if (tmp!="") binout_last_m = strtoul( tmp.c_str(), 0, 0);
			tmp = worldPtr->search_key_value_list( "Localize2_binfile" );
			if (tmp=="") tmp="binout.dat";
			binout.open( tmp.c_str(), ofstream::binary | ofstream::trunc );
		}
		else if (randtheta) {
			Point3D pos = HOSTCATOM.getLocation();
			double theta = 2*M_PI*(double)rand() / ((double)(RAND_MAX)+1.0);
			dQuaternion q;
			dQFromAxisAndAngle( q, 0, 0, 1, theta );
			dBodySetQuaternion( HOSTCATOMSIM->body, q );
		}
	};
	virtual void newTick();	
	virtual void endTick();
        virtual void simulationStart();
	virtual void oracle();
};

#endif
