///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Coproration and Carnegie Mellon University    //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef __LOCALIZE_H
#define __LOCALIZE_H

#include "CodeModule.hxx"
#include "CatomWorld.hxx"
#include "mymailbox.hxx"

CODE_MODULE_PROTOTYPE( Localize, Localize );
using namespace std;

extern CatomWorld *worldPtr;

class Localize : public CodeModule {
	int mode;
	dBodyID body;
	static dWorldID world;
	static bool debug;
	static bool color_by_root;
	static bool move_catoms;
	static double root_P;
	static catomID root_node;
	bool changed, subtree_acked;
	catomID rootID, parentID;
	int num_neighbors, num_replied;
	set<catomID> children;
	class mymsg {
	public:
		catomID rootID;
		catomID sender;
		Point3D myPos;
		Point3D yourPos;
		Point3D otherPos;
		double otherDist;
		char type;
		mymsg() : type(0) {};
	};
	mymailbox<mymsg> mail;
	struct info {
		featureID fid;
		catomID nid;
		catomID rootID;
		Point3D pos;
		bool known_pos;
		bool has_replied;
		bool has_been_acked;
	};
	vector<info> neigh;
	struct locus {
		Point3D a, b;
		double r;
		int m;
	} L;
public:
	Localize(catomID _hostCatom) : CodeModule(_hostCatom) {
		if (world==0) {
			world=dWorldCreate();
			string tmp;
			tmp = worldPtr->search_key_value_list( "Localize_root_node" );
			if (tmp!="") root_node = strtoul( tmp.c_str(), 0, 0 );
			tmp = worldPtr->search_key_value_list( "Localize_root_P" );
			if (tmp!="") root_P = strtod( tmp.c_str(), 0 );
			tmp = worldPtr->search_key_value_list( "Localize_color_by_root" );
			if (tmp=="true") color_by_root = true;
			else if (tmp=="false") color_by_root = false;
			tmp = worldPtr->search_key_value_list( "Localize_move_catoms" );
			if (tmp=="true") move_catoms = true;
			else if (tmp=="false") move_catoms = false;
			tmp = worldPtr->search_key_value_list( "Localize_debug" );
			if (tmp=="true") debug = true;
			else if (tmp=="false") debug = false;
		}
		body = dBodyCreate(world);
	};
	virtual void newTick();	
	virtual void endTick();
        virtual void simulationStart();
};

#endif
