///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Corporation and Carnegie Mellon University    //
// Contacts: casey.j.helfrich @ intel.com                                    //
//           bdr @ cs.cmu.edu                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include <iostream>
#include <errno.h>
#include <string.h>

#include "InterContactTest.hxx"
#include "CatomWorld.hxx"
#include "CatomSim.hxx"

CODE_MODULE_DECLARATION( InterContactTest, InterContactTest );

using namespace std;

void InterContactTest::newTick() {
/*
	if (hostCatom==10000) {
		HOSTCATOMSIM->magnet_state[1] = 1;
		HOSTCATOMSIM->magnet_state[2] = 1;
	} else {
		HOSTCATOMSIM->magnet_state[(int)NUM_FEATURES/2] = -1;
		HOSTCATOMSIM->magnet_state[(int)NUM_FEATURES/2+1] = -1;
	}
*/
}

void InterContactTest::endTick() {
}

void InterContactTest::simulationStart() {
}

static void move_catom( CatomSim *c, double x, double y, double theta) {
	dBodySetPosition( c->body, x, y, 1 );
	dQuaternion q;
	dQFromAxisAndAngle( q, 0, 0, 1, theta );
	dBodySetQuaternion( c->body, q );
}


void InterContactTest::oracle() {
  //cout << "InterContactTest Oracle: running concurrently with simulationStart\n";
  oracleYield();
  //cout << "InterContactTest Oracle: running with other oracles only\n";
  hash_map<const unsigned long, CatomSim *, hash<const unsigned long>, equl>::iterator cit = worldPtr->catomHash.begin();
  CatomSim *c = cit->second;
  move_catom( c, 0, 0, 0 );
  cit++;
  c = cit->second;
  double t1, t2, D = 2;
  double max_angle = 60;
  double angle_step = 1;
  string tmp;
  tmp = worldPtr->search_key_value_list( "ICT_D" );
  if (tmp!="") D = strtod( tmp.c_str(), 0);
  for ( t1 = 0; t1<=max_angle; t1+=angle_step ) {
	double x = cos( t1*M_PI/180 ) * D * CatomSim::catom_radius;
	double y = sin( t1*M_PI/180 ) * D * CatomSim::catom_radius;
	cout << "TEST: " << t1 << " ";
	for ( t2 = t1+180-max_angle; t2<=t1+180+max_angle; t2+=angle_step ) {
		//cout << "InterContactTest Oracle: running with other oracles only\n";
		move_catom( c, x, y, t2*M_PI/180 );
		oracleYield();
		//cout << "InterContactTest Oracle: running concurrently with newTick, endTick\n";
		oracleYield();
		//cout << "InterContactTest Oracle: running with other oracles only\n";
		double v = -1;
		list<CatomSim::sensor_val>::const_iterator it;
		for ( it = c->sensor_vals.begin(); 
			it != c->sensor_vals.end(); it++ ) {
			if ( it->siglevel > v ) v=it->siglevel;
		}
		cout << (int)(floor(100*v+0.5)) << " ";
	}
	cout << "\n";
  }
}
