///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Coproration and Carnegie Mellon University    //
// Contacts: casey.j.helfrich @ intel.com                                    //
//           bdr @ cs.cmu.edu                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef __HIERARCHY_H
#define __HIERARCHY_H

class Catom;
class Message;

#include <map>
#include <set>
#include <string>

#include "CodeModule.hxx"
#include "Network.hxx"
#include "Debugging/Debugging.hxx"

class Hierarchy;

class ChildRegMsg : public Message {
public:
  ChildRegMsg(Hierarchy* _hchy, bool _isChild);
  ChildRegMsg(MailboxID _mID, catomID _childID, bool _isChild);
  
  catomID childID;
  bool isChild;

  virtual Message* clone() {
    ChildRegMsg* c = new ChildRegMsg(mailboxID, childID, isChild);
    c->messageID = this->messageID;
    return c;
  }
};

class ChildData {
public:
  ChildData();
  virtual ~ChildData();

  virtual ChildData* clone() = 0;
};

class Hierarchy : public CodeModule {
  friend class LandmarkMsg;
  friend class LandmarkBeacon;
  
public:
  Hierarchy(catomID _hostCatom, string _hierarchyName);
  virtual ~Hierarchy();
  string getHierarchyName();
  
protected:
  // Hierarchy subclasses should make sure to call Hierarchy:: version for CodeModule virtual methods like these
  virtual void simulationStart();
  virtual void simulationEnd();
  virtual void endTick();
  
  virtual void dumpStats();
  
  // Allocate an object to store information about a child; stored in the childData map below
  virtual ChildData* newChildDataObject();
  
private:
  // Information about children; key list maintained by hierarchy, contents maintained by subclasses
  map<catomID, ChildData*> childData;
protected:
  list<catomID> childCatomIDs();
  virtual ChildData* getChildData(catomID);
  virtual void  setChildData(catomID, ChildData*);
  bool childRegHandler(Message* _msg);

  virtual bool sendMsgToParent(Message* msg) = 0;
  
  int getLevel();
  
  StateFile::Module* StateFileConstructor( void );

public:
  string hierarchyName;
  string childRegMsgBox;

private:
  catomID parent;
protected:
  catomID getParent();
  void setParent(catomID newParent);

protected:
  int level;
  //IVAR(unsigned long, parent);
  //IVAR(int, level);
  //IVAR(int, totallyUnused);
};

#endif
