///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Coproration and Carnegie Mellon University    //
// Contacts: casey.j.helfrich @ intel.com                                    //
//           bdr @ cs.cmu.edu                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include <iostream>
#include <limits.h>

#include "Hierarchy.hxx"

#include "Catom.hxx"
#include "CatomSim.hxx"
#include "CatomWorld.hxx"
#include "Network.hxx"

#define HIERARCHY_DEBUG (true)

ChildData::ChildData() { }
ChildData::~ChildData() { }

ChildRegMsg::ChildRegMsg(Hierarchy* _hchy, bool _isChild) :
  Message(_hchy->childRegMsgBox),
  childID(_hchy->getHostCatom()),
  isChild(_isChild) { }

ChildRegMsg::ChildRegMsg(MailboxID _mID, catomID _childID, bool _isChild) :
  Message(_mID),
  childID(_childID),
  isChild(_isChild) { }

Hierarchy::Hierarchy(catomID _hostCatom, string _hierarchyName) : 
  CodeModule(_hostCatom), 
  hierarchyName(_hierarchyName),
  childRegMsgBox("_chreg_" + _hierarchyName),
  parent(INVALID_CATOM_ID),
  level(0) { }

Hierarchy::~Hierarchy() {
  // Clean out the childData
  map<catomID, ChildData*>::iterator i;
  for(i = childData.begin(); i != childData.end(); i++) {
    delete (*i).second;
  }
}

catomID Hierarchy::getParent() {
  return parent;
}

void Hierarchy::setParent(catomID newParent) {
  // CHEAT: if we had a previous parent, undo that via a warped msg
  if(parent != INVALID_CATOM_ID)
    worldPtr->catomHash[parent]->C.mailboxManager.fileMessage(new ChildRegMsg(this, false));

  parent = newParent;

  // CHEAT: inform the new parent we're its child via a warped msg
  if(parent != INVALID_CATOM_ID)
    worldPtr->catomHash[parent]->C.mailboxManager.fileMessage(new ChildRegMsg(this, true));
}

string Hierarchy::getHierarchyName() {
  return hierarchyName;
}

int Hierarchy::getLevel() {
  return level;
}

void Hierarchy::simulationStart() {
  CodeModule::simulationStart();

  worldPtr->catomHash[hostCatom]->C.mailboxManager.registerHandler(childRegMsgBox,
								   this,
								   (msgHandlerPtr)&Hierarchy::childRegHandler,
								   MSGPAYLOAD,
								   false);


  //  worldPtr->catomHash[hostCatom]->C.getNeighbors();
}

void Hierarchy::simulationEnd() {
  CodeModule::simulationEnd();

  this->dumpStats();
}

void Hierarchy::dumpStats() {
  worldPtr->oStart();
  //cerr << worldPtr->current_time << " Hierarchy(" << hierarchyName << ") "  << hostCatom << ":"
  //     << " level " << level
  //     << " parent " << parent 
  //     << " fanout " << childData.size()
  //     << endl << flush;
  worldPtr->oEnd();
}

void Hierarchy::endTick() {
  CodeModule::endTick();
}

ChildData* Hierarchy::newChildDataObject() {
  return NULL;
}

list<catomID> Hierarchy::childCatomIDs() {
  list<catomID> returnedValues;
  for ( map<catomID,ChildData*>::iterator it = childData.begin();
	it != childData.end();
	it++) {
    returnedValues.push_back(it->first);
  }

  return returnedValues;
}

ChildData* Hierarchy::getChildData(catomID id) {
  if(childData.find(id) == childData.end())
    return NULL;
  else
    return childData[id] ? childData[id]->clone() : NULL;
}

void Hierarchy::setChildData(catomID id, ChildData* data) {
  if(childData[id])
    delete childData[id];
  childData.erase(id);
  
  if(data)
    childData[id] = data;
}

bool Hierarchy::childRegHandler(Message* _msg) {
  ChildRegMsg* msg = (ChildRegMsg*)_msg;

  if(msg->isChild && 
     (childData.find(msg->childID) == childData.end())) {
    childData[msg->childID] = this->newChildDataObject();
  } else if (!msg->isChild) {
    setChildData(msg->childID, NULL);
    childData.erase(msg->childID);
  }

  return false;
}

// API/Utilities

StateFile::Module* Hierarchy::StateFileConstructor() {
  return NULL;
}
