///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Coproration and Carnegie Mellon University    //
// Contacts: casey.j.helfrich @ intel.com                                    //
//           bdr @ cs.cmu.edu                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef __GRADIENTHIERARCHY_H
#define __GRADIENTHIERARCHY_H

#include "Hierarchy.hxx"

class GradientHierarchy;

class GradientMsg : public Message {
public:
  unsigned depth;

  GradientMsg(GradientHierarchy* _hierarchy, unsigned _depth);
  GradientMsg(MailboxID _mailboxID, unsigned _depth);
  GradientMsg(GradientHierarchy* _hierarchy, unsigned long long _msgID, unsigned _depth);
  GradientMsg(MailboxID _mailboxID, unsigned long long _msgID, unsigned _depth);
  virtual Message* clone() {
    GradientMsg* c = new GradientMsg(mailboxID, messageID, depth);
    c->messageID = this->messageID;
    return c;
  }
};

class GradientHierarchy : public Hierarchy {
public:
  GradientHierarchy(catomID _hostCatom, string _hierarchyName);
  ~GradientHierarchy();

  void emitGradient();
  MailboxID gradientBox;

protected:
  virtual void simulationStart();
  virtual void endTick();

  virtual bool sendMsgToParent(Message* msg);

private:
  featureID upstreamFeature;
  bool isRoot;

  bool gradientHandler(Message* _msg);
};

#endif
