#ifndef __GRADIENTFIELD_H
#define __GRADIENTFIELD_H

class Catom;
class Message;

#include "CodeModule.hxx"
#include "Network.hxx"
#include "CatomWorld.hxx"

CODE_MODULE_PROTOTYPE( GradientField, GradientField );
using namespace std;

extern CatomWorld *worldPtr;
extern MailboxID gradientMessagingBox;

class GradientMessage : public Message {
public:
  int payload;
  GradientMessage(MailboxID mailboxName, int dataValue) : Message(mailboxName), payload(dataValue) { }
  GradientMessage(MailboxID mailboxName, unsigned long long _msgID, int dataValue) : Message(mailboxName, _msgID), payload(dataValue) { }
  virtual Message* clone() { return new GradientMessage(mailboxID, messageID, payload); }
};

class GradientField : public CodeModule {
public:
	int value;
	bool sendAgain;
	GradientField(catomID _hostCatom);
	void simulationStart();
	virtual void newTick();	
	virtual void endTick();
	bool gradientMsgHandler(GradientMessage* msg);
};

#endif
