// FailureSimulator.hxx
// Nels Beckman
// March 22, 2007 (3:30am! Yay!)
//
// Will simulate whole-catom failure and individual message failure.

#ifndef __FAILURE_SIMULATOR
#define __FAILURE_SIMULATOR

#include <cstdlib>
#include <list>
#include <pthread.h>

#include "Debugging/signpost.hxx"
#include "Primitives.hxx"
#include "CatomWorld.hxx"

extern CatomWorld* worldPtr;

using namespace std;

class FailureSimulator {

public:
  static pthread_mutex_t fsStaticStateMutex;
  
protected:
  int catomFailProb;
  static const int msgFailProb;

  static list<catomID> deadCatoms;

  catomID myCatom;
  bool amIDead;

public:
  FailureSimulator(catomID);
  
  // How many catoms have failed so far?
  static int getNumberFailed();

  // Is the given catom dead?
  static bool hasCatomDied(catomID);

  // Is the catom on which are located dead? Randomly dies w/ some probability.
  bool isCatomDead();

  static bool canSendReceive();

};

#endif 
