// FailureSimulator.cxx
// Nels Beckman
// March 22, 2007 (3:30am! Yay!)

#include "FailureSimulator.hxx"

const int FailureSimulator::msgFailProb = 100000000;

list<catomID> FailureSimulator::deadCatoms = 
  list<catomID>();

pthread_mutex_t FailureSimulator::fsStaticStateMutex =
  PTHREAD_MUTEX_INITIALIZER;

FailureSimulator::FailureSimulator(catomID c) :
  myCatom(c),
  amIDead(false)
{
  {
    // Get catom failure probability from exp file.
    unsigned int i;
    std::string val = worldPtr->search_key_value_list("CFPROB");
    std::istringstream iss(val);

    if( (iss >> std::dec >> i).fail() ) {
      catomFailProb = 100;
    }
    else {
      catomFailProb = i;
    }
  }
}

bool FailureSimulator::isCatomDead() {
  if( amIDead ) {
    return true;
  }
  else {
    pthread_mutex_lock( &fsStaticStateMutex );
    amIDead = rand() % catomFailProb == 0;

    if( amIDead ) {
      deadCatoms.push_back(myCatom);
      pthread_mutex_unlock( &fsStaticStateMutex );
      return true;
    }
    else {
      pthread_mutex_unlock( &fsStaticStateMutex );
      return false;
    }
  }
}

bool FailureSimulator::hasCatomDied(catomID c) {
  pthread_mutex_lock( &fsStaticStateMutex );
  bool b = false;
  for( list<catomID>::iterator iter = deadCatoms.begin();
       iter != deadCatoms.end();
       iter++ ) {
    if( (*iter) == c ) b = true;
  }
  pthread_mutex_unlock( &fsStaticStateMutex );  

  return b;
}

bool FailureSimulator::canSendReceive() {
  //return true;
  return ( rand() % msgFailProb != 0);
}

int FailureSimulator::getNumberFailed() {
  pthread_mutex_lock( &fsStaticStateMutex );
  deadCatoms.sort();
  deadCatoms.unique();
  int ret = deadCatoms.size();
  pthread_mutex_unlock( &fsStaticStateMutex );

  return ret;
}
