// FBTest.cxx
// Nels Beckman
// March 19th, 2007
//
// A test application for the fail block system

#include "FBTest.hxx"
#include "Compensation.hxx"

CODE_MODULE_DECLARATION( FBTest, FBTest );

FBTest::FBTest(catomID _hostCatom) : FBCodeModule<FBTest>(_hostCatom)
{}

void FBTest::thread() {

  try {
    f_block();
    
    for( unsigned int i=1; i<NUM_FEATURES; i++ ) {
      
      RPCNeighbor<FBTest>* neighbor = this->getNeighbor(i);
      
      if( neighbor != NULL ) {
	worldPtr->oStart();
	cout << "Using RPC on feature " << i <<endl;
	worldPtr->oEnd();
	
	FBTest* tmp = (neighbor->get());
	int val = tmp->add();
	
	worldPtr->oStart();
	cout << "Catom " << hostCatom << ": received " << val <<endl;
	worldPtr->oEnd();
      }
      
    }
    
    end_f_block();

    worldPtr->oStart();
    cout << "Catom is finished w/o failing." <<endl;
    worldPtr->oEnd();   
  }
  catch( TidFailure t ) {
    worldPtr->oStart();
    cout << "Catom: " << t.localCatom << " Tid: " << t.tid 
	 << " failed. Ending." <<endl;
    worldPtr->oEnd();  
  }

}

int FBTest::add() {
  ENTER_RPC_METHOD;

  class MyComp : public Compensation {
  public:
    MyComp(catomID c) : cid(c) {}
    catomID cid;
    virtual void run() {
      worldPtr->oStart();
      cout << "Catom "<<cid<< ": Compensation run!" <<endl;
      worldPtr->oEnd();  
    }
  };

  MyComp* c = new MyComp(hostCatom);
  push_comp(c);

  int to_return = 10 + 20;

  RPC_RETURN to_return;
}
