// FBTemplates.hxx
// Nels Beckman
// March 19th, 2007
//
// Contains all of the template code for the fail block system.
//   If you're thinking it's a little close to the deadline to be
//   creating this file, you are correct.

#ifndef __FB_TEMPLATE
#define __FB_TEMPLATE

#include "RPCTemplates.hxx"
#include "FBlockMsgs.hxx"
#include "TransactionManager.hxx"

class Compensation;

template<class F> class FBCodeModule;

template<class B>
class FBNeighbor : public RPCNeighbor<B> {

private:
  FBNeighbor() {}
  FBNeighbor(const FBNeighbor<B>&) { RPCNeighbor<B>::f_dest; }
  
public:
  FBNeighbor( FBCodeModule<B>*, featureID );
  
  //virtual B* operator->() const;
  virtual B* get(Message* msg = NULL);
};

template<class E>
class FBMessage : public RPCMessage<E> {
public:

  // Is this a message from a transaction?
  bool inTransaction;

  // The transaction id of this message.
  Tid tid;

  FBMessage(catomID, FBNeighbor<E>*, bool, Tid);

  // If it is a return message, then we don't need to pass tid info.
  FBMessage(catomID);

  FBMessage(const FBMessage<E> &m);

  virtual Message* clone();
};

template<class F>
class FBCodeModule : public RPCCodeModule<F> {
  
protected:
  static map< Tid, FBCodeModule<F>* > homeCatomMap;

  virtual void rpcReturn();

public:
  FBCodeModule(catomID);
  
  virtual void doRPCYield();
  // let local_catom = getThreadLocation() and
  //     thread_home = getThreadHome() and
  //     tid = getCurrentTid() in
  //   
  //   defined in RPCTemplates...
  //   wait( getConditionVariable(thread_home) );
  //
  //   if hasCatomDied(local_catom) 
  //   then if local_catom = thread_home 
  //        then setThreadWake(thread_home);
  //             doRPCYield();
  //        else if getTidStatus(thread_home, tid) = ( REPORTED | FAILED_DISPOSED )
  //             then setThreadLocation(thread_home);
  //                  setThreadWake(thread_home);
  //                  doRPCYield();
  //        else setThreadWake(thread_home);
  //   else if getTidStatus(local_catom, tid) = ( REPORTED | FAILED_DISPOSED )
  //        then if local_catom = thread_home
  //             then if getTidStatus(local_catom, tid) = (REPORTED|FAILED_DISPOSED)
  //                  then clearCurrentTid();
  //                       throw TidFailued()
  //                  else setThreadWake(thread_home);
  //                       doRPCYield();
  //             else if( getTidStatus(thread_home,tid) = (REPORTED|FAILED_DISPOED) )
  //                  then setThreadLocation(thread_home);
  //                       setThreadWake(thread_home):
  //                       doRPCYield();

  void end_f_block();
  
  void f_block();
  
  virtual RPCNeighbor<F>* getNeighbor(featureID feat);
  
  // Returns the transaction manaager. Used at a minimum in our version
  //   of ->.
  TransactionManager* getTransMngr();

  // Calls RPCCodeModule::handleSendMsg
  //   Additionally adds collaborator.
  bool handleSendMsg(FBMessage<F>* msg);
  
  bool handleMovingMsg(MovingMsg*);

  // As always, there are a few cheater methods.
  // There is nothing conceptually
  // wrong with movement, I just haven't had to implement it correctly.
  void atomicRemoveAndAddCollabs( Tid, list<featureID>, bool, bool );

  // The message handler for the message that a given transaction
  //   has failed.
  bool handleFailureMsg(ErrorMsg*);
  
  // The message handler for getting pinged.
  bool handlePingMsg(PingMsg*);
  
  // The message handler for when this block has ended.
  bool handleEndMsg(EndMsg*);

  virtual void newTick();
  
  void push_comp(Compensation*);

  // Overriding from RPCCodeModule
  //   calls the overriden version and then 
  virtual void registerHandler();

  TransactionManager* transMngr;
};


template<class B>
FBNeighbor<B>::FBNeighbor( FBCodeModule<B>* src_catom,
				   featureID send_to_feature) :
  RPCNeighbor<B>::RPCNeighbor( src_catom, send_to_feature )
{}

template<class B>
B* FBNeighbor<B>::get(Message* msg) {
  B* to_return =  NULL;

  //worldPtr->oStart();
  //cout << "The correct get() is being called." << endl;
  //worldPtr->oEnd();  

  // Hackish line, implies a necessary refactoring...
  TransactionManager* transMngr = 
    ((FBCodeModule<B>*)(this->c_source))->getTransMngr();
  
  bool inTransaction = transMngr->inTransaction();
  
  if( inTransaction ) {
    Tid tid = transMngr->getCurrentTid();
    featureID fid = this->f_source;
    
    transMngr->addCollab( tid, fid );
    //transMngr->printCollabs();
  }
  else {
    //worldPtr->oStart();
    //cout << "This is a bad situation..." << endl;
    //worldPtr->oEnd();  
  }
  
  {
    FBMessage<B>* msg = new FBMessage<B>(this->c_source->getHostCatom(),
					 this,
					 inTransaction,
					 inTransaction ? 
					 transMngr->getCurrentTid() :
					 Tid()
					 );
    try {
      to_return = RPCNeighbor<B>::get(msg);
    } catch( SendFail s ) {
      
      if( transMngr->inTransaction() ) {
	transMngr->reportFailure( transMngr->getCurrentTid() );
	
	// This is a static method and could be called on any RPCCodeModule
	this->c_source->doRPCYield();
      }
      else {
	throw s;
      }
    }
  }
  
  return to_return;
}

template<class E>
FBMessage<E>::FBMessage(catomID _sourceCatom) :
  RPCMessage<E>::RPCMessage(_sourceCatom)
{}

template<class E>
FBMessage<E>::FBMessage(catomID _sourceCatom, FBNeighbor<E>* neighbor,
			bool _it, Tid _tid) :
  RPCMessage<E>::RPCMessage(_sourceCatom, neighbor),
  inTransaction(_it),
  tid(_tid)
{}

template<class E>
FBMessage<E>::FBMessage(const FBMessage<E> &m) :
  RPCMessage<E>(m)
{
  inTransaction = m.inTransaction;
  tid = m.tid;
}

template<class E>
Message* FBMessage<E>::clone() {
  FBMessage<E>* to_return = new FBMessage<E>(*this);
  return to_return;
}

template<class F>
map< Tid, FBCodeModule<F>* > FBCodeModule<F>::homeCatomMap =
  map < Tid, FBCodeModule<F>* >();

template<class F>
FBCodeModule<F>::FBCodeModule(catomID id) :
  RPCCodeModule<F>::RPCCodeModule(id),
  transMngr(NULL)
{
  transMngr = new TransactionManager(id);
}


template<class F>
void FBCodeModule<F>::atomicRemoveAndAddCollabs( Tid t, list<featureID> cs,
						 bool al, bool rl )
{
  transMngr->atomicRemoveAndAddCollabs(t,cs,al,rl);
}

template<class F>
void FBCodeModule<F>::doRPCYield() {

  //worldPtr->oStart();
  //cout << "Calling the FB Yield!" << endl;
  //worldPtr->oEnd();

  bool cant_return = false;

  catomID local_catom = RPCCodeModuleStatic::getThreadLocation();
  catomID thread_home = RPCCodeModuleStatic::getThreadHome();
  Tid tid = TransactionManager::getCurrentTid();

  do {

    RPCCodeModuleStatic::doRPCYield();
    
    if( FailureSimulator::hasCatomDied(local_catom) ) {
      if( local_catom == thread_home ) {
	// Do nothing here, because we are on a dead
	//   catom. Wake up in case status changes.
	RPCCodeModuleStatic::setThreadWake(thread_home);
	cant_return = true;
      }
      else if( TransactionManager::getTidStatus(thread_home, tid) == REPORTED||
	       TransactionManager::getTidStatus(thread_home, tid) == FAILED_DISPOSED ) {
	worldPtr->oStart();
	cout << "Catom " << this->hostCatom 
	     << ": local_catom: " << local_catom << ", thread_home: "
	     << thread_home << " ready to go back home "
	     << TransactionManager::getTidStatus(thread_home, tid) 
	     << " dead catom " << endl;
	worldPtr->oEnd();
	
	// Needs to go back home.
	RPCCodeModuleStatic::setThreadLocation(thread_home);
	RPCCodeModuleStatic::setThreadWake(thread_home);
	cant_return = true;
      }
      else {
	worldPtr->oStart();
	cout << "Catom " << this->hostCatom 
	     << ": local_catom: " << local_catom << ", thread_home: "
	     << thread_home << " but home doesn't know "
	     << TransactionManager::getTidStatus(thread_home, tid) 
	     << " dead catom. "<< endl;
	worldPtr->oEnd();


	// Not in a transaction ID or home hasn't found out yet.
	RPCCodeModuleStatic::setThreadWake(thread_home);
	cant_return = true;
      }
    }
    else if( TransactionManager::getTidStatus(local_catom, tid) == REPORTED ||
	     TransactionManager::getTidStatus(local_catom, tid) == FAILED_DISPOSED ) {
      if( thread_home == local_catom ) {

	if( TransactionManager::getTidStatus(local_catom,tid) == FAILED_DISPOSED ) {
	  TransactionManager::clearCurrentTid();
	  throw TidFailure(tid, local_catom);
	}
	else {
	  worldPtr->oStart();
	  cout << "Catom " << this->hostCatom 
	       << ": local_catom: " << local_catom << ", thread_home: "
	       << thread_home << " but I can't throw because status is "
	       << TransactionManager::getTidStatus(local_catom, tid) << endl;
	  worldPtr->oEnd();

	  RPCCodeModuleStatic::setThreadWake(thread_home);
	  cant_return = true;
	}

      }
      else {
	if( TransactionManager::getTidStatus(thread_home, tid) == REPORTED ||
	    TransactionManager::getTidStatus(thread_home, tid) == FAILED_DISPOSED  ) {
	  worldPtr->oStart();
	  cout << "Catom " << this->hostCatom 
	       << ": local_catom: " << local_catom << ", thread_home: "
	       << thread_home << " ready to go back home "
	       << TransactionManager::getTidStatus(thread_home, tid) << endl;
	  worldPtr->oEnd();

	  // Needs to go back home.
	  RPCCodeModuleStatic::setThreadLocation(thread_home);
	  RPCCodeModuleStatic::setThreadWake(thread_home);
	  cant_return = true;
	}
	else {
	  worldPtr->oStart();
	  cout << "Catom " << this->hostCatom 
	       << ": local_catom: " << local_catom << ", thread_home: "
	       << thread_home << " but home doesn't know "
	       << TransactionManager::getTidStatus(thread_home, tid) << endl;
	  worldPtr->oEnd();

	  RPCCodeModuleStatic::setThreadWake(thread_home);
	  cant_return = true;	
	}
      }
    }
    
  } while( cant_return );
}

template<class F>
void FBCodeModule<F>::end_f_block() {
  transMngr->end_f_block();	
}

template<class F>
void FBCodeModule<F>::f_block() {
  Tid t = transMngr->f_block();	

  pthread_mutex_lock( &this->rpcGlobalMTX );
  homeCatomMap[t] = this;
  pthread_mutex_unlock( &this->rpcGlobalMTX );
}


template<class F>
RPCNeighbor<F>* FBCodeModule<F>::getNeighbor(featureID feat) {
  catomID hostCatom = this->hostCatom;
  catomID neighbor = HOSTCATOM.getNeighbor(feat);

  if(  neighbor == 0 )
    return NULL;
  
  // Check if neighbor is DEAD!!!
  if( FailureSimulator::hasCatomDied(neighbor) )
    return NULL; 
  
  FBNeighbor<F>* to_return = new FBNeighbor<F>( this, feat );
  
  return to_return;
}

template<class F>
void FBCodeModule<F>::rpcReturn() {
  try {
    RPCCodeModule<F>::rpcReturn();
  } catch(SendFail sf) {
    // Do nothing because it will time out itself.
  }
}

template<class F>
TransactionManager* FBCodeModule<F>::getTransMngr() {
  return transMngr;
}

// MAKE SURE CHANGES GO TO RPCTEMPLATE IF NEED BE
template<class F>
bool FBCodeModule<F>::handleSendMsg(FBMessage<F>* msg) {
  if( this->failureSim.isCatomDead() ) {
    return false;
  }
  
  if( msg->inTransaction ) {
    
    if( transMngr->getTidStatus(this->hostCatom, msg->tid) == REPORTED || 
        transMngr->getTidStatus(this->hostCatom, msg->tid) == FAILED_DISPOSED ) {
      transMngr->sendError(msg->tid, msg->arrivalContact);
      return false;
    }
    else if( transMngr->getTidStatus(this->hostCatom, msg->tid) == ENDED ) {
      // do nothing...
    }
    else {
      Tid tid = msg->tid;
      featureID fid = msg->arrivalContact;

      //worldPtr->oStart();
      //cout << "Catom " << this->hostCatom 
      // 	   << ": starting transaction " << tid
      //	   << " from fid " << fid << endl;
      //worldPtr->oEnd();
      
      transMngr->beginTid(tid);
      transMngr->addCollab( tid, fid );
    }

  }

  // Still within reasonable semantics/things my system will handle and
  //   doesn't make the implementation any more diffilcult. (i.e. the fact
  //   that the first isDead might return false but the second one true.)
  return RPCCodeModule<F>::handleSendMsg(msg);
}

template<class F>
bool FBCodeModule<F>::handleMovingMsg(MovingMsg* msg) {
  transMngr->removeCollab( msg->arrivalContact );
  return false;
}

template<class F>
bool FBCodeModule<F>::handleFailureMsg(ErrorMsg* msg) {
  if( this->failureSim.isCatomDead() ) {
    return false;
  }

  Tid tid = msg->tid;
  
  if( transMngr->getTidStatus(this->hostCatom, tid) == ACTIVE ) {
    transMngr->reportFailure(tid);
  }
  return false;
}

template<class F>
bool FBCodeModule<F>::handlePingMsg(PingMsg* msg) {
  if( this->failureSim.isCatomDead() ) {
    return false;
  }

  if( transMngr->getTidStatus(this->hostCatom, msg->tid) == REPORTED || 
      transMngr->getTidStatus(this->hostCatom, msg->tid) == FAILED_DISPOSED) {
    transMngr->sendError(msg->tid, msg->arrivalContact);
  }
  else if( transMngr->getTidStatus(this->hostCatom, msg->tid) == ENDED ) {
    RPCCodeModuleStatic::sendMsg(this->hostCatom, 
				 msg->arrivalContact,
				 new EndMsg(msg->tid));
  }
  else if( transMngr->getTidStatus(this->hostCatom, msg->tid) == ACTIVE ) {
    transMngr->wasPinged(msg->tid, msg->catom,
			msg->arrivalContact);
    
    //worldPtr->oStart();
    //cout << "Catom " << this->hostCatom << ": was pinged." << endl;
    //worldPtr->oEnd();
  }
  else {
    // otherwise, maybe we're just about to be added and this
    //   ping reached us first.
    // Okay to add it pre-emptively?
    //transMngr->addCollab( msg->tid, msg->arrivalContact );
  }

  return false;
}

template<class F>
bool FBCodeModule<F>::handleEndMsg(EndMsg* msg) {
  if( this->failureSim.isCatomDead() ) {
    return false;
  }
  
  //worldPtr->oStart();
  //cout << "Catom " << this->hostCatom << ": received end message." <<endl;
  //worldPtr->oEnd();

  transMngr->endTid(msg->tid);
  return false;
}

template<class F>
void FBCodeModule<F>::push_comp(Compensation* comp) {  
  this->transMngr->push_comp(comp);
}	

template<class F>
void FBCodeModule<F>::newTick() 
{
  if( !this->failureSim.isCatomDead() ) {
    // If there is a move available, we can take it (and return).
    if( this->moveReady() ) {
      // Elimnate all collaborators.     
      for( int i = 1; i <= 6; i++ ) {
	this->sendMsg(this->hostCatom, i, new MovingMsg());
      }
      this->makeReadyMove();
      transMngr->removeAllCollabs();
      return;
    }
     
    transMngr->newTick();
  }
  else {
    catomID hostCatom = this->hostCatom;
    HOSTCATOM.setColor( 255, 255, 0, 0 );
    worldPtr->oStart();
    cout << "Catom " << this->hostCatom << ": ---------DEAD---------" <<endl;
    worldPtr->oEnd();
  }

  pthread_mutex_lock( &this->rpcMutex );
  if( this->wakeRPCThread ) {
    pthread_cond_broadcast( &this->rpcConVar );
    pthread_cond_wait( &this->rpcConVar, &this->rpcMutex );
  }
  pthread_mutex_unlock( &this->rpcMutex );

}

template<class F>
void FBCodeModule<F>::registerHandler() {
  RPCCodeModule<F>::registerHandler();
 
  //worldPtr->oStart();
  //cout << "Catom " << this->hostCatom << ": Registering FB handlers." << endl;
  //worldPtr->oEnd();

  catomID hostCatom = this->hostCatom;

  // Hopefully this should un-register the other one.
  HOSTCATOM.mailboxManager.registerHandler(RPCMessage<F>::RPC_SEND_BOX,
					   this,
					   (msgHandlerPtr)&FBCodeModule<F>::handleSendMsg);
  HOSTCATOM.mailboxManager.registerHandler(MovingMsg::MOVING_MSG_BOX,
					   this,
					   (msgHandlerPtr)&FBCodeModule<F>::handleMovingMsg);

  HOSTCATOM.mailboxManager.registerHandler(PingMsg::PING_MSG_BOX,
					   this,
					   (msgHandlerPtr)&FBCodeModule<F>::handlePingMsg); 

  HOSTCATOM.mailboxManager.registerHandler(ErrorMsg::ERROR_MSG_BOX,
					   this,
					   (msgHandlerPtr)&FBCodeModule<F>::handleFailureMsg);

  HOSTCATOM.mailboxManager.registerHandler(EndMsg::END_MSG_BOX,
					   this,
					   (msgHandlerPtr)&FBCodeModule<F>::handleEndMsg);
}

#endif
