// FailBlock.hxx
// Nels Beckman
// Feb 28th 2007
//
// Programs that use the fail block system should extend this class.
//   It will provide a map of stacks, one for each transaction, along
//   will a ton of other functionality. This is the first class I can
//   think of an presumably it will get divided up into a bunch of
//   other classes later on.

#include <map>

#include "RPCUser.hxx"
#include "TransactionManager.hxx"
#include "FBlockNeighbor.hxx"
#include "Tid.hxx"
#include "Primitives.hxx"
#include "FBlockMsgs.hxx"

#ifndef __FAILBLOCK_H
#define __FAILBLOCK_H

class SendFail;
  
template<class F>
class FailBlock : public RPCUser<F> {
  
protected:
  TransactionManager transMngr;

  virtual void rpcReturn();  
public:
  FailBlock(catomID);
  
  virtual void newTick();
  
  void end_f_block();
  
  void f_block();
  
  // More hackery so that the RPC system can alert us of a failed
  //   send.
  void failureDetected();
  
  virtual RPCNeighbor<F>* getNeighbor(featureID feat);
  
  // The message handler for the message that a given transaction
  //   has failed.
  bool handleFailureMsg(FailMsg*);
  
  // The message handler for getting pinged.
  bool handlePingMsg(PingMsg*);
  
  // The message handler for when this block has ended.
  bool handleEndMsg(EndMsg*);
  
  void push_comp(Compensation*);
};

#endif
