// FailBlock.hxx
// Nels Beckman
// Feb 28th 2007

#include "FailBlock.hxx"

//template<class F>
//FailBlock<F>::FailBlock(catomID id)
//{
//  pthread_mutex_lock(rpcGlobalMTX);
//  rpcMethodStacks[pthread_self()] = 0;
//  pthread_mutex_unlock(rpcGlobalMTX);
//}

template<class F>
void FailBlock<F>::end_f_block() {
  transMngr.end_f_block();	
}

template<class F>
void FailBlock<F>::f_block() {
  transMngr.f_block();	
}

template<class F>
void FailBlock<F>::failureDetected() {
  if( transMngr.inTransaction() ) {
    Tid tid = transMngr.getCurrentTid();
    transMngr.failureDetected(tid);
  }
  else {
    // Well, what do we do? Fail the thread? Rethrow?
    cerr << "Failure detected outside of transaction." <<endl;
    pthread_exit( NULL );
  }
  
}

template<class F>
RPCNeighbor<F>* FailBlock<F>::getNeighbor(featureID feat) {
  catomID hostCatom = this.hostCatom;
  
  if( HOSTCATOM.getNeighbor(feat) == 0 )
    return NULL;
  
  return new FBlockNeighbor<F>( this, feat );
}

template<class F>
bool FailBlock<F>::handleFailureMsg(FailMsg* msg) {
  Tid tid = msg->tid;
  
  if( transMngr.isActive(tid ) ) {
    transMngr.failureDetected(tid);
  }
  return false;
}

template<class F>
bool FailBlock<F>::handlePingMsg(PingMsg* msg) {
  if( transMngr.hasFailed(msg->tid) ) {
    transMngr.sendError(msg->tid, msg->arrivalContact);
  }
  else if( transMngr.isActive(msg->tid) ) {
    transMngr.wasPinged(msg->tid, msg->catom,
			msg->arrivalContact);
  }
  // otherwise, maybe we're just about to be added and this
  //   ping reached us first.
  return false;
}

template<class F>
bool FailBlock<F>::handleEndMsg(EndMsg* msg) {
  transMngr.endTid(msg->tid);
  return false;
}

template<class F>
void FailBlock<F>::newTick() {
  transMngr.decrAllOutstandingPings();
  transMngr.decrAllExpectedPings();
  transMngr.sendPings();
}

template<class F>
void FailBlock<F>::push_comp(Compensation* comp) {
  transMngr.push_comp(comp);
}	


template<class F>
void FailBlock<F>::rpcReturn() {
  try {
    RPCUser<F>::rprReturn();
  } catch(SendFail e) {
    if( transMngr.inTransaction() ) {
      transMngr.failureDetected(transMngr.getCurrentTid());
    }
    else {
      // Not really too much we can do. We sort of have
      //   to die.
      cerr << "Dying because I was not in a transaction." <<endl;
      pthread_exit( NULL );
    }
  }
}
