/***************************************************************************
*   Copyright (C) 2006 by Intel and Carnegie Mellon                       *
*   Contacts: bdr@cs.cmu.edu                                              *
***************************************************************************/

#include "Ellipsis.hxx"

#include "CatomWorld.hxx"
#include "Network.hxx"
#include "CatomSim.hxx"

CODE_MODULE_DECLARATION( Ellipsis, Ellipsis, "Ellipsis" );
CODE_MODULE_DECLARATION( Ellipsis2, Ellipsis, "Ellipsis2" );

using namespace std;

void EllipsisChildData::add(EllipsisChildData otherData) {
	n += otherData.n;
	sx += otherData.sx;
	sy += otherData.sy;
	sz += otherData.sz;
	sxx += otherData.sxx;
	sxy += otherData.sxy;
	sxz += otherData.sxz;
	syy += otherData.syy;
	syz += otherData.syz;
	szz += otherData.szz;
}

string EllipsisChildData::toString() {
	ostringstream str;

	str << sx  << " "
			<< sy  << " "
			<< sz  << " "
			<< sxx << " "
			<< sxy << " "
			<< sxz << " "
			<< syy << " "
			<< syz << " "
			<< szz << " "
			<< n;
	return str.str();
}

Ellipsis::Ellipsis(catomID _hostCatom,  string _hchyName) :
  DPRHierarchy(_hostCatom, _hchyName),
  ellipsisBox("EllipsisBox" + _hchyName),
  lastAggregateReceived(-1) {

}

void Ellipsis::simulationStart() {
  DPRHierarchy::simulationStart();
  
  worldPtr->catomHash[hostCatom]->C.mailboxManager.registerHandler(ellipsisBox,
								   this,
								   (msgHandlerPtr)&Ellipsis::aggMessageHandler);
}

void Ellipsis::simulationEnd() {
  dumpEllipses();
  
  DPRHierarchy::simulationEnd();
}

void Ellipsis::dumpEllipses() {
  // Calculate our ellipse
  // (yanked from sendAggToParent below)
  Point3D myLoc = worldPtr->catomHash[hostCatom]->C.getLocation();
  double my_x = myLoc.getX();
  double my_y = myLoc.getY();
  double my_z = myLoc.getZ();
  EllipsisChildData aggregatedData(1,
				   my_x, my_y, my_z,
				   my_x*my_x, my_x*my_y, my_x*my_z,
				   my_y*my_y, my_y*my_z,
				   my_z*my_z);
  
  list<catomID> childrenIDs = childCatomIDs();
  list<catomID>::iterator childDataIterator = childrenIDs.begin();
  while(childDataIterator != childrenIDs.end()) {
    EllipsisChildData* theChildData = (EllipsisChildData*)getChildData(*childDataIterator);
    aggregatedData.add(*theChildData);
    delete theChildData;
    childDataIterator++;
  }
  worldPtr->oStart();
  
  cerr << "ellipse " << getLevel() << " " << aggregatedData.toString() << endl;
  
  worldPtr->oEnd();
}

bool Ellipsis::aggMessageHandler(Message* _msg) {
  EllipsisMsg* msg = (EllipsisMsg*)_msg;
 
  if(getChildData(msg->from)) {
    setChildData(msg->from, msg->data.clone());
    lastAggregateReceived = worldPtr->current_time;
  }
  
  return false;
}

void Ellipsis::sendAggToParent() {	
	Point3D myLoc = worldPtr->catomHash[hostCatom]->C.getLocation();
	double my_x = myLoc.getX();
	double my_y = myLoc.getY();
	double my_z = myLoc.getZ();
	EllipsisChildData aggregatedData(1,
					 my_x, my_y, my_z,
					 my_x*my_x, my_x*my_y, my_x*my_z,
					 my_y*my_y, my_y*my_z,
					 my_z*my_z);

	list<catomID> childrenIDs = childCatomIDs();
	list<catomID>::iterator childDataIterator = childrenIDs.begin();
	while(childDataIterator != childrenIDs.end()) {
	  EllipsisChildData* theChildData = (EllipsisChildData*)getChildData(*childDataIterator);;
	  aggregatedData.add(*theChildData);
	  childDataIterator++;
	}
	
	EllipsisMsg* msg = new EllipsisMsg(ellipsisBox, hostCatom, aggregatedData);
	sendMsgToParent(msg); // if this function returns false, that means we're the root
}

ChildData* Ellipsis::newChildDataObject() {
  return new EllipsisChildData();
}

void Ellipsis::endTick() {
  if(((worldPtr->current_time >= 100) && ((worldPtr->current_time) % 25 == 0)) ||
     ((lastAggregateReceived != -1) && (worldPtr->current_time - lastAggregateReceived == 3)))
    sendAggToParent();
  
  DPRHierarchy::endTick();
}
