///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Coproration and Carnegie Mellon University    //
// Contacts: mderosa@cs.cmu.edu						     //
//           					                             //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef __DISTRIBUTEDWATCHPOINT_H
#define __DISTRIBUTEDWATCHPOINT_H

#include "CodeModule.hxx"
#include "CatomWorld.hxx"
#include "CatomSim.hxx"
#include "WPParser.hxx"
#include <map>
#include <deque>
#include "Network.hxx"

CODE_MODULE_PROTOTYPE( DistributedWatchpoint, DistributedWatchpoint );
using namespace std;

extern CatomWorld *worldPtr;
extern MailboxID watchpointMessagingBox;

class WatchpointMessage : public Message {
public:
	Watchpoint *payload;
	WatchpointMessage(MailboxID mailboxName, Watchpoint *dataValue) : Message(mailboxName), payload(dataValue) { }
	virtual Message* clone() { return new WatchpointMessage(mailboxID, payload); }
};

class DistributedWatchpoint : public CodeModule {
public:
	static Watchpoint *wpMaster;
	static set<string> wpNames;
	static int maxTemporal; //max future temporal extent
	static map<string,int> minExtent;
	static map<string,int> maxExtent;
	//global counters for statistics
	static unsigned liveCount[10];
	static unsigned deadCount[10];
	static unsigned long matches;
	//configurable settings
	static bool allEnabled;
	static bool linearOnly;
	static bool enableEarlyTerm;
	static bool enableNeighborSelect;
	
	map<string,deque<float> > savedState; //to access catom's var foo (current value) savedState["foo"][0]
	deque<float> fullState;
	set<Watchpoint *> activeMatchers;
	set<Watchpoint *> reroutedMatchers;
	unsigned long steps;
	
	DistributedWatchpoint(catomID _hostCatom):CodeModule(_hostCatom)  {}
	virtual void simulationStart();
	virtual void newTick();	
	virtual void oracle();
	bool watchpointMsgHandler(WatchpointMessage* msg);
	float getState(string name);
	float lookupSavedState(string varName,int offset);
	set<catomID> possibleNeighbors(Watchpoint *wp);
	set<catomID> possibleDistantNeighbors(Watchpoint*wp);
	bool isDuplicateMultihop(WatchpointMessage* msg);
};

#endif
