///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Coproration and Carnegie Mellon University    //
// Contacts: bdr @ cs.cmu.edu                                                //
//           casey.j.helfrich @ intel.com                                    //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include <string>
#include <stdint.h>

#include "Historian.hxx"
extern Historian* historianPtr;

#include "signpost.hxx"

using namespace std;

signpost::signpost(string _file, uint32_t _line, string _function, uint64_t _hostCatom/*=0*/) :
  file(_file),
  line(_line),
  function(_function),
  hostCatom(_hostCatom)
{
  if(historianPtr)
    historianPtr->addSignpost("enter block", file, line, function);
}

signpost::~signpost() {
  if(historianPtr)
    historianPtr->addSignpost("leave block", file, line, function);
}
