///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Coproration and Carnegie Mellon University    //
// Contacts: casey.j.helfrich @ intel.com                                    //
//           bdr @ cs.cmu.edu                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef __DEBUGGING_HXX
#define __DEBUGGING_HXX

#include "monitored_value.hxx"
#include "monitored_class.hxx"
#include "signpost.hxx"
#include "Historian.hxx"

// Monitored instance variables
#ifndef DISABLE_DEBUGGING
#define IVAR(type, name)						\
  class dprdebug_ivar_ ## name : public monitored_value<type> {		\
  public:								\
    dprdebug_ivar_ ## name ()            : monitored_value<type>(#type, #name) { } \
    dprdebug_ivar_ ## name (type theVal) : monitored_value<type>(#type, #name, theVal) { } \
  } name;
#else
#define IVAR(type, name) type name;
#endif

// Monitored classes
#ifndef DISABLE_DEBUGGING
#define CLASS(name, parent)						\
  class name : public parent, public monitored_class {			\
    class dprdebug_classinfo_ ## name {					\
    public:								\
      string classname;							\
      dprdebug_classinfo_ ## name () : classname(#name) {		\
	if(historianPtr)						\
	  historianPtr->insertMemoryItem(this,dprdebug_classinfo_type);	\
      }									\
      ~dprdebug_classinfo_ ## name () {					\
	if(historianPtr)						\
	  historianPtr->removeMemoryItem(this);				\
      }									\
    } dprdebug_classinfo_instance_ ## name;
#else
#define CLASS(name, parent) class name : public parent {
#endif

#ifndef DISABLE_DEBUGGING
#define CLASSNP(name)							\
  class name : public monitored_class {					\
    class dprdebug_classinfo_ ## name {					\
    public:								\
      string classname;							\
      dprdebug_classinfo_ ## name () : classname(#name) {		\
	if(historianPtr)						\
	  historianPtr->insertMemoryItem(this,dprdebug_classinfo_type); \
      }									\
      ~dprdebug_classinfo_ ## name () {					\
	if(historianPtr)						\
	  historianPtr->removeMemoryItem(this);				\
      }									\
    } dprdebug_classinfo_instance_ ## name;
#else
#define CLASSNP(name) class name {
#endif


#endif
