#ifndef __DC_STOY_H
#define __DC_STOY_H

#include "DCondition.hxx"

CODE_MODULE_PROTOTYPE( DcStoy, DcStoy );
using namespace std;

class StoyWrapper: public CatomWrapper {
	public:
	StoyWrapper(CatomSim* c) :CatomWrapper(c) {}
	virtual set<ModuleWrapper *> neighbors();
	virtual VarCode codeForVarname(string varname);
	virtual float getRealVar(VarCode var);
	virtual void setRealVar(VarCode var, float val);
	virtual set<float> getSetVar(VarCode var);
	virtual void callFcn(string fname, float arg);
};


class DcStoy : public DistributedCondition {
public:
	virtual ModuleWrapper *localModule() { return new StoyWrapper(HOSTCATOMSIM); }
	void simulationStart();
	void newTick();
	void endTick();
	float gradOrigin;
	float state;
	float inside;
	bool isSeed;
	float parent;
	float gradient; //for moving inside object
	bool exists;
	bool inScaffold;
	bool hasRsc;
	set<float> notChildren;
	static int complete;
	static catomID seedId;
	static int startfile;
	static int endfile;
	static bool use_meta;
	static bool bear_hack;
	static long restart_time;
	
	long moveCount;
	long msgsLastTick;
	static long toEmpty;
	DcStoy(catomID _hostCatom):DistributedCondition(_hostCatom)  {
		if (_hostCatom==0) {
			string tmp;
			tmp = worldPtr->search_key_value_list("PLAN_SEED");
			if (tmp!="") seedId = atoi(tmp.c_str());
			tmp = worldPtr->search_key_value_list("DcPlanner_use_meta");
			if (tmp=="true") use_meta=true; else use_meta=false;
			tmp = worldPtr->search_key_value_list("DcPlanner_startfilenum");
			if (tmp!="") startfile = atoi(tmp.c_str());
			tmp = worldPtr->search_key_value_list("DcPlanner_endfilenum");
			if (tmp!="") endfile = atoi(tmp.c_str());
			tmp = worldPtr->search_key_value_list("DcPlanner_bear_hack");
			if (tmp=="true") bear_hack=true; else bear_hack=false;
		}
	}};

#endif
