#include <algorithm>
#include <iostream>
#include <errno.h>
#include <string.h>
#include <stdlib.h>

#include "DcStoy.hxx"
#include "pathsupport.hxx"

CODE_MODULE_DECLARATION( DcStoy, DcStoy );

int DcStoy::complete = 0;
catomID DcStoy::seedId = 0;
int DcStoy::startfile = 1;
int DcStoy::endfile = 0;
bool DcStoy::use_meta = true;
long DcStoy::restart_time = -2;
bool DcStoy::bear_hack=false;
long DcStoy::toEmpty = 0;

enum {
	kNumNeighbors = 1025,
 	kState,kInside,kParent,kRsc,kDepth,kGradient,kIsSeed,kDeleteMe,kRepopulate,
  	kSwitchToPath,kGradOrigin,kFreeSpaces,kNotChildren,kNeighbors
};


using namespace std;

#define ON_ALPHA 80

//returns all neighbors (including diagonals) for catom c
//exists flag toggles search for filled or empty locations
set<ModuleWrapper*> allNeighbors(catomID c, bool exists) {
	set<ModuleWrapper*> neighbors;
	Point3D currLocation = worldPtr->catomHash[c]->C.getLocation();
	for (unsigned k = 1; k <= NUM_FEATURES; k++) {
		catomID kthNeighbor = worldPtr->catomHash[c]->C.getNeighbor(k);
		if (kthNeighbor  && (REMOTE_CODE_MODULE(kthNeighbor,DcStoy)->exists == exists)) {
			neighbors.insert((ModuleWrapper*)catomWrappers[kthNeighbor]);
		}
		if (kthNeighbor) { //find diagonal neighbors manually
			for (unsigned j = 1; j <= NUM_FEATURES; j++) {
				catomID diagNeighbor = worldPtr->catomHash[kthNeighbor]->C.getNeighbor(j);
				if (diagNeighbor && (REMOTE_CODE_MODULE(diagNeighbor,DcStoy)->exists == exists)) {
					Point3D neighborLoc = worldPtr->catomHash[diagNeighbor]->C.getLocation();
						//cout << neighborLoc.distanceFrom(currLocation) << endl;
					if (neighborLoc.distanceFrom(currLocation) < 3.0)  //NOTE: assumes radius 1
						neighbors.insert((ModuleWrapper*)catomWrappers[diagNeighbor]);
				}
			}
		}
	}
	return neighbors;
}

void DcStoy::simulationStart() {
	DistributedCondition::simulationStart();
		
	//setup for MM planner
	exists = true;
	// the following is the standard clearing of state
	state = 2;
	parent = gradOrigin = -1;
	HOSTCATOMSIM->alpha = ON_ALPHA;
	gradient = 0;
	isSeed = false;
	hasRsc = 0;
	moveCount = 0;
	msgsLastTick = 0;
	
	//set up initial inside/outside state
	Point3D p = HOSTCATOM.getLocation();
	inScaffold = false;
	int xCoord = (int)p.getX() / 2; //NOTE: assumes radius 1
	int yCoord = (int)p.getY() / 2;
	int zCoord = (int)(p.getZ() + 1.0) / 2;
	if ((zCoord % 2) == 0) { 
		if (((xCoord % 2) != 1) && ((yCoord % 2) != 1)) inScaffold = true;
	}
	else {
		if (((xCoord % 2) != 1) || ((yCoord % 2) != 1)) inScaffold = true;
	}
	
	if (use_meta) HOSTCATOMSIM->HACK_metamodule = hasRsc ? 2 : 1;
	if (!inTargetShape(HOSTCATOM.getLocation(),"STARTFILE") || !inScaffold) {
		//HOSTCATOMSIM->red = 0;
		//HOSTCATOMSIM->green = 0;
		//HOSTCATOMSIM->blue = 0;
		HOSTCATOMSIM->alpha = 255; //transparent
		exists = false;
	}
	if ( startfile <= endfile ) inside=exists;  // use multiple target files
	else inside = (inTargetShape(HOSTCATOM.getLocation(),"ENDFILE") && inScaffold);
	
	if (exists && !inside) toEmpty++;
	
	if (bear_hack && inside) {
		if (p.getX()<48 || p.getZ()<77) {
			exists = false;
			inside = false;
		}
	}
	if (hostCatom == seedId) {isSeed = true;}
}


void DcStoy::endTick() {
	if (exists) condManager->tick();
	if ((inside && !exists) || (!inside && exists)) complete = 0;
	//if (isSeed) {cout << condManager->steps << endl; sleep(1);}
}

static char fname[1024];

void DcStoy::newTick() {
	if (worldPtr->current_time == restart_time) {
		state = 2;
		parent = -1;
		if (exists) HOSTCATOMSIM->alpha = ON_ALPHA;  // change color as well?
		gradient = 0;
		isSeed = false;
		if (hostCatom == seedId) seedId=0;
		inside = (inTargetShape(HOSTCATOM.getLocation(),fname) && inScaffold);
		if (bear_hack && inside) {
			Point3D p = HOSTCATOM.getLocation();
			if (p.getX()<48 || p.getZ()<77) {
				exists = false;
				inside = false;
				HOSTCATOMSIM->blue=255;
			}
		}
	}
	if (seedId==0 && exists && inside) { // note: RACE CONDITION
		seedId = hostCatom;
		isSeed=true;
		cout << "Automatically setting seed as " << seedId << endl;
	}
	if (isSeed) {
		//gather and print statistics
		long msgCount = 0;
		long totalMoves = 0;
		long worstMsgTotal = 0;
		long worstTick = 0;
		long correctFilled = 0;
		long incorrectFilled = 0;
		long incorrectEmpty = 0;
		long existingCount = 0;
		map<catomID,ModuleWrapper* >::iterator currWrapper;
		for (currWrapper = catomWrappers.begin(); currWrapper != catomWrappers.end(); currWrapper++) {
			msgCount += ((CatomWrapper*)(*currWrapper).second)->sendCount;
			if (((CatomWrapper*)(*currWrapper).second)->sendCount > worstMsgTotal) worstMsgTotal = ((CatomWrapper*)(*currWrapper).second)->sendCount;
			totalMoves += REMOTE_CODE_MODULE((*currWrapper).first,DcStoy)->moveCount;
			if (REMOTE_CODE_MODULE((*currWrapper).first,DcStoy)->inside) existingCount++;
			if (REMOTE_CODE_MODULE((*currWrapper).first,DcStoy)->exists && REMOTE_CODE_MODULE((*currWrapper).first,DcStoy)->inside) correctFilled++;
			if (REMOTE_CODE_MODULE((*currWrapper).first,DcStoy)->exists && !REMOTE_CODE_MODULE((*currWrapper).first,DcStoy)->inside) incorrectFilled++;
			if (!REMOTE_CODE_MODULE((*currWrapper).first,DcStoy)->exists && REMOTE_CODE_MODULE((*currWrapper).first,DcStoy)->inside) incorrectEmpty++;
			//worst messages this tick
			long thisTick = ((CatomWrapper*)(*currWrapper).second)->sendCount - REMOTE_CODE_MODULE((*currWrapper).first,DcStoy)->msgsLastTick;
			if (thisTick > worstTick) worstTick = thisTick;
			REMOTE_CODE_MODULE((*currWrapper).first,DcStoy)->msgsLastTick = ((CatomWrapper*)(*currWrapper).second)->sendCount;
		}
		cout <<  worldPtr->current_time+1 << " " << msgCount << " " << totalMoves << " 0 ";
		cout << correctFilled << " " << existingCount << " " << incorrectFilled << " " << toEmpty;
		cout << " " << worstMsgTotal << " " << worstTick << endl;
		
// 		cout << "on step " << worldPtr->current_time+1 << " with " << msgCount << " total messages, " << totalMoves << " total moves. ";
// 		cout << "completion fill:" << correctFilled << "/" << existingCount << " empty:" << incorrectFilled << "/" << toEmpty;
// 		cout << ". worst total: " << worstMsgTotal << " per-tick: " << worstTick << endl;
		
		if (complete>5) {
			if (startfile<=endfile) {
				restart_time = worldPtr->current_time+1;
				string tmp = worldPtr->search_key_value_list("ENDFILE");
				snprintf( fname, 1024, tmp.c_str(), startfile );
				cout << "Loading " << fname << endl;
				isSeed=false;
				complete = 0;
				startfile++;
			} else {
				cout << "No more shape files\n";
				worldPtr->timesteps = 1; // evil way to quit
			}
		}
		else complete++; 
	}
	worldPtr->clearLines(hostCatom);
}

//----wrapper support functions----------------

set<ModuleWrapper *> StoyWrapper::neighbors() {
	return allNeighbors(catom->C.getID(),true);
}

VarCode StoyWrapper::codeForVarname(string varname) {
	if (varname == "numNeighbors") {
		return kNumNeighbors;
	}
	else if ((varname == "dcond.state") || (varname == "state")) {
		return kState;
	}
	else if ((varname == "dcond.inside") || (varname == "inside")) {
		return kInside;
	}
	else if ((varname == "dcond.parent") || (varname == "parent")) {
		return kParent;
	}
	else if ((varname == "dcond.rsc") || (varname == "rsc")) {
		return kRsc;
	}
	else if ((varname == "dcond.gradient") || (varname == "gradient")) {
		return kGradient;
	}
	else if ((varname == "dcond.isSeed") || (varname == "isSeed")) {
		return kIsSeed;
	}
	else if (varname == "gradOrigin") {
		return kGradOrigin;
	}
	else if ((varname == "$dcond.freeSpaces") || (varname == "$freeSpaces")) { 
		return kFreeSpaces;
	}
	else if ((varname == "$dcond.notChildren") || (varname == "$notChildren")) {
		return kNotChildren;
	}
	else if (varname == "$neighbors") { 
		return kNeighbors;
	}
	else return CatomWrapper::codeForVarname(varname);
}


float StoyWrapper::getRealVar(VarCode var) {
	switch (var) {
		case kNumNeighbors:
			{
				return allNeighbors(catom->C.getID(),true).size();
			}
			break;
		case kState:
			return REMOTE_CODE_MODULE(id,DcStoy)->state;
			break;
		case kInside:
			return REMOTE_CODE_MODULE(id,DcStoy)->inside;
			break;
		case kParent:
			return REMOTE_CODE_MODULE(id,DcStoy)->parent;
			break;
		case kRsc:
			return REMOTE_CODE_MODULE(id,DcStoy)->hasRsc;
			break;
		case kGradient:
			return REMOTE_CODE_MODULE(id,DcStoy)->gradient;
			break;
		case kIsSeed:
			return REMOTE_CODE_MODULE(id,DcStoy)->isSeed;
			break;
		case kGradOrigin:
			return REMOTE_CODE_MODULE(id,DcStoy)->gradOrigin;
			break;
		default:
			return CatomWrapper::getRealVar(var);
	}
	return 0.0;
}

void StoyWrapper::setRealVar(VarCode var, float val) {
	switch (var) {
		case kState:
			REMOTE_CODE_MODULE(id,DcStoy)->state = val;
			break;
		case kParent:
			REMOTE_CODE_MODULE(id,DcStoy)->parent = val;
			break;
		case kRsc:
			 REMOTE_CODE_MODULE(id,DcStoy)->hasRsc = (val == 1.0);
			break;
		case kGradient:
			REMOTE_CODE_MODULE(id,DcStoy)->gradient = val;
			break;
		case kGradOrigin:
			REMOTE_CODE_MODULE(id,DcStoy)->gradOrigin = val;
			break;
		default:
			CatomWrapper::setRealVar(var,val);
	}
}

set<float> StoyWrapper::getSetVar(VarCode var) {
	set<float> value;
	switch (var) {
		case kFreeSpaces:
			{ //this should be all neighbors who exist, are inside, and invisible
				for (unsigned k = 1; k <= NUM_FEATURES; k++) {
					catomID kthNeighbor = catom->C.getNeighbor(k);
					if (kthNeighbor && REMOTE_CODE_MODULE(kthNeighbor,DcStoy)->inside &&
								!REMOTE_CODE_MODULE(kthNeighbor,DcStoy)->exists) {
						value.insert(kthNeighbor); //using featureId here
					}
				}
			}
			return value;
			break;
		case kNotChildren:
			return REMOTE_CODE_MODULE(id,DcStoy)->notChildren;
			break;
		case kNeighbors:
			{ //all visible neighbors
				for (unsigned k = 1; k <= NUM_FEATURES; k++) {
					catomID kthNeighbor = catom->C.getNeighbor(k);
					if (kthNeighbor && REMOTE_CODE_MODULE(kthNeighbor,DcStoy)->exists) {
						value.insert(kthNeighbor);
					}
				}
			}
			return value;
			break;
		default:
			return CatomWrapper::getSetVar(var);
	}
	return value;
}

//does proposed location have any visible neighbors (besides ignored location)?
//used to ensure that we're moving somewhere with support
bool hasAnotherNeighbor(catomID proposed, catomID ignoring) {
	for (unsigned k = 1; k <= NUM_FEATURES; k++) {
		catomID kthNeighbor = worldPtr->catomHash[proposed]->C.getNeighbor(k);
		if (kthNeighbor && (kthNeighbor != ignoring) && REMOTE_CODE_MODULE(kthNeighbor,DcStoy)->exists) return true;
	}
	return false;
}

bool closerOnOneAxis(Point3D currLoc,Point3D intendedLoc,Point3D targetLoc) {
	//closer in Euclidian distance
	if (intendedLoc.distanceFrom(targetLoc) < currLoc.distanceFrom(targetLoc)) return true;
	//closer on one axis
	else if (fabs(targetLoc.getX() - intendedLoc.getX()) < fabs(currLoc.getX() - intendedLoc.getX())) return true;
	else if (fabs(targetLoc.getY() - intendedLoc.getY()) < fabs(currLoc.getY() - intendedLoc.getY())) return true;
	else if (fabs(targetLoc.getZ() - intendedLoc.getZ()) < fabs(currLoc.getZ() - intendedLoc.getZ())) return true;
	return false;
}

void performMove(catomID moveFrom,catomID moveTo,float origin) {
	worldPtr->catomHash[moveTo]->alpha = ON_ALPHA;
	REMOTE_CODE_MODULE(moveTo,DcStoy)->gradOrigin = origin;
	REMOTE_CODE_MODULE(moveTo,DcStoy)->notChildren.clear();
	REMOTE_CODE_MODULE(moveTo,DcStoy)->state = 2;
	REMOTE_CODE_MODULE(moveTo,DcStoy)->gradient = 0;
	REMOTE_CODE_MODULE(moveTo,DcStoy)->parent = -1;
	REMOTE_CODE_MODULE(moveTo,DcStoy)->exists = true;
					
	REMOTE_CODE_MODULE(moveFrom,DcStoy)->exists = false;
	worldPtr->catomHash[moveFrom]->alpha = 255;
	REMOTE_CODE_MODULE(moveFrom,DcStoy)->moveCount++;
}

void StoyWrapper::callFcn(string fname, float arg) {
	if (!REMOTE_CODE_MODULE(id,DcStoy)->exists) return;
	//TODO: add set insert and set remove functions
	if (fname == "addNotChild") {
		REMOTE_CODE_MODULE(id,DcStoy)->notChildren.insert(arg);
	}
	else if (fname == "removeNotChild") {
		REMOTE_CODE_MODULE(id,DcStoy)->notChildren.erase(arg);
	}
	else if (fname == "clearNotChild") {
		REMOTE_CODE_MODULE(id,DcStoy)->notChildren.clear();
	}
	else if (fname == "debug") {
		if (arg == 130) {
			copy(REMOTE_CODE_MODULE(id,DcStoy)->notChildren.begin(),
			     REMOTE_CODE_MODULE(id,DcStoy)->notChildren.end(),
			     ostream_iterator<float>(cout, " "));
			cout << " gotcha!" << endl;
		}
	}
	else if (fname == "moveTowards") {
		Point3D gradOrigin = worldPtr->catomHash[(int)arg]->C.getLocation();
		Point3D currLocation = catom->C.getLocation();
		set<ModuleWrapper*>allEmpties = allNeighbors(id,false);
		for(set<ModuleWrapper*>::const_iterator nIter = allEmpties.begin(); nIter != allEmpties.end(); nIter++) {
			catomID nId = (*nIter)->id;
			Point3D neighborLoc = worldPtr->catomHash[nId]->C.getLocation();
			if (hasAnotherNeighbor(nId,id) && (neighborLoc.distanceFrom(gradOrigin) < currLocation.distanceFrom(gradOrigin))) {
				performMove(id,nId,arg);
				return;	
			}
		}
		//else move to another space which isn't worse
		for(set<ModuleWrapper*>::const_iterator nIter = allEmpties.begin(); nIter != allEmpties.end(); nIter++) {
			catomID nId = (*nIter)->id;
			Point3D neighborLoc = worldPtr->catomHash[nId]->C.getLocation();
			if (hasAnotherNeighbor(nId,id) && (neighborLoc.distanceFrom(gradOrigin) <= currLocation.distanceFrom(gradOrigin))) {
				//do move towards grad origin
				performMove(id,nId,arg);
				return;	
			}
		}
		//else move to another space which is closer on at least one axis
		for(set<ModuleWrapper*>::const_iterator nIter = allEmpties.begin(); nIter != allEmpties.end(); nIter++) {
			catomID nId = (*nIter)->id;
			Point3D neighborLoc = worldPtr->catomHash[nId]->C.getLocation();
			if (hasAnotherNeighbor(nId,id) && closerOnOneAxis(currLocation,neighborLoc,gradOrigin)) {
				//do move towards grad origin
				performMove(id,nId,arg);
				return;	
			}
		}
	}
	else  CatomWrapper::callFcn(fname,arg);
}
