#include <algorithm>
#include <iostream>
#include <errno.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include <ode/ode.h>

#include "DcSnake.hxx"

CODE_MODULE_DECLARATION( DcSnake, DcSnake );

using namespace std;


void DcSnake::simulationStart() {
	DistributedCondition::simulationStart();
	startPos = HOSTCATOMSIM->C.getLocation();
	phase = jointAngle = 0;
	parent = -1;
	time = 10.0;
	HOSTCATOMSIM->alpha = 80; //semi-transparent
}

void DcSnake::newTick() { 
	//jointAngle = rand() % 60 - 30; //degrees
	//float allAngles[] = {0, -22, -30, 8, 14, -29, 22, 13, -30, 10, 15};
	//jointAngle = allAngles[hostCatom];
	time += 0.1;
	worldPtr->clearLines(hostCatom);
	condManager->tick();
}

//NOTE: module assumes linear chain of catoms, with ids from 1 (head) to n
void DcSnake::endTick() {
	if (hostCatom == 1) {
		//cout << condManager->steps << endl;
		//reset all catoms to original positions
		for (unsigned i = 1; i <= worldPtr->catomHash.size(); i++) {
			worldPtr->catomHash.find(i)->second->C.moveTo(REMOTE_CODE_MODULE(i,DcSnake)->startPos);
			//cout << REMOTE_CODE_MODULE(i,DcSnake)->jointAngle << ", ";
		}
		//cout << endl;
		
		//for each catom j...
		for (unsigned j = 1; j <= worldPtr->catomHash.size(); j++) {
			Point3D rotationCenter = worldPtr->catomHash.find(j)->second->C.getLocation();
			float angleRads = REMOTE_CODE_MODULE(j,DcSnake)->jointAngle * 0.0174532925199433; //degrees -> radians
			dQuaternion rotQuat;
			dQFromAxisAndAngle(rotQuat,0,0,1,2*angleRads);
			//rotate rest of chain
			for (unsigned k = j+1; k <= worldPtr->catomHash.size(); k++) {
				//rotate center point
				Point3D movingPt = worldPtr->catomHash.find(k)->second->C.getLocation();
				movingPt -= rotationCenter;
				Point3D movedPt;
				movedPt.setX(movingPt.getX()*cos(angleRads) - movingPt.getY()*sin(angleRads));
				movedPt.setY(movingPt.getY()*cos(angleRads) + movingPt.getX()*sin(angleRads));
				movedPt.setZ(movingPt.getZ());
				movedPt += rotationCenter;
				//get new orientation
				dQuaternion currOrient;
				currOrient[0] = dBodyGetQuaternion(worldPtr->catomHash.find(k)->second->body)[0];
				currOrient[1] = dBodyGetQuaternion(worldPtr->catomHash.find(k)->second->body)[1];
				currOrient[2] = dBodyGetQuaternion(worldPtr->catomHash.find(k)->second->body)[2];
				currOrient[3] = dBodyGetQuaternion(worldPtr->catomHash.find(k)->second->body)[3];
				dQuaternion newOrient;
				dQMultiply0(newOrient,rotQuat,currOrient);
				//move and rotate
				worldPtr->catomHash.find(k)->second->C.moveTo(movedPt, newOrient,true,true,true,true);
			}
		}
		
	}
}

//----wrapper support functions----------------

enum {
	kAngle = 1025,
 kPhase,kParent,kTime
};

VarCode SnakeWrapper::codeForVarname(string varname) {
	if (varname == "parent") {
		return kParent;
	}
	else if (varname == "angle") {
		return kAngle;
	}
	else if (varname == "phase") {
		return kPhase;
	}
	else if (varname == "time") {
		return kTime;
	}
	else return CatomWrapper::codeForVarname(varname);
}

float SnakeWrapper::getRealVar(VarCode var) {
	switch (var) {
		case kAngle:
			return REMOTE_CODE_MODULE(id,DcSnake)->jointAngle;
			break;
		case kParent:
			return REMOTE_CODE_MODULE(id,DcSnake)->parent;
			break;
		case kPhase:
			return REMOTE_CODE_MODULE(id,DcSnake)->phase;
			break;
		case kTime:
			return REMOTE_CODE_MODULE(id,DcSnake)->time;
			break;
		default:
			return CatomWrapper::getRealVar(var);
	}
	return 0.0;
}

void SnakeWrapper::setRealVar(VarCode var, float val) {
	switch (var) {
		case kAngle:
			REMOTE_CODE_MODULE(id,DcSnake)->jointAngle = val;
			break;
		case kParent:
			REMOTE_CODE_MODULE(id,DcSnake)->parent = val;
			break;
		case kPhase:
			REMOTE_CODE_MODULE(id,DcSnake)->phase = val;
			break;
		default:
			CatomWrapper::setRealVar(var,val);
	}
}
