#ifndef __DC_PLANNER2_H
#define __DC_PLANNER2_H

#include "DCondition.hxx"

CODE_MODULE_PROTOTYPE( DcPlanner2, DcPlanner2 );
using namespace std;

class PlannerWrapper: public CatomWrapper {
	public:
	PlannerWrapper(CatomSim* c) :CatomWrapper(c) {}
	virtual set<ModuleWrapper *> neighbors();
	virtual VarCode codeForVarname(string varname);
	virtual float getRealVar(VarCode var);
	virtual void setRealVar(VarCode var, float val);
	virtual set<float> getSetVar(VarCode var);
	virtual void callFcn(string fname, float arg);
	int moveDirection(int action, int hlDirection, int role, int step);
	set<float> openLocations();
	int numChildren(); //number of neighboring metamodules that are our children [FOR DEBUGGING ONLY]
};


class DcPlanner2 : public DistributedCondition {
public:
	virtual ModuleWrapper *localModule() { return new PlannerWrapper(HOSTCATOMSIM); }
	void simulationStart();
	void newTick();
	void endTick();
	float randomVal;
	float state;
	float inside;
	bool isSeed;
	bool switchtopath;
	float parent;
	float depth; //for moving up deletion tree
	float gradient; //for moving inside object
	bool exists;
	bool hasRsc;
	int repopulate;
	bool delayed_delete;
	bool deleteme;
	set<float> notChildOf;
	
	int role;
	bool moveErr;
	float llParent;
	int llAction;
	int llActionDir;
	int llMoveDir;
	int llStepNum;
	float llNextParent;
	set<float> llChildrenDone;
	int llOperationLocked;
	int isPassive;
	int llOpTimestamp;
	int llProposedOp;
	int newParentRole;
	set<float> hlNeighbors;
	
	static int complete;
	static catomID seedId;
	static int startfile;
	static int endfile;
	static bool use_meta;
	static bool bear_hack;
	static long restart_time;
	
	long moveCount;
	long createCount;
	long msgsLastTick;
	static long toEmpty;
	
	DcPlanner2(catomID _hostCatom):DistributedCondition(_hostCatom)  {
		if (_hostCatom==0) {
			string tmp;
			tmp = worldPtr->search_key_value_list("PLAN_SEED");
			if (tmp!="") seedId = atoi(tmp.c_str());
			tmp = worldPtr->search_key_value_list("DcPlanner_use_meta");
			if (tmp=="true") use_meta=true; else use_meta=false;
			tmp = worldPtr->search_key_value_list("DcPlanner_startfilenum");
			if (tmp!="") startfile = atoi(tmp.c_str());
			tmp = worldPtr->search_key_value_list("DcPlanner_endfilenum");
			if (tmp!="") endfile = atoi(tmp.c_str());
			tmp = worldPtr->search_key_value_list("DcPlanner_bear_hack");
			if (tmp=="true") bear_hack=true; else bear_hack=false;
		}
	}
};

#endif
