#include <algorithm>
#include <iostream>
#include <errno.h>
#include <string.h>
#include <stdlib.h>

#include "DcPlanner2.hxx"
#include "pathsupport.hxx"
#include "DcPlanner2Almanac.hxx"

// Reimplementation of the metamodule planner with support for low-level operations

#define C_RADIUS 1.0

CODE_MODULE_DECLARATION( DcPlanner2, DcPlanner2 );

int DcPlanner2::complete = 0;
catomID DcPlanner2::seedId = 0;
int DcPlanner2::startfile = 1;
int DcPlanner2::endfile = 0;
bool DcPlanner2::use_meta = true;
long DcPlanner2::restart_time = -2;
bool DcPlanner2::bear_hack=false;
long DcPlanner2::toEmpty = 0;

enum {
	kNumNeighbors = 1025,
 	kState,kInside,kParent,kRsc,kDepth,kGradient,kIsSeed,kDeleteMe,kRepopulate,
  	kSwitchToPath,kRandom,kFreeSpaces,kNotChildOf,kNeighbors, kRole, kLLParent,
	kLLAction, kLLActionDir, kLLMoveDir, kLLStepNum, kLLNextParent,kLLChildrenDone,
	kLLOperationLocked, kHLNeighbors, kNewParentRole, kIsPassive, kLLProposedOp,
	kLLOpTimestamp
};


using namespace std;

#define ON_ALPHA 80

enum {
	DIR_MINUS_X = 0,
	DIR_PLUS_X = 1,
	DIR_MINUS_Y = 2,
	DIR_PLUS_Y = 3,
	DIR_MINUS_Z = 4,
	DIR_PLUS_Z = 5
};

enum {
	ACT_NOTHING = 0,
	ACT_CREATE,
	ACT_DELETE,
	ACT_TRANSFER
};

Point3D destinationPoint(Point3D currLoc, int dir) {
	float x = currLoc.getX();
	float y = currLoc.getY();
	float z = currLoc.getZ();
	if (dir & (1 << DIR_PLUS_X)) x += 2.0*C_RADIUS;
	if (dir & (1 << DIR_MINUS_X)) x -= 2.0*C_RADIUS;
	if (dir & (1 << DIR_PLUS_Y)) y += 2.0*C_RADIUS;
	if (dir & (1 << DIR_MINUS_Y)) y -= 2.0*C_RADIUS;
	if (dir & (1 << DIR_PLUS_Z)) z += 2.0*C_RADIUS;
	if (dir & (1 << DIR_MINUS_Z)) z -= 2.0*C_RADIUS;
	return Point3D(x,y,z);
}

int destinationDir(Point3D currLoc, Point3D destLoc) {
	if (currLoc.getX() > destLoc.getX()) return DIR_MINUS_X;
	else if (currLoc.getX() < destLoc.getX()) return DIR_PLUS_X;
	else if (currLoc.getY() > destLoc.getY()) return DIR_MINUS_Y;
	else if (currLoc.getY() < destLoc.getY()) return DIR_PLUS_Y;
	else if (currLoc.getZ() > destLoc.getZ()) return DIR_MINUS_Z;
	else if (currLoc.getZ() < destLoc.getZ()) return DIR_PLUS_Z;
	else {
		cout << "Source and dest. point are the same" <<endl;
		return -1;
	}
}

int newLeaderRole(int creationDir) {
	for (int i = 1; i < 8; i++) {
		if (createRoles[creationDir][i] == 0) return i;
	}
	cout << "No role will become leader for creation dir. " << creationDir << endl;
	return -1;
}

void DcPlanner2::simulationStart() {
	DistributedCondition::simulationStart();
		
	//setup for MM planner
	exists = true;
	moveCount = 0;
	msgsLastTick = 0;
	// the following is the standard clearing of state
	state = 2;
	parent = -1;
	HOSTCATOMSIM->alpha = ON_ALPHA;
	depth = INT_MAX;
	gradient = INT_MAX;
	isSeed = false;
	delayed_delete = false;
	deleteme=false;
	switchtopath=false;
	hasRsc = 0;
	//set up roles based on assumption that there are masters (role = 0) at (0,0,1) and every 4Rx4Rx4R gridpoint emanating from there
	role = (abs((int)HOSTCATOMSIM->C.getLocation().getX() / (2*(int)C_RADIUS)) % 2) 
		+ 2*(abs((int)HOSTCATOMSIM->C.getLocation().getY() / (2*(int)C_RADIUS)) % 2) 
		+ 4*((((int)HOSTCATOMSIM->C.getLocation().getZ() -1 )/ (2*(int)C_RADIUS)) % 2);
	//find our parent
	float x = HOSTCATOMSIM->C.getLocation().getX();
	float y = HOSTCATOMSIM->C.getLocation().getY();
	float z = HOSTCATOMSIM->C.getLocation().getZ();
	if (role & 1) x-= 2.0*C_RADIUS;
	if (role & 2) y -= 2.0*C_RADIUS;
	if (role & 4) z -= 2.0*C_RADIUS;
	llParent = worldPtr->catomAt(Point3D(x,y,z));
	llAction = ACT_NOTHING;
	llProposedOp = ACT_NOTHING;
	llActionDir = -1;
	llMoveDir = 0;
	llStepNum = -1;
	llNextParent = -1;
	llOperationLocked = 0;
	newParentRole = -1;
	isPassive = 0;
	llOpTimestamp = 0;
	
	if (hostCatom == seedId) {isSeed = true;}

	// determine whether or not we have a resource
	if ((role == 0) && worldPtr->catomAt(Point3D(HOSTCATOMSIM->C.getLocation().getX()+2.0*C_RADIUS,
											  HOSTCATOMSIM->C.getLocation().getY()+2.0*C_RADIUS,
											  HOSTCATOMSIM->C.getLocation().getZ()+2.0*C_RADIUS))) {
		hasRsc = 1;
	}
}


void DcPlanner2::endTick() {
	if (exists) condManager->tick();
	//if (hostCatom == 1) cout << "." << endl;
	
	// if (hostCatom == 58) {
	// 	cout << "catom 58 parent = " << REMOTE_CODE_MODULE(hostCatom,DcPlanner2)->parent << endl;
	// 	cout << "not children: ";
	// 	copy(REMOTE_CODE_MODULE(hostCatom,DcPlanner2)->notChildOf.begin(), REMOTE_CODE_MODULE(hostCatom,DcPlanner2)->notChildOf.end(), ostream_iterator<float>(cout, " "));
	// 	cout << endl;
	// 	cout << "hl neighbors: ";
	// 	copy(REMOTE_CODE_MODULE(hostCatom,DcPlanner2)->hlNeighbors.begin(), REMOTE_CODE_MODULE(hostCatom,DcPlanner2)->hlNeighbors.end(), ostream_iterator<float>(cout, " "));
	// 	cout << endl;
	// }
}

//static char fname[1024];

void DcPlanner2::newTick() {
	if (seedId==0 && exists && inside) { // note: RACE CONDITION
		seedId = hostCatom;
		isSeed=true;
		cout << "Automatically setting seed as " << seedId << endl;
	}
	randomVal = random() % 2;
	
	if (isSeed && false) {
		//gather and print statistics
		long msgCount = 0;
		long totalMoves = 0;
		long worstMsgTotal = 0;
		long worstTick = 0;
		long correctFilled = 0;
		long incorrectFilled = 0;
		long existingCount = 0;
		map<catomID,ModuleWrapper* >::iterator currWrapper;
		for (currWrapper = catomWrappers.begin(); currWrapper != catomWrappers.end(); currWrapper++) {
			msgCount += ((CatomWrapper*)(*currWrapper).second)->sendCount;
			if (((CatomWrapper*)(*currWrapper).second)->sendCount > worstMsgTotal) worstMsgTotal = ((CatomWrapper*)(*currWrapper).second)->sendCount;
			totalMoves += REMOTE_CODE_MODULE((*currWrapper).first,DcPlanner2)->moveCount;
			if (REMOTE_CODE_MODULE((*currWrapper).first,DcPlanner2)->role == 0) existingCount++;
			if ((REMOTE_CODE_MODULE((*currWrapper).first,DcPlanner2)->role == 0) && REMOTE_CODE_MODULE((*currWrapper).first,DcPlanner2)->inside) correctFilled++;
			if ((REMOTE_CODE_MODULE((*currWrapper).first,DcPlanner2)->role == 0) && !REMOTE_CODE_MODULE((*currWrapper).first,DcPlanner2)->inside) incorrectFilled++;
			//worst messages this tick
			long thisTick = ((CatomWrapper*)(*currWrapper).second)->sendCount - REMOTE_CODE_MODULE((*currWrapper).first,DcPlanner2)->msgsLastTick;
			if (thisTick > worstTick) worstTick = thisTick;
			REMOTE_CODE_MODULE((*currWrapper).first,DcPlanner2)->msgsLastTick = ((CatomWrapper*)(*currWrapper).second)->sendCount;
		}
		cout <<  worldPtr->current_time+1 << " " << msgCount << " " << totalMoves << " 0 ";
		cout << correctFilled << " " << existingCount << " " << incorrectFilled;
		cout << " " << worstMsgTotal << " " << worstTick << endl;

// 		cout << "on step " << worldPtr->current_time+1 << " with " << msgCount << " total messages, " << totalMoves << " total moves. ";
// 		cout << "completion fill:" << correctFilled << "/" << existingCount << " empty:" << incorrectFilled << "/" << toEmpty;
// 		cout << ". worst total: " << worstMsgTotal << " per-tick: " << worstTick << endl;
	}

	worldPtr->clearLines(hostCatom);
}

//----wrapper support functions----------------

set<ModuleWrapper *> PlannerWrapper::neighbors() {
	set<ModuleWrapper*> n;
	for (unsigned k = 1; k <= NUM_FEATURES; k++) {
		catomID kthNeighbor = catom->C.getNeighbor(k);  
		if (kthNeighbor) {
			n.insert((ModuleWrapper*)catomWrappers[kthNeighbor]);
		}
	}
	return n;
}

VarCode PlannerWrapper::codeForVarname(string varname) {
	if (varname == "numNeighbors") {return kNumNeighbors;}
	else if (varname == "state") {return kState;}
	else if (varname == "inside") {return kInside;}
	else if (varname == "parent") {return kParent;}
	else if (varname == "rsc") {return kRsc;}
	else if (varname == "depth") {return kDepth;}
	else if (varname == "gradient") {return kGradient;}
	else if (varname == "isSeed") {return kIsSeed;}
	else if (varname == "deleteMe") {return kDeleteMe;}
	else if (varname == "repopulate") {return kRepopulate;}
	else if (varname == "switchToPath") {return kSwitchToPath;}
	else if (varname == "random") {return kRandom;}
	else if (varname == "role") {return kRole;}
	else if (varname == "llParent") {return kLLParent;}
	else if (varname == "llAction") {return kLLAction;}
	else if (varname == "llActionDir") {return kLLActionDir;}
	else if (varname == "llMoveDir") {return kLLMoveDir;}
	else if (varname == "llStepNum") {return kLLStepNum;}
	else if (varname == "llNextParent") {return kLLNextParent;}
	else if (varname == "llOperationLocked") {return kLLOperationLocked;}
	else if (varname == "newParentRole") {return kNewParentRole;}
	else if (varname == "isPassive") {return kIsPassive;}
	else if (varname == "llProposedOp") {return kLLProposedOp;}
	else if (varname == "llOpTimestamp") {return kLLOpTimestamp;}
	else if (varname == "$freeSpaces") { return kFreeSpaces;}
	else if (varname == "$notChildOf") {return kNotChildOf;}
	else if (varname == "$neighbors") { return kNeighbors;}
	else if (varname == "$hlNeighbors") { return kHLNeighbors;}
	else if (varname == "$llChildrenDone") {return kLLChildrenDone;}
	else return CatomWrapper::codeForVarname(varname);
}


float PlannerWrapper::getRealVar(VarCode var) {
	switch (var) {
		case kNumNeighbors:
			{
				int numNeighbors = 0;
				for (unsigned k = 1; k <= NUM_FEATURES; k++) { 
					catomID kthNeighbor = catom->C.getNeighbor(k);  // fixed -- Babu
					if (kthNeighbor) numNeighbors++;
				}
				return numNeighbors;
			}
			break;
		case kState:
			return REMOTE_CODE_MODULE(id,DcPlanner2)->state;
			break;
		case kInside:
			return inTargetShape(catom->C.getLocation(),"ENDFILE") ? 1 : 0;
			break;
		case kParent:
			return REMOTE_CODE_MODULE(id,DcPlanner2)->parent;
			break;
		case kRsc:
			return REMOTE_CODE_MODULE(id,DcPlanner2)->hasRsc;
			break;
		case kDepth:
			return REMOTE_CODE_MODULE(id,DcPlanner2)->depth;
			break;
		case kGradient:
			return REMOTE_CODE_MODULE(id,DcPlanner2)->gradient;
			break;
		case kIsSeed:
			return REMOTE_CODE_MODULE(id,DcPlanner2)->isSeed;
			break;
		case kDeleteMe:
			return REMOTE_CODE_MODULE(id,DcPlanner2)->deleteme;
			break;
		case kRepopulate:
			return REMOTE_CODE_MODULE(id,DcPlanner2)->repopulate;
			break;
		case kSwitchToPath:
			return REMOTE_CODE_MODULE(id,DcPlanner2)->switchtopath;
			break;
		case kRandom:
			return REMOTE_CODE_MODULE(id,DcPlanner2)->randomVal;
			break;
		case kRole:
			return REMOTE_CODE_MODULE(id,DcPlanner2)->role;
			break;
		case kLLParent:
			return REMOTE_CODE_MODULE(id,DcPlanner2)->llParent;
			break;
		case kLLAction:
			return REMOTE_CODE_MODULE(id,DcPlanner2)->llAction;
			break;
		case kLLActionDir:
			return REMOTE_CODE_MODULE(id,DcPlanner2)->llActionDir;
			break;
		case kLLMoveDir:
			return REMOTE_CODE_MODULE(id,DcPlanner2)->llMoveDir;
			break;
		case kLLStepNum:
			return REMOTE_CODE_MODULE(id,DcPlanner2)->llStepNum;
			break;
		case kLLNextParent:
			return REMOTE_CODE_MODULE(id,DcPlanner2)->llNextParent;
			break;
		case kLLOperationLocked:
			return REMOTE_CODE_MODULE(id,DcPlanner2)->llOperationLocked;
			break;
		case kNewParentRole:
			return REMOTE_CODE_MODULE(id,DcPlanner2)->newParentRole;
			break;
		case kIsPassive:
			return REMOTE_CODE_MODULE(id,DcPlanner2)->isPassive;
			break;
		case kLLProposedOp:
			return REMOTE_CODE_MODULE(id,DcPlanner2)->llProposedOp;
			break;
		case kLLOpTimestamp:
			return REMOTE_CODE_MODULE(id,DcPlanner2)->llOpTimestamp;
			break;
		default:
			return CatomWrapper::getRealVar(var);
	}
	return 0.0;
}

void PlannerWrapper::setRealVar(VarCode var, float val) {
	switch (var) {
		case kState:
			REMOTE_CODE_MODULE(id,DcPlanner2)->state = val;
			break;
		case kParent:
			REMOTE_CODE_MODULE(id,DcPlanner2)->parent = val;
			//cout << id << " sets parent to " << val << endl;
			break;
		case kRsc:
			 REMOTE_CODE_MODULE(id,DcPlanner2)->hasRsc = (val == 1.0);
			break;
		case kDepth:
			REMOTE_CODE_MODULE(id,DcPlanner2)->depth = val;
			break;
		case kGradient:
			REMOTE_CODE_MODULE(id,DcPlanner2)->gradient = val;
			break;
		case kDeleteMe:
			REMOTE_CODE_MODULE(id,DcPlanner2)->deleteme = (val != 0);
			break;
		case kRepopulate:
			REMOTE_CODE_MODULE(id,DcPlanner2)->repopulate = val;
			break;
		case kSwitchToPath:
			REMOTE_CODE_MODULE(id,DcPlanner2)->switchtopath = (val != 0);
			break;
		case kLLParent:
			REMOTE_CODE_MODULE(id,DcPlanner2)->llParent = val;
			break;
		case kLLAction:
			REMOTE_CODE_MODULE(id,DcPlanner2)->llAction = val;
			break;
		case kLLActionDir:
			REMOTE_CODE_MODULE(id,DcPlanner2)->llActionDir = val;
			break;
		case kLLMoveDir:
			REMOTE_CODE_MODULE(id,DcPlanner2)->llMoveDir = val;
			break;
		case kLLStepNum:
			REMOTE_CODE_MODULE(id,DcPlanner2)->llStepNum = val;
			break;
		case kLLNextParent:
			REMOTE_CODE_MODULE(id,DcPlanner2)->llNextParent = val;
			break;
		case kIsPassive:
			REMOTE_CODE_MODULE(id,DcPlanner2)->isPassive = val;
			break;
		case kLLProposedOp:
			REMOTE_CODE_MODULE(id,DcPlanner2)->llProposedOp = val;
			break;
		case kLLOpTimestamp:
			REMOTE_CODE_MODULE(id,DcPlanner2)->llOpTimestamp = val;
			break;
		case kLLOperationLocked:
			REMOTE_CODE_MODULE(id,DcPlanner2)->llOperationLocked = val;
			break;
		default:
			CatomWrapper::setRealVar(var,val);
	}
}

set<float> PlannerWrapper::openLocations() {
	set<float> value;
	Point3D currLoc = catom->C.getLocation();
	float x = currLoc.getX();
	float y = currLoc.getY();
	float z = currLoc.getZ();
	Point3D testPt = Point3D(x+(4*C_RADIUS),y,z);
	if (!worldPtr->catomAt(testPt) && inTargetShape(testPt,"ENDFILE")) value.insert(destinationDir(currLoc,testPt));
	testPt = Point3D(x-(4*C_RADIUS),y,z);
	if (!worldPtr->catomAt(testPt) && inTargetShape(testPt,"ENDFILE")) value.insert(destinationDir(currLoc,testPt));
	testPt = Point3D(x,y+(4*C_RADIUS),z);
	if (!worldPtr->catomAt(testPt) && inTargetShape(testPt,"ENDFILE")) value.insert(destinationDir(currLoc,testPt));
	testPt = Point3D(x,y-(4*C_RADIUS),z);
	if (!worldPtr->catomAt(testPt) && inTargetShape(testPt,"ENDFILE")) value.insert(destinationDir(currLoc,testPt));
	testPt = Point3D(x,y,z+(4*C_RADIUS));
	if (!worldPtr->catomAt(testPt) && inTargetShape(testPt,"ENDFILE")) value.insert(destinationDir(currLoc,testPt));
	testPt = Point3D(x,y,z-(4*C_RADIUS));
	if (!worldPtr->catomAt(testPt) && inTargetShape(testPt,"ENDFILE")) value.insert(destinationDir(currLoc,testPt));
	return value;
}

int PlannerWrapper::numChildren() {
	int value = 0;
	Point3D currLoc = catom->C.getLocation();
	float x = currLoc.getX();
	float y = currLoc.getY();
	float z = currLoc.getZ();
	Point3D testPt = Point3D(x+(4*C_RADIUS),y,z);
	catomID testCatom = worldPtr->catomAt(testPt);
	if (testCatom && (REMOTE_CODE_MODULE(testCatom,DcPlanner2)->parent == id)) value++;
	testPt = Point3D(x-(4*C_RADIUS),y,z);
	testCatom = worldPtr->catomAt(testPt);
	if (testCatom && (REMOTE_CODE_MODULE(testCatom,DcPlanner2)->parent == id)) value++;
	testPt = Point3D(x,y+(4*C_RADIUS),z);
	testCatom = worldPtr->catomAt(testPt);
	if (testCatom && (REMOTE_CODE_MODULE(testCatom,DcPlanner2)->parent == id)) value++;
	testPt = Point3D(x,y-(4*C_RADIUS),z);
	testCatom = worldPtr->catomAt(testPt);
	if (testCatom && (REMOTE_CODE_MODULE(testCatom,DcPlanner2)->parent == id)) value++;
	testPt = Point3D(x,y,z+(4*C_RADIUS));
	testCatom = worldPtr->catomAt(testPt);
	if (testCatom && (REMOTE_CODE_MODULE(testCatom,DcPlanner2)->parent == id)) value++;
	testPt = Point3D(x,y,z-(4*C_RADIUS));
	testCatom = worldPtr->catomAt(testPt);
	if (testCatom && (REMOTE_CODE_MODULE(testCatom,DcPlanner2)->parent == id)) value++;
	return value;
}

set<float> PlannerWrapper::getSetVar(VarCode var) {
	set<float> value;
	switch (var) {
		case kFreeSpaces:
			return this->openLocations();
		case kNotChildOf:
			return REMOTE_CODE_MODULE(id,DcPlanner2)->notChildOf;
		case kLLChildrenDone:
			return REMOTE_CODE_MODULE(id,DcPlanner2)->llChildrenDone;
		case kHLNeighbors:
			return REMOTE_CODE_MODULE(id,DcPlanner2)->hlNeighbors;
		case kNeighbors:
			{
			for (unsigned k = 1; k <= NUM_FEATURES; k++) {
				catomID kthNeighbor = catom->C.getNeighbor(k);
				if (kthNeighbor) value.insert(kthNeighbor);
			}
			return value;
			}
			break;
		default:
			return CatomWrapper::getSetVar(var);
	}
	return value;
}

int PlannerWrapper::moveDirection(int action, int hlDirection, int role, int step) {
	if ((step == -1)) return 0;
	// guard against array overflow
	for (int i = 0; i < step; i++) {
		switch (action) {
			case ACT_TRANSFER:
				if (transferMoves[hlDirection][role][i] == 0) return 0;
				break;
			case ACT_CREATE:
				if (createMoves[hlDirection][role][i] == 0) return 0;
				break;
			case ACT_DELETE:
				if (deleteMoves[hlDirection][role][i] == 0) return 0;
				break;
		}
	}
	// perform the lookup
	switch (action) {
		case ACT_TRANSFER:
			return transferMoves[hlDirection][role][step];
		case ACT_CREATE:
			return createMoves[hlDirection][role][step];
		case ACT_DELETE:
			return deleteMoves[hlDirection][role][step];
	}
	
	return 0;
}

void PlannerWrapper::callFcn(string fname, float arg) {
	if (!REMOTE_CODE_MODULE(id,DcPlanner2)->exists) return;
	//TODO: add set insert and set remove functions
	if (fname == "addNotChild") {
		REMOTE_CODE_MODULE(id,DcPlanner2)->notChildOf.insert(arg);
	}
	else if (fname == "removeNotChild") {
		REMOTE_CODE_MODULE(id,DcPlanner2)->notChildOf.erase(arg);
	}
	else if (fname == "clearNotChild") {
		REMOTE_CODE_MODULE(id,DcPlanner2)->notChildOf.clear();
	}
	else if (fname == "addHLNeighbors") {
		REMOTE_CODE_MODULE(id,DcPlanner2)->hlNeighbors.insert(arg);
	}
	else if (fname == "removeHLNeighbors") {
		REMOTE_CODE_MODULE(id,DcPlanner2)->hlNeighbors.erase(arg);
	}
	else if (fname == "clearHLNeighbors") {
		REMOTE_CODE_MODULE(id,DcPlanner2)->hlNeighbors.clear();
	}
	else if (fname == "addChildDone") {
		REMOTE_CODE_MODULE(id,DcPlanner2)->llChildrenDone.insert(arg);
	}
	else if (fname == "removeChildDone") {
		REMOTE_CODE_MODULE(id,DcPlanner2)->llChildrenDone.erase(arg);
	}
	else if (fname == "clearChildDone") {
		REMOTE_CODE_MODULE(id,DcPlanner2)->llChildrenDone.clear();
	}
	else if (fname == "setActionDir") {
		REMOTE_CODE_MODULE(id,DcPlanner2)->llActionDir = 
			destinationDir(catom->C.getLocation(),worldPtr->catomHash[(int)arg]->C.getLocation());
		cout << worldPtr->current_time << ": " << id << " ("<< REMOTE_CODE_MODULE(id,DcPlanner2)->llAction << ") set action direction to " 
			 << REMOTE_CODE_MODULE(id,DcPlanner2)->llActionDir << endl;
	}
	else if (fname == "setUpAction") {
		REMOTE_CODE_MODULE(id,DcPlanner2)->llStepNum = 0;
		REMOTE_CODE_MODULE(id,DcPlanner2)->llMoveDir = this->moveDirection(
			REMOTE_CODE_MODULE(id,DcPlanner2)->llAction,
			REMOTE_CODE_MODULE(id,DcPlanner2)->llActionDir,
			REMOTE_CODE_MODULE(id,DcPlanner2)->role,
			REMOTE_CODE_MODULE(id,DcPlanner2)->llStepNum);
	}
	else if (fname == "print_dbg") {
		cout << arg << endl;
	}
	else if (fname == "setNewRole") {
		int actionDir = REMOTE_CODE_MODULE(id,DcPlanner2)->llActionDir;
		int currRole = REMOTE_CODE_MODULE(id,DcPlanner2)->role;
		switch (REMOTE_CODE_MODULE(id,DcPlanner2)->llAction) {
			case ACT_TRANSFER:
				if (transferActives[actionDir][currRole] == 1) {
					REMOTE_CODE_MODULE(id,DcPlanner2)->role = transferRoles[actionDir][currRole];
					REMOTE_CODE_MODULE(id,DcPlanner2)->llParent = (int) arg;
				}
			break;
			case ACT_CREATE:
				if (createActives[actionDir][currRole] == 1) {
					REMOTE_CODE_MODULE(id,DcPlanner2)->role = createRoles[actionDir][currRole];
					REMOTE_CODE_MODULE(id,DcPlanner2)->llParent = (int) arg;
				}
			break;
			case ACT_DELETE:
				if (deleteActives[actionDir][currRole] == 1) {
					//cout << REMOTE_CODE_MODULE(id,DcPlanner2)->role << " becomes " << deleteRoles[actionDir][currRole] << endl;
					REMOTE_CODE_MODULE(id,DcPlanner2)->role = deleteRoles[actionDir][currRole];
					REMOTE_CODE_MODULE(id,DcPlanner2)->llParent = (int) arg;
				}
			break;
		}
		if (REMOTE_CODE_MODULE(id,DcPlanner2)->role != 0) REMOTE_CODE_MODULE(id,DcPlanner2)->parent = -1;
	}
	else if (fname == "tryToMove") {
		if ((int)arg == -1) { // -1 == delay (and step to next instruction)
			REMOTE_CODE_MODULE(id,DcPlanner2)->llStepNum++;
			REMOTE_CODE_MODULE(id,DcPlanner2)->llMoveDir = this->moveDirection(
				REMOTE_CODE_MODULE(id,DcPlanner2)->llAction,
				REMOTE_CODE_MODULE(id,DcPlanner2)->llActionDir,
				REMOTE_CODE_MODULE(id,DcPlanner2)->role,
				REMOTE_CODE_MODULE(id,DcPlanner2)->llStepNum);
		}
		else {
			//cout << REMOTE_CODE_MODULE(id,DcPlanner2)->role << " moved from " << catom->C.getLocation();
			Point3D destPoint = destinationPoint(catom->C.getLocation(), (int) arg);
			REMOTE_CODE_MODULE(id,DcPlanner2)->moveErr = !catom->C.moveTo(destPoint);
			if (!REMOTE_CODE_MODULE(id,DcPlanner2)->moveErr) {
				REMOTE_CODE_MODULE(id,DcPlanner2)->llStepNum++;
				REMOTE_CODE_MODULE(id,DcPlanner2)->llMoveDir = this->moveDirection(
					REMOTE_CODE_MODULE(id,DcPlanner2)->llAction,
					REMOTE_CODE_MODULE(id,DcPlanner2)->llActionDir,
					REMOTE_CODE_MODULE(id,DcPlanner2)->role,
					REMOTE_CODE_MODULE(id,DcPlanner2)->llStepNum);
					REMOTE_CODE_MODULE(id,DcPlanner2)->moveCount++;
					//cout << " to " << destPoint.toString() << endl;
			}
			else {
				//cout << " to nowhere\n";
			}
		}
	}
	else if (fname == "setUpCreate") {
		cout << "Started create on catom id " << id;
		REMOTE_CODE_MODULE(id,DcPlanner2)->newParentRole = newLeaderRole((int)arg);
		REMOTE_CODE_MODULE(id,DcPlanner2)->llActionDir = (int) arg;
		cout << ", new master is at role " << REMOTE_CODE_MODULE(id,DcPlanner2)->newParentRole << endl;
	}
	else  CatomWrapper::callFcn(fname,arg);
}
