#ifndef __DC_PLANNER_H
#define __DC_PLANNER_H

#include "DCondition.hxx"

CODE_MODULE_PROTOTYPE( DcPlanner, DcPlanner );
using namespace std;

class FakeMetaWrapper: public CatomWrapper {
	public:
	FakeMetaWrapper(CatomSim* c) :CatomWrapper(c) {}
	virtual set<ModuleWrapper *> neighbors();
	virtual VarCode codeForVarname(string varname);
	virtual float getRealVar(VarCode var);
	virtual void setRealVar(VarCode var, float val);
	virtual set<float> getSetVar(VarCode var);
	virtual void callFcn(string fname, float arg);
};


class DcPlanner : public DistributedCondition {
public:
	virtual ModuleWrapper *localModule() { return new FakeMetaWrapper(HOSTCATOMSIM); }
	void simulationStart();
	void newTick();
	void endTick();
	float randomVal;
	float state;
	float inside;
	bool isSeed;
	bool switchtopath;
	float parent;
	float depth; //for moving up deletion tree
	float gradient; //for moving inside object
	bool exists;
	bool hasRsc;
	int repopulate;
	bool delayed_delete;
	bool deleteme;
	set<float> notChildOf;
	set<float> locks;
	float pParent;
	float pChild;
	
	static int complete;
	static catomID seedId;
	static int startfile;
	static int endfile;
	static bool use_meta;
	static bool bear_hack;
	static long restart_time;
	
	long moveCount;
	long createCount;
	long msgsLastTick;
	static long toEmpty;
	DcPlanner(catomID _hostCatom):DistributedCondition(_hostCatom)  {
		if (_hostCatom==0) {
			string tmp;
			tmp = worldPtr->search_key_value_list("PLAN_SEED");
			if (tmp!="") seedId = atoi(tmp.c_str());
			tmp = worldPtr->search_key_value_list("DcPlanner_use_meta");
			if (tmp=="true") use_meta=true; else use_meta=false;
			tmp = worldPtr->search_key_value_list("DcPlanner_startfilenum");
			if (tmp!="") startfile = atoi(tmp.c_str());
			tmp = worldPtr->search_key_value_list("DcPlanner_endfilenum");
			if (tmp!="") endfile = atoi(tmp.c_str());
			tmp = worldPtr->search_key_value_list("DcPlanner_bear_hack");
			if (tmp=="true") bear_hack=true; else bear_hack=false;
		}
	}};

#endif
