#include <algorithm>
#include <iostream>
#include <errno.h>
#include <string.h>
#include <stdlib.h>

#include "DcPlanner.hxx"
#include "pathsupport.hxx"

CODE_MODULE_DECLARATION( DcPlanner, DcPlanner );

int DcPlanner::complete = 0;
catomID DcPlanner::seedId = 0;
int DcPlanner::startfile = 1;
int DcPlanner::endfile = 0;
bool DcPlanner::use_meta = true;
long DcPlanner::restart_time = -2;
bool DcPlanner::bear_hack=false;
long DcPlanner::toEmpty = 0;

enum {
	kNumNeighbors = 1025,
 	kState,kInside,kParent,kRsc,kDepth,kGradient,kIsSeed,kDeleteMe,kRepopulate,
  	kSwitchToPath,kRandom,kFreeSpaces,kNotChildOf,kNeighbors,kLocks,kpParent,kpChild
};


using namespace std;

#define ON_ALPHA 80

void DcPlanner::simulationStart() {
	DistributedCondition::simulationStart();
		
	//setup for MM planner
	exists = true;
	// the following is the standard clearing of state
	state = 2;
	parent = -1;
	HOSTCATOMSIM->alpha = ON_ALPHA;
	depth = INT_MAX;
	gradient = INT_MAX;
	isSeed = false;
	delayed_delete = false;
	deleteme=false;
	switchtopath=false;
	pParent = pChild = -1;
	hasRsc = ((random() % 2) == 1);
	HOSTCATOMSIM->HACK_metamodule = hasRsc ? 2 : 1;
	
	repopulate = 0;
	moveCount = createCount = 0;
	msgsLastTick = 0;
	if (use_meta) HOSTCATOMSIM->HACK_metamodule = hasRsc ? 2 : 1;
	if (!inTargetShape(HOSTCATOM.getLocation(),"STARTFILE")) {
		HOSTCATOMSIM->red = 0;
		HOSTCATOMSIM->green = 0;
		HOSTCATOMSIM->blue = 0;
		HOSTCATOMSIM->alpha = 255; //transparent
		exists = false;
	}
	if ( startfile <= endfile ) inside=exists;  // use multiple target files
	else inside = inTargetShape(HOSTCATOM.getLocation(),"ENDFILE");
	if (bear_hack && inside) {
		Point3D p = HOSTCATOM.getLocation();
		if (p.getX()<48 || p.getZ()<77) {
			exists = false;
			inside = false;
		}
	}
	
	if (exists && !inside) toEmpty++;
	if (hostCatom == seedId) {isSeed = true;}
}


void DcPlanner::endTick() {
	if (exists) condManager->tick();
	if ((inside && !exists) || (!inside && exists)) complete = 0;
}

static char fname[1024];

void DcPlanner::newTick() {
// 	if (delayed_delete) {
// 		exists = false;
// 		HOSTCATOMSIM->alpha=255;
// 		delayed_delete=false;
// 	}
// 	if (worldPtr->current_time == restart_time) {
// 		state = 2;
// 		parent = -1;
// 		if (exists) HOSTCATOMSIM->alpha = ON_ALPHA;  // change color as well?
// 		depth = INT_MAX;
// 		gradient = INT_MAX;
// 		isSeed = false;
// 		delayed_delete=false;
// 		deleteme=false;
// 		switchtopath=false;
// 		if (hostCatom == seedId) seedId=0;
// 		inside = inTargetShape(HOSTCATOM.getLocation(),fname);
// 		if (bear_hack && inside) {
// 			Point3D p = HOSTCATOM.getLocation();
// 			if (p.getX()<48 || p.getZ()<77) {
// 				exists = false;
// 				inside = false;
// 				HOSTCATOMSIM->blue=255;
// 			}
// 		}
// 	}
	if (seedId==0 && exists && inside) { // note: RACE CONDITION
		seedId = hostCatom;
		isSeed=true;
		cout << "Automatically setting seed as " << seedId << endl;
	}
	if (isSeed) {
		//gather and print statistics
		long msgCount = 0;
		long totalMoves = 0;
		long totalCreates = 0;
		long worstMsgTotal = 0;
		long worstTick = 0;
		long correctFilled = 0;
		long incorrectFilled = 0;
		long incorrectEmpty = 0;
		long existingCount = 0;
		map<catomID,ModuleWrapper* >::iterator currWrapper;
		for (currWrapper = catomWrappers.begin(); currWrapper != catomWrappers.end(); currWrapper++) {
			msgCount += ((CatomWrapper*)(*currWrapper).second)->sendCount;
			if (((CatomWrapper*)(*currWrapper).second)->sendCount > worstMsgTotal) worstMsgTotal = ((CatomWrapper*)(*currWrapper).second)->sendCount;
			totalMoves += REMOTE_CODE_MODULE((*currWrapper).first,DcPlanner)->moveCount;
			totalCreates += REMOTE_CODE_MODULE((*currWrapper).first,DcPlanner)->createCount;
			if (REMOTE_CODE_MODULE((*currWrapper).first,DcPlanner)->inside) existingCount++;
			if (REMOTE_CODE_MODULE((*currWrapper).first,DcPlanner)->exists && REMOTE_CODE_MODULE((*currWrapper).first,DcPlanner)->inside) 
				correctFilled++;
			if (REMOTE_CODE_MODULE((*currWrapper).first,DcPlanner)->exists && !REMOTE_CODE_MODULE((*currWrapper).first,DcPlanner)->inside) 	
				incorrectFilled++;
			if (!REMOTE_CODE_MODULE((*currWrapper).first,DcPlanner)->exists && REMOTE_CODE_MODULE((*currWrapper).first,DcPlanner)->inside) 
				incorrectEmpty++;
			//worst messages this tick
			long thisTick = ((CatomWrapper*)(*currWrapper).second)->sendCount - REMOTE_CODE_MODULE((*currWrapper).first,DcPlanner)->msgsLastTick;
			if (thisTick > worstTick) worstTick = thisTick;
			REMOTE_CODE_MODULE((*currWrapper).first,DcPlanner)->msgsLastTick = ((CatomWrapper*)(*currWrapper).second)->sendCount;
		}
// 		cout << "on step " << worldPtr->current_time+1 << " with " << msgCount << " total messages, ";
// 		cout << totalMoves << " total moves, " << totalCreates << " total creates";
// 		cout << "completion fill:" << correctFilled << "/" << existingCount << " empty:" << incorrectFilled << "/" << toEmpty;
// 		cout << ". worst total: " << worstMsgTotal << " per-tick: " << worstTick << endl;
		
		cout << worldPtr->current_time+1 << " " << msgCount << " ";
		cout << totalMoves << " " << totalCreates << " ";
		cout <<  correctFilled << " " << existingCount << " " << incorrectFilled << " " << toEmpty;
		cout << " " << worstMsgTotal << " " << worstTick << endl;
		
//if (incorrectFilled == 0) worldPtr->timesteps = 1; //quit when done
		
// 		if (complete>5) {
// 			if (startfile<=endfile) {
// 				restart_time = worldPtr->current_time+1;
// 				string tmp = worldPtr->search_key_value_list("ENDFILE");
// 				snprintf( fname, 1024, tmp.c_str(), startfile );
// 				cout << "Loading " << fname << endl;
// 				isSeed=false;
// 				complete = 0;
// 				startfile++;
// 			} else {
// 				cout << "No more shape files\n";
// 				worldPtr->timesteps = 1; // evil way to quit
// 			}
// 		}
// 		else complete++; 
	}
	if (exists) randomVal = random() % 2;;
	worldPtr->clearLines(hostCatom);
	HOSTCATOMSIM->HACK_metamodule = hasRsc ? 2 : 1;
}

//----wrapper support functions----------------

set<ModuleWrapper *> FakeMetaWrapper::neighbors() {
	set<ModuleWrapper*> n;
	for (unsigned k = 1; k <= NUM_FEATURES; k++) {  // fixed - Babu
		catomID kthNeighbor = catom->C.getNeighbor(k);  
		if (kthNeighbor && REMOTE_CODE_MODULE(kthNeighbor,DcPlanner)->exists) { //only supply neighbors that exist
			n.insert((ModuleWrapper*)catomWrappers[kthNeighbor]);
		}
	}
	return n;
}

VarCode FakeMetaWrapper::codeForVarname(string varname) {
	if (varname == "numNeighbors") {
		return kNumNeighbors;
	}
	else if ((varname == "dcond.state") || (varname == "state")) {
		return kState;
	}
	else if ((varname == "dcond.inside") || (varname == "inside")) {
		return kInside;
	}
	else if ((varname == "dcond.parent") || (varname == "parent")) {
		return kParent;
	}
	else if ((varname == "dcond.rsc") || (varname == "rsc")) {
		return kRsc;
	}
	else if ((varname == "dcond.depth") || (varname == "depth")) {
		return kDepth;
	}
	else if ((varname == "dcond.gradient") || (varname == "gradient")) {
		return kGradient;
	}
	else if ((varname == "dcond.isSeed") || (varname == "isSeed")) {
		return kIsSeed;
	}
	else if ((varname == "dcond.deleteme") || (varname == "deleteMe")) {
		return kDeleteMe;
	}
	else if ((varname == "dcond.repopulate") || (varname == "repopulate")) {
		return kRepopulate;
	}
	else if ((varname == "dcond.switchtopath") || (varname == "switchToPath")) {
		return kSwitchToPath;
	}
	else if ((varname == "dcond.random") || (varname == "random")) {
		return kRandom;
	}
	else if ((varname == "$dcond.freeSpaces") || (varname == "$freeSpaces")) { 
		return kFreeSpaces;
	}
	else if ((varname == "$dcond.notChildOf") || (varname == "$notChildOf")) {
		return kNotChildOf;
	}
	else if (varname == "$neighbors") { 
		return kNeighbors;
	}
	else if (varname == "$locks") { 
		return kLocks;
	}
	else if (varname == "pParent") { 
		return kpParent;
	}
	else if (varname == "pChild") { 
		return kpChild;
	}
	else return CatomWrapper::codeForVarname(varname);
}


float FakeMetaWrapper::getRealVar(VarCode var) {
	switch (var) {
		case kNumNeighbors:
			{
				int numNeighbors = 0;
				for (unsigned k = 1; k <= NUM_FEATURES; k++) { //number of neighbors who exist and are visible
					catomID kthNeighbor = catom->C.getNeighbor(k);  // fixed -- Babu
					if (kthNeighbor && REMOTE_CODE_MODULE(kthNeighbor,DcPlanner)->exists) {
						numNeighbors++;
					}
				}
				return numNeighbors;
			}
			break;
		case kState:
			return REMOTE_CODE_MODULE(id,DcPlanner)->state;
			break;
		case kInside:
			return REMOTE_CODE_MODULE(id,DcPlanner)->inside;
			break;
		case kParent:
			return REMOTE_CODE_MODULE(id,DcPlanner)->parent;
			break;
		case kRsc:
			return REMOTE_CODE_MODULE(id,DcPlanner)->hasRsc;
			break;
		case kDepth:
			return REMOTE_CODE_MODULE(id,DcPlanner)->depth;
			break;
		case kGradient:
			return REMOTE_CODE_MODULE(id,DcPlanner)->gradient;
			break;
		case kIsSeed:
			return REMOTE_CODE_MODULE(id,DcPlanner)->isSeed;
			break;
		case kDeleteMe:
			return REMOTE_CODE_MODULE(id,DcPlanner)->deleteme;
			break;
		case kRepopulate:
			return REMOTE_CODE_MODULE(id,DcPlanner)->repopulate;
			break;
		case kSwitchToPath:
			return REMOTE_CODE_MODULE(id,DcPlanner)->switchtopath;
			break;
		case kRandom:
			return REMOTE_CODE_MODULE(id,DcPlanner)->randomVal;
			break;
		case kpParent:
			return REMOTE_CODE_MODULE(id,DcPlanner)->pParent;
			break;
		case kpChild:
			return REMOTE_CODE_MODULE(id,DcPlanner)->pChild;
			break;
		default:
			return CatomWrapper::getRealVar(var);
	}
	return 0.0;
}

void FakeMetaWrapper::setRealVar(VarCode var, float val) {
	switch (var) {
		case kState:
			REMOTE_CODE_MODULE(id,DcPlanner)->state = val;
			break;
		case kParent:
			REMOTE_CODE_MODULE(id,DcPlanner)->parent = val;
			break;
		case kRsc:
			 REMOTE_CODE_MODULE(id,DcPlanner)->hasRsc = (val == 1.0);
			break;
		case kDepth:
			REMOTE_CODE_MODULE(id,DcPlanner)->depth = val;
			break;
		case kGradient:
			REMOTE_CODE_MODULE(id,DcPlanner)->gradient = val;
			break;
		case kDeleteMe:
			REMOTE_CODE_MODULE(id,DcPlanner)->deleteme = (val != 0);
			break;
		case kRepopulate:
			REMOTE_CODE_MODULE(id,DcPlanner)->repopulate = val;
			break;
		case kSwitchToPath:
			REMOTE_CODE_MODULE(id,DcPlanner)->switchtopath = (val != 0);
			break;
		case kpParent:
			REMOTE_CODE_MODULE(id,DcPlanner)->pParent = val;
			break;
		case kpChild:
			REMOTE_CODE_MODULE(id,DcPlanner)->pChild = val;
			break;
		default:
			CatomWrapper::setRealVar(var,val);
	}
}

set<float> FakeMetaWrapper::getSetVar(VarCode var) {
	set<float> value;
	switch (var) {
		case kFreeSpaces:
			{ //this should be all neighbors who exist, are inside, and invisible
				for (unsigned k = 1; k <= NUM_FEATURES; k++) {
					catomID kthNeighbor = catom->C.getNeighbor(k);
					if (kthNeighbor && REMOTE_CODE_MODULE(kthNeighbor,DcPlanner)->inside &&
								!REMOTE_CODE_MODULE(kthNeighbor,DcPlanner)->exists) {
						value.insert(k); // fixed -- Babu -- using featureId here
					}
				}
			}
			return value;
			break;
		case kNotChildOf:
			return REMOTE_CODE_MODULE(id,DcPlanner)->notChildOf;
			break;
		case kLocks:
			return REMOTE_CODE_MODULE(id,DcPlanner)->locks;
			break;
		case kNeighbors:
			{ //all visible neighbors
			for (unsigned k = 1; k <= NUM_FEATURES; k++) {
				catomID kthNeighbor = catom->C.getNeighbor(k);
				if (kthNeighbor && REMOTE_CODE_MODULE(kthNeighbor,DcPlanner)->exists) {
					value.insert(kthNeighbor);
				}
			}
			return value;
			}
			break;
		default:
			return CatomWrapper::getSetVar(var);
	}
	return value;
}

void FakeMetaWrapper::callFcn(string fname, float arg) {
	if (!REMOTE_CODE_MODULE(id,DcPlanner)->exists) return;
	//TODO: add set insert and set remove functions
	if (fname == "addNotChild") {
		REMOTE_CODE_MODULE(id,DcPlanner)->notChildOf.insert(arg);
	}
	else if (fname == "removeNotChild") {
		REMOTE_CODE_MODULE(id,DcPlanner)->notChildOf.erase(arg);
	}
	else if (fname == "clearNotChild") {
		REMOTE_CODE_MODULE(id,DcPlanner)->notChildOf.clear();
	}
	else if (fname == "addLock") {
		REMOTE_CODE_MODULE(id,DcPlanner)->locks.insert(arg);
	}
	else if (fname == "removeLock") {
		REMOTE_CODE_MODULE(id,DcPlanner)->locks.erase(arg);
	}
	else if (fname == "create") {
		if (catom->C.getNeighbor((int)arg)) {  // fixed -- Babu; using featureId
			catomID cid = catom->C.getNeighbor((int)arg);
			CatomSim *target = worldPtr->catomHash[cid];
			target->red = 128;
			target->green = 128;
			target->blue = 128;
			target->alpha = ON_ALPHA;
			REMOTE_CODE_MODULE(cid,DcPlanner)->exists = true;
			REMOTE_CODE_MODULE(cid,DcPlanner)->state = 3;
			REMOTE_CODE_MODULE(cid,DcPlanner)->hasRsc = false;
			REMOTE_CODE_MODULE(id,DcPlanner)->hasRsc = false;
			if (DcPlanner::use_meta) {
				worldPtr->catomHash[id]->HACK_metamodule = 1;
				worldPtr->catomHash[cid]->HACK_metamodule = 1;
			}
			REMOTE_CODE_MODULE(cid,DcPlanner)->depth = 0;
			REMOTE_CODE_MODULE(cid,DcPlanner)->createCount++;
		}
	}
	else if (fname == "destroy") {
		catom->alpha = 255;
		REMOTE_CODE_MODULE(id,DcPlanner)->createCount++;
		REMOTE_CODE_MODULE(id,DcPlanner)->exists = false;
	}
	else if (fname == "destroyTowards") {
		for (unsigned k = 1; k <= NUM_FEATURES; k++) {
			catomID kthNeighbor = catom->C.getNeighbor(k);
			if (kthNeighbor && REMOTE_CODE_MODULE(kthNeighbor,DcPlanner)->exists && (kthNeighbor == arg) &&
						 (REMOTE_CODE_MODULE(kthNeighbor,DcPlanner)->hasRsc == false) &&
						 (REMOTE_CODE_MODULE(id,DcPlanner)->hasRsc == false)) {
				
				//check to ensure that no neighbors are children
				for (unsigned j = 1; j <= NUM_FEATURES; j++) {
					catomID jthNeighbor = catom->C.getNeighbor(j);
					if (jthNeighbor &&  REMOTE_CODE_MODULE(jthNeighbor,DcPlanner)->exists &&
						(REMOTE_CODE_MODULE(jthNeighbor,DcPlanner)->parent == id)) {
						//cout << "ha!" << endl;
						return;
					}
				}
				
				worldPtr->catomHash[id]->alpha = 255;
				REMOTE_CODE_MODULE(id,DcPlanner)->exists = false;
				REMOTE_CODE_MODULE(id,DcPlanner)->parent = -1;
				REMOTE_CODE_MODULE(kthNeighbor,DcPlanner)->hasRsc = true;
				REMOTE_CODE_MODULE(id,DcPlanner)->createCount++;
				
				//remove lock at id's neighbors
				for (unsigned j = 1; j <= NUM_FEATURES; j++) {
					catomID jthNeighbor = catom->C.getNeighbor(j);
					if (jthNeighbor) {
						REMOTE_CODE_MODULE(jthNeighbor,DcPlanner)->locks.erase(id);
					}
				}
				
				return;
			}
		}
		//catom->red = 0;
		//catom->green = 0;
		//catom->blue = 0;
		catom->alpha = 255;
		REMOTE_CODE_MODULE(id,DcPlanner)->exists = false;
	}
	else if (fname == "destroyOther") {
		for (unsigned k = 1; k <= NUM_FEATURES; k++) {
			catomID kthNeighbor = catom->C.getNeighbor(k);
			if (kthNeighbor && REMOTE_CODE_MODULE(kthNeighbor,DcPlanner)->exists && (kthNeighbor == arg) &&
				(REMOTE_CODE_MODULE(kthNeighbor,DcPlanner)->hasRsc == false) &&
				(REMOTE_CODE_MODULE(id,DcPlanner)->hasRsc == false)) {
				//worldPtr->catomHash[kthNeighbor]->red = 0;
				//worldPtr->catomHash[kthNeighbor]->green = 0;
				//worldPtr->catomHash[kthNeighbor]->blue = 0;
				worldPtr->catomHash[kthNeighbor]->alpha = 255;
				REMOTE_CODE_MODULE(kthNeighbor,DcPlanner)->exists = false;
				REMOTE_CODE_MODULE(kthNeighbor,DcPlanner)->parent = -1;
				REMOTE_CODE_MODULE(kthNeighbor,DcPlanner)->createCount++;
//				REMOTE_CODE_MODULE(kthNeighbor,DcPlanner)->delayed_delete=true;
				REMOTE_CODE_MODULE(id,DcPlanner)->hasRsc = true;
				
				return;
			}
		}
	}
	else if (fname == "takeRsc") {
		for (unsigned k = 1; k <= NUM_FEATURES; k++) {
			catomID kthNeighbor = catom->C.getNeighbor(k);
			if (kthNeighbor && REMOTE_CODE_MODULE(kthNeighbor,DcPlanner)->exists && (kthNeighbor == arg) &&
				 (REMOTE_CODE_MODULE(kthNeighbor,DcPlanner)->hasRsc == true) &&
				 (REMOTE_CODE_MODULE(id,DcPlanner)->hasRsc == false)) {
				REMOTE_CODE_MODULE(kthNeighbor,DcPlanner)->hasRsc = false;
				if (DcPlanner::use_meta) worldPtr->catomHash[kthNeighbor]->HACK_metamodule = 1;
				REMOTE_CODE_MODULE(id,DcPlanner)->hasRsc = true;
				if (DcPlanner::use_meta) worldPtr->catomHash[id]->HACK_metamodule = 2;
				REMOTE_CODE_MODULE(id,DcPlanner)->moveCount++;
				return;
			}
		}
	}
	else  CatomWrapper::callFcn(fname,arg);
}
