#ifndef __DC_Aggregate_H
#define __DC_Aggregate_H

#include "DCondition.hxx"

CODE_MODULE_PROTOTYPE( DcAggregate, DcAggregate );
using namespace std;

class AggregateWrapper: public CatomWrapper {
	public:
	AggregateWrapper(CatomSim* c) :CatomWrapper(c) {}
	virtual set<ModuleWrapper *> neighbors();
	virtual VarCode codeForVarname(string varname);
	virtual float getRealVar(VarCode var);
	virtual void setRealVar(VarCode var, float val);
	virtual set<float> getSetVar(VarCode var);
	virtual void callFcn(string fname, float arg);
	int seed; //random seed for link cutting
};


class DcAggregate : public DistributedCondition {
public:
	DcAggregate(catomID _hostCatom):DistributedCondition(_hostCatom)  {}
	virtual ModuleWrapper *localModule() { return new AggregateWrapper(HOSTCATOMSIM); }
	void simulationStart();
	void newTick();
	void endTick();
	float sensor;
	float sum;
	float count;
	float average;
	float parent;
	float isSeed;
	float subtreeSize;
	float isLeaf;
	set<float> children;
	set<float> notChildren;
};

#endif
