#include <algorithm>
#include <iostream>
#include <errno.h>
#include <string.h>
#include <stdlib.h>

#include "DcAggregate.hxx"

CODE_MODULE_DECLARATION( DcAggregate, DcAggregate );

using namespace std;

#define ON_ALPHA 80

bool isValidLink(catomID idA, catomID idB, int seed) {
	catomID maxId = (idA > idB) ? idA : idB;
	catomID minId = (idA > idB) ? idB : idA;
	//predicatable hash that works bidirectionally
	//return ((seed + (maxId*10000) + minId) * 2654435761) % 2 == 1;
	return true;
}

void DcAggregate::simulationStart() {
	DistributedCondition::simulationStart();
	string seed_str = worldPtr->search_key_value_list("SEED");
	if (seed_str != "") { //seed hash function for link cutting
		((AggregateWrapper*)condManager->localModule)->seed = atoi(seed_str.c_str());
	}
	
	seed_str = worldPtr->search_key_value_list("TREE_SEED");
	if (seed_str != "") {
		isSeed = (hostCatom == (unsigned int) atoi(seed_str.c_str())) ? 1 : 0;
	}
	
	sensor = sum = count = average = subtreeSize = isLeaf = 0;
	parent = -1;
	
	HOSTCATOMSIM->alpha = ON_ALPHA;
}


void DcAggregate::endTick() {
	condManager->tick();
}

void DcAggregate::newTick() {
	worldPtr->clearLines(hostCatom);
	if (isSeed) {
		long msgCount = 0;
		map<catomID,ModuleWrapper* >::iterator currWrapper;
		for (currWrapper = catomWrappers.begin(); currWrapper != catomWrappers.end(); currWrapper++) {
			msgCount += ((CatomWrapper*)(*currWrapper).second)->sendCount;
		}
		//cout << "on step " << worldPtr->current_time+1 << " with " << msgCount << " messages, " << count << " count"<< endl;
	}
}

//----wrapper support functions----------------

set<ModuleWrapper *> AggregateWrapper::neighbors() {
	set<ModuleWrapper*> n;
	for (unsigned k = 0; k < NUM_FEATURES; k++) {
		catomID kthNeighbor = catom->C.getNthNeighbor(k);
		if (kthNeighbor && isValidLink(id,kthNeighbor,seed)) { //only supply neighbors that have a valid link
			n.insert((ModuleWrapper*)catomWrappers[kthNeighbor]);
		}
	}
	return n;
}

enum {
	kNumNeighbors = 1025,
 	kSensor,kIsSeed,kSum,kCount,kAverage,kParent,kIsLeaf,kSubTreeSize,
  	kChildren, kNotChildren, kNeighbors
};

VarCode AggregateWrapper::codeForVarname(string varname) {
	if (varname == "numNeighbors") {
		return kNumNeighbors;
	}
	else if (varname == "sensor") {
		return kSensor;
	}
	else if (varname == "isSeed") {
		return kIsSeed;
	}
	else if (varname == "sum") {
		return kSum;
	}
	else if (varname == "count") {
		return kCount;
	}
	else if (varname == "average") {
		return kAverage;
	}
	else if (varname == "parent") {
		return kParent;
	}
	else if (varname == "isLeaf") {
		return kIsLeaf;
	}
	else if (varname == "subtreeSize") {
		return kSubTreeSize;
	}
	else if (varname == "$children") {
		return kChildren;
	}
	else if (varname == "$notChildren") {
		return kNotChildren;
	}
	else if (varname == "$neighbors") {
		return kNeighbors;
	}
	else return CatomWrapper::codeForVarname(varname);
}

float AggregateWrapper::getRealVar(VarCode var) {
	switch (var) {
		case kNumNeighbors:
			return this->neighbors().size();
			break;
		case kSensor:
			return REMOTE_CODE_MODULE(id,DcAggregate)->sensor;
			break;
		case kIsSeed:
			return REMOTE_CODE_MODULE(id,DcAggregate)->isSeed;
			break;
		case kSum:
			return REMOTE_CODE_MODULE(id,DcAggregate)->sum;
			break;
		case kCount:
			return REMOTE_CODE_MODULE(id,DcAggregate)->count;
			break;
		case kAverage:
			return REMOTE_CODE_MODULE(id,DcAggregate)->average;
			break;
		case kParent:
			return REMOTE_CODE_MODULE(id,DcAggregate)->parent;
			break;
		case kIsLeaf:
			return REMOTE_CODE_MODULE(id,DcAggregate)->isLeaf;
			break;
		case kSubTreeSize:
			return REMOTE_CODE_MODULE(id,DcAggregate)->subtreeSize;
			break;
		default:
			return CatomWrapper::getRealVar(var);
	}
	return 0.0;
}

void AggregateWrapper::setRealVar(VarCode var, float val) {
	switch (var) {
		case kSensor:
			REMOTE_CODE_MODULE(id,DcAggregate)->sensor = val;
			break;
		case kSum:
			REMOTE_CODE_MODULE(id,DcAggregate)->sum = val;
			break;
		case kCount:
			REMOTE_CODE_MODULE(id,DcAggregate)->count = val;
			break;
		case kAverage:
			REMOTE_CODE_MODULE(id,DcAggregate)->average = val;
			break;
		case kParent:
			REMOTE_CODE_MODULE(id,DcAggregate)->parent = val;
			break;
		case kIsLeaf:
			if (REMOTE_CODE_MODULE(id,DcAggregate)->isLeaf != val)
				cout << "catom " << id << " became leaf with count " << REMOTE_CODE_MODULE(id,DcAggregate)->count << endl;
			REMOTE_CODE_MODULE(id,DcAggregate)->isLeaf = val;
			break;
		case kSubTreeSize:
			REMOTE_CODE_MODULE(id,DcAggregate)->subtreeSize = val;
			break;
		default:
			CatomWrapper::setRealVar(var,val);
	}
}

set<float> AggregateWrapper::getSetVar(VarCode var) {
	switch (var) {
		case kChildren:
			return REMOTE_CODE_MODULE(id,DcAggregate)->children;
			break;
		case kNotChildren:
			return REMOTE_CODE_MODULE(id,DcAggregate)->notChildren;
			break;
		case kNeighbors:
		{ //all visible neighbors
			set<float> nIds;
			set<ModuleWrapper *> nWraps = this->neighbors();
			for (set<ModuleWrapper*>::iterator i = nWraps.begin(); i!= nWraps.end(); i++) {
				nIds.insert((*i)->id);
			}
			return nIds;
		}
		default:
			return CatomWrapper::getSetVar(var);
	}
}

void AggregateWrapper::callFcn(string fname, float arg) {
	if (fname == "addNotChild") {
		REMOTE_CODE_MODULE(id,DcAggregate)->notChildren.insert(arg);
	}
	else if (fname == "removeNotChild") {
		REMOTE_CODE_MODULE(id,DcAggregate)->notChildren.erase(arg);
	}
	else if (fname == "addChild") {
		REMOTE_CODE_MODULE(id,DcAggregate)->children.insert(arg);
		//cout << id << " has " << REMOTE_CODE_MODULE(id,DcAggregate)->children.size() << " children and ";
		//cout << REMOTE_CODE_MODULE(id,DcAggregate)->notChildren.size() << " not-children" << endl;
	}
	else if (fname == "removeChild") {
		REMOTE_CODE_MODULE(id,DcAggregate)->children.erase(arg);
	}
	else CatomWrapper::callFcn(fname,arg);
}
