///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Coproration and Carnegie Mellon University    //
// Contacts: casey.j.helfrich @ intel.com                                    //
//           bdr @ cs.cmu.edu                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef __DPRHIERARCHY_H
#define __DPRHIERARCHY_H

#include "Hierarchy.hxx"

class DPRHierarchy;

class LandmarkMsg : public Message {
public:
  LandmarkMsg(DPRHierarchy* _hierarchy, catomID dest, Message* _payload, unsigned _distTraveled=0);
  LandmarkMsg(MailboxID _mailboxID, catomID dest, Message* _payload, unsigned _distTraveled=0);
  LandmarkMsg(DPRHierarchy* _hierarchy, unsigned long long _msgID, catomID dest, Message* _payload, unsigned _distTraveled=0);
  LandmarkMsg(MailboxID _mailboxID, unsigned long long _msgID, catomID dest, Message* _payload, unsigned _distTraveled=0);
  ~LandmarkMsg();
  
  catomID destination;
  Message* payload;
  unsigned distanceTraveled;

  virtual Message* clone() {
    LandmarkMsg* c = new LandmarkMsg(mailboxID, messageID, destination, (Message*)payload->clone(), distanceTraveled);
    c->messageID = this->messageID;
    return c;
  }
  virtual unsigned long long headerSize();
  virtual unsigned long long payloadSize();
};

class RequestPromotionMsg : public Message {
public:
  RequestPromotionMsg(DPRHierarchy* _hchy);
  RequestPromotionMsg(MailboxID _mbox);

  virtual Message* clone() {
    RequestPromotionMsg* c = new RequestPromotionMsg(mailboxID);
    c->messageID = this->messageID;
    return c;
  }
};

class LandmarkBeacon : public Message {
public:
  LandmarkBeacon(DPRHierarchy* _hierarchy, catomID _id, long int _beaconID, unsigned int _visDistance, unsigned int _distanceSoFar, int _level, catomID _parent);
  LandmarkBeacon(MailboxID _mailboxID, catomID _id, long int _beaconID, unsigned int _visDistance, unsigned int _distanceSoFar, int _level, catomID _parent);

  catomID id;
  long int beaconVersionID;
  unsigned int visDistance;
  unsigned int distanceSoFar;
  int level;
  catomID parent;

  virtual Message* clone() {
    LandmarkBeacon* c = new LandmarkBeacon(mailboxID, id, beaconVersionID, visDistance, distanceSoFar, level, parent);
    c->messageID = this->messageID;
    return c;
  }
  virtual unsigned long long headerSize()  { return 0; }
  virtual unsigned long long payloadSize() { return sizeof(id) + sizeof(beaconVersionID) + sizeof(visDistance) + sizeof(distanceSoFar) + sizeof(level) + sizeof(parent); }
};

class BeaconRequestBeacon : public Message {
public:
  BeaconRequestBeacon(MailboxID _mailboxID, simtime _requestTime, unsigned _ttl, unsigned _distSoFar=0);

  simtime requestTime;
  unsigned ttl;
  unsigned distSoFar;

  virtual Message* clone() {
    BeaconRequestBeacon* c = new BeaconRequestBeacon(mailboxID, requestTime, ttl, distSoFar);
    c->messageID = this->messageID;
    return c;
  }
};

class DPRHierarchy : public Hierarchy {
  friend class LandmarkMsg;
  friend class LandmarkBeacon;
  friend class RequestPromotionMsg;

public:
  DPRHierarchy(catomID _hostCatom, string _hierarchyName);
  virtual ~DPRHierarchy();

protected:
  virtual void simulationStart();
  virtual void dumpStats();
  virtual void endTick();

  virtual bool sendMsgToParent(Message* msg);

  string hierarchyMessageBox;
  string landmarkBeaconBox;
  string routeLandmarkMsgBox;
  string reqPromotionBox;
  string beaconRequestBox;

  unsigned long numHopsToParent;
  int parentLevel;

  map<catomID, featureID> routingTable;
  map<catomID, long> beaconIDs;
  map<catomID, unsigned long> beaconHopcounts;
  unsigned int visibilityDistance;
  long int lastAnnouncementTime;
  long unsigned int nextBeaconVersionID;
  set<catomID> peers;

  set<unsigned long long> msgsForwardedBySpeculation;

  featureID calcRoutingDest(catomID landmarkAddr);
  bool hierarchyMessageIntentHandler(Message* _msg);
  bool hierarchyMessageHeaderHandler(Message* _msg);
  bool hierarchyMessagePayloadHandler(Message* _msg);
  bool landmarkBeaconHandler(Message* _msg);
  bool reqPromotionHandler(Message* _msg);
  bool beaconRequestHandler(BeaconRequestBeacon* msg);

  bool routeLandmarkMsg(Message* _msg);
  bool updateLandmarkRoutingTables(catomID _landmarkID, featureID _contact, long _msgID, unsigned long _hopcount);
  virtual void landmarkAnnounce();
  virtual void promoteSelf();
};

#endif
