#ifndef __DPRHIERARCHY_HOTBACKUPS_H
#define __DPRHIERARCHY_HOTBACKUPS_H

#include "DPRHierarchy.hxx"
#include "Network.hxx"

CODE_MODULE_PROTOTYPE( DPRHierarchyHotBackups, DPRHierarchyHotBackups, "DPRHierarchyHotBackups" );

extern simtime pref_keepaliveInterval;
extern string hotBackupKeepaliveMailbox;

class HotBackupRequest : public Message {
public:
  HotBackupRequest(catomID _primaryCatom);

  catomID primaryCatom;

  virtual Message* clone() {
    HotBackupRequest* c = new HotBackupRequest(primaryCatom);
    c->messageID = this->messageID;
    return c;
  }
};

class HotBackupRandomWalkRequest : public Message {
public:
  HotBackupRandomWalkRequest(catomID _primCatom, unsigned _ttl, unsigned _trav = 0);

  catomID primaryCatom;
  unsigned ttl;
  unsigned distTraveled;

  virtual Message* clone() {
    HotBackupRandomWalkRequest* c = new HotBackupRandomWalkRequest(primaryCatom, ttl, distTraveled);
    c->messageID = this->messageID;
    return c;
  }
};

class HotBackupResponse : public Message {
public:
  HotBackupResponse(catomID _backupCatom);

  catomID backupCatom;
  
  virtual Message* clone() {
    HotBackupResponse* c =  new HotBackupResponse(backupCatom);
    c->messageID = this->messageID;
    return c;
  }
};

class HotBackupMyHBAnnouncement : public Message {
public:
  HotBackupMyHBAnnouncement(catomID _me, catomID _hb, unsigned _ttl, unsigned _trav = 0);

  catomID original;
  catomID hb;
  unsigned ttl;
  unsigned distTraveled;

  virtual Message* clone() {
    HotBackupMyHBAnnouncement* c = new HotBackupMyHBAnnouncement(original,hb,ttl,distTraveled);
    c->messageID = this->messageID;
    return c;
  }
};

class HotBackupUpdate : public Message {
public:
  HotBackupUpdate(catomID _childID, ChildData* _childData);

  catomID childID;
  ChildData* childData;

  virtual Message* clone() {
    HotBackupUpdate* c = new HotBackupUpdate(childID, childData);
    c->messageID = this->messageID;
    return c;
  }
};

class HotBackupKeepalive : public Message {
public:
  HotBackupKeepalive(unsigned _visDistance);

  unsigned visDistance;

  virtual Message* clone() {
    HotBackupKeepalive* c = new HotBackupKeepalive(visDistance);
    c->messageID = this->messageID;
    return c;
  }
};

class HotBackupFailoverBeacon : public Message {
public:
  HotBackupFailoverBeacon(catomID _oldCatom, catomID _newCatom);

  catomID oldCatom;
  catomID newCatom;

  map <catomID, simtime> lastHeardDataTimestamps;

  virtual Message* clone() {
    HotBackupFailoverBeacon* c = new HotBackupFailoverBeacon(oldCatom, newCatom);
    c->messageID = this->messageID;
    return c;
  }
};

class DPRHierarchyHotBackups : public DPRHierarchy {
public:
  DPRHierarchyHotBackups(catomID _hostCatom, string _hierarchyName);

protected:
  virtual void endTick();
  virtual void simulationStart();

  virtual void promoteSelf();
  void askForHotBackup();

  virtual void setChildData(catomID, ChildData*);

  bool requestHandler(HotBackupRequest* msg);
  bool randomWalkRequestHandler(HotBackupRandomWalkRequest* msg);
  bool responseHandler(HotBackupResponse* _msg);
  bool updateHandler(HotBackupUpdate* _msg);
  bool keepaliveHandler(HotBackupKeepalive* _msg);
  virtual bool failoverBeaconHandler(HotBackupFailoverBeacon* msg);
  bool hbAnnouncementHandler(HotBackupMyHBAnnouncement* msg);
  void takeOverFromMainCatom();

  virtual bool sendMsgToParent(Message*);

  catomID claimedAsHotBackup;
  catomID hotBackupCatom;
  int hotBackupRequestTTL;
  bool hasFailed;

  map <catomID, catomID> knownHotBackups;

  simtime failoverStart;
  bool isConsistent;
 
  simtime lastKeepaliveSendTime;
  simtime lastKeepaliveHeardTime;

  virtual void landmarkAnnounce();
};

#endif
