///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Corporation and Carnegie Mellon University    //
// Contacts: raam @ cmu.edu                                                  //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef DCONSENSUS_HXX
#define DCONSENSUS_HXX


#include "CodeModule.hxx"
#include "Network.hxx"
#include "LockInfo.hxx"
#include "MessageStructure.hxx"
//#include "STree.hxx"
#include "SoftwareTimer.hxx"
#include "CatomSim.hxx"

#include <list>

class Catom;
class Message;
class LockInfo;
class STMessage;


using namespace std;

CODE_MODULE_PROTOTYPE( DConsensus, DConsensus );


class DConsensus : public CodeModule {
  public:
	
    map<long int,double> stateMap;
    map<long int,double> initialStates;
    map<long int,map<featureID,double> > delta;
    map<long int,map<featureID,double> > neighborEstimates;
    map<featureID,bool> waitForReply;
    map<featureID,catomID> neighbor;
    long index;
    static pthread_mutex_t objectMutex; 
    Catom *me;
    
    // store pointer to current CM and targetCM
    Point3D currEstimateCM;
    Point3D targetCM;
    double updateTime;
    double deltaUpdateTime;
    catomID largestUID;
  TimerID nextDeltaUpdate;
  TimerID nextInfoUpdate;
    
    double phi;
    double gamma;

  public:
	
	
    DConsensus(catomID cid) : CodeModule(cid)
    { 
      updateTime = 1;
      deltaUpdateTime = 10;
      index = 0;
      phi = 0.2; // < 0.5
      gamma = 1/(NUM_FEATURES+3+0.2); // < 1/(d+1)
    }
    void simulationStart();
    bool messageHandler(ConsensusMessage* msg);
    void _updateDelta();
    void _updateState();
    void _updateInfo();
    static void updateDelta(void *ptrToObj);
    static void updateInfo(void *ptrToObj);
    
    static void updateState(void *ptrToObj);
    long getIndex(){return index;}
    long addState(double value) {initialStates[index]=value;stateMap[index++]=value; return index-1;}
  void updateState(long key,double value);

    double getState(long key){return stateMap[key];}
    void removeState(long key)
    {
      stateMap.erase(key);
      delta.erase(key);
      cerr<<"Key "<<key<<" may get recreated due to persistent information through incoming messages"<<endl;
    }
    long getEnsembleSize(){ return (long)round(1.0/stateMap[-1]);}
    
	
  protected:
    
    void _lock();
    void _unlock();
    void _sendHandler(ConsensusMessage* msg);
    void _reqHandler(ConsensusMessage* msg);
    void _ackHandler(ConsensusMessage* msg);
    void _handleCardinality(ConsensusMessage* msg);
    
    
    virtual void newTick();	
    virtual void endTick();
    virtual void oracle();
};




#endif //DCONSENSUS_HXX
