///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Corporation and Carnegie Mellon University    //
// Contacts: raam @ cmu.edu                                                  //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////
 
#include <iostream>
 
#include "DConsensus.hxx"

CODE_MODULE_DECLARATION( DConsensus, DConsensus );


#include "Catom.hxx"
#include "CatomWorld.hxx"
#include "Network.hxx"

typedef map<long int,map<featureID,double> >::iterator DeltaIterator;

using namespace std;

pthread_mutex_t DConsensus::objectMutex = PTHREAD_MUTEX_INITIALIZER;

void DConsensus::oracle()
{
  while(1)
  {
    oracleYield();
    oracleYield();
  }
}

void DConsensus::simulationStart()
{ 

//	stree = STree(hostCatom,lockList);
	me = &HOSTCATOM;


	//stree.initializeTree(this);

  worldPtr->catomHash[hostCatom]->C.mailboxManager.registerHandler("ConsensusmessageHandler",this, 
	    (msgHandlerPtr)&DConsensus::messageHandler); 

  nextInfoUpdate = CODE_MODULE(SoftwareTimer)->registerTimer(10,&DConsensus::updateInfo,this,0);
  nextDeltaUpdate = CODE_MODULE(SoftwareTimer)->registerTimer(20,&DConsensus::updateDelta,this,0);
  CODE_MODULE(SoftwareTimer)->registerTimer(30,&DConsensus::updateState,this,1);
	
	bool biggest = true;
	for(uint i=1;i<=NUM_FEATURES;i++)
	  if(me->getNeighbor(i)>me->getID())
	   {
	     biggest = false;
	     if(largestUID < me->getNeighbor(i)) 
	     {
	       largestUID = me->getNeighbor(i);
	     }
	   }
	if(biggest) 
	{
	  updateState(-1,1);
	}
	else
	{
	  updateState(-1,0);
	}

}

void DConsensus::updateState(void *ptrToObj)
{
 // cerr<<"We are in Info"<<endl;
  ((DConsensus*)ptrToObj)->_updateState();
}

void DConsensus::updateState(long key,double value)
{
  initialStates[key] = value;
  if(stateMap.find(key)==stateMap.end())
    stateMap[key]=value;
  for(uint i=1;i<=NUM_FEATURES;i++)
     if(me->getNeighbor(i)!=neighbor[i])
       ;//delta[key][i] = 0;
}
// void DConsensus::updateState(long key,double value) 
// {
//   double temp = value - stateMap[key];
//       //stateMap[key]+=value-initialStates[key];
//   stateMap[key]=value;
//   initialStates[key]+=temp;
//   if(delta.find(key)==delta.end())
//   {
//     for(uint i=1;i<=NUM_FEATURES;i++)
//       delta[key][i] = 0;
//   }
//   else
//   {
//     for(uint i=1;i<=NUM_FEATURES;i++)
//       if(me->getNeighbor(i)!=neighbor[i])
//       {
//         for(map<long,double>::iterator it = stateMap.begin(); it!=stateMap.end();it++)
//         {
//           stateMap[it->first]-=delta[it->first][i];
//           delta[it->first][i] = 0;
//           neighbor[i]=me->getNeighbor(i);
//           waitForReply[i] = false;
//         }
//       }
//     CODE_MODULE(SoftwareTimer)->deleteTimer(nextDeltaUpdate);
//     CODE_MODULE(SoftwareTimer)->deleteTimer(nextInfoUpdate);
//     nextInfoUpdate = CODE_MODULE(SoftwareTimer)->registerTimer(10,&DConsensus::updateInfo,this,0);
//     nextDeltaUpdate = CODE_MODULE(SoftwareTimer)->registerTimer(20,&DConsensus::updateDelta,this,0);
// 
//   }
// }
void DConsensus::_updateState()
{
  for(map<long,double>::iterator it = stateMap.begin(); it!=stateMap.end();it++)
  {
    double sum = 0;
    for(uint i=1;i<=NUM_FEATURES;i++)
      sum+=delta[it->first][i]; 
    stateMap[it->first] = stateMap[it->first] + gamma*(sum + initialStates[it->first] - stateMap[it->first]);
  }
}

void DConsensus::updateInfo(void *ptrToObj)
{
 // cerr<<"We are in Info"<<endl;
  ((DConsensus*)ptrToObj)->_updateInfo();
}

void DConsensus::updateDelta(void *ptrToObj)
{
 // cerr<<"we are in delta"<<endl;
  ((DConsensus*)ptrToObj)->_updateDelta();
}

void DConsensus::_updateDelta()
{
  vector<featureID> vecF;
  for(uint i=NUM_FEATURES;i>0;i--)
  {
    if(neighbor[i]!=me->getNeighbor(i))
    {
//       if(neighbor[i]!=0)
//         if(me->getNeighbor(i)==0)
        {
          for(DeltaIterator it = delta.begin();it!=delta.end();it++)
          {
          stateMap[it->first] = stateMap[it->first] - delta[it->first][i];
          delta[it->first][i] = 0; 
          }
        }
      waitForReply[i]=false;
      neighbor[i]=me->getNeighbor(i);
      continue;
    }
    
    if(me->getNeighbor(i)<me->getID()) 
      continue;
    vecF.push_back(i);
    if(waitForReply[i] && neighbor[i]==me->getNeighbor(i)) // neighbor is not new and we are awaiting his reply
      continue;
    
    map<long,double> sendMap;

    for(DeltaIterator it = delta.begin();it!=delta.end();it++)
    {
      sendMap[it->first] = phi*(neighborEstimates[it->first][i] - stateMap[it->first]);
      (it->second)[i] += sendMap[it->first];
    }
    
    ConsensusMessage* sendmess = new ConsensusMessage("ConsensusmessageHandler",hostCatom,
	MSG_SHAPE_CM_DELTA_REQ,sendMap,largestUID);
    if(!me->getFeatureMap()[i].getNetworkAdapter()->sendMessage(sendmess))
      ;//delete sendmess; 
    else
      waitForReply[i] = true;
  }

  nextDeltaUpdate = CODE_MODULE(SoftwareTimer)->registerTimer(worldPtr->current_time+deltaUpdateTime,&DConsensus::updateDelta,this);
// cerr<<worldPtr->current_time+updateTime<<endl;
}

void DConsensus::endTick()
{
  
  //softTimer->tick();
  
  
// if(worldPtr->current_time==2) 
// {
//   updateState(12,me->getLocation().getX());
// }
//   
// 
//  
//  if(worldPtr->current_time%10==1 /*&& hostCatom==10000*/)
//     cerr<<hostCatom<<" : "<<getState(12)<<endl;

}

void DConsensus::_updateInfo()
{
  vector<featureID> vecF;
  for(uint i=NUM_FEATURES;i>0;i--)
  {
    if(me->getNeighbor(i)==0)
      continue;
    vecF.push_back(i);

    ConsensusMessage* sendmess = new ConsensusMessage("ConsensusmessageHandler",hostCatom,
	MSG_SHAPE_CM_REQ,stateMap,largestUID);
    if(!me->getFeatureMap()[i].getNetworkAdapter()->sendMessage(sendmess))
      ;//delete sendmess; 
  }

  nextInfoUpdate = CODE_MODULE(SoftwareTimer)->registerTimer(worldPtr->current_time+updateTime,&DConsensus::updateInfo,this);
}


void DConsensus::_lock()
{
    
  int err = pthread_mutex_lock(&objectMutex);
  if(err) {
    worldPtr->oStart();
    cerr << "can't lock mutex5 : " << strerror(errno) << endl;
    worldPtr->oEnd();
    exit(1);
  }
}

void DConsensus::_unlock()
{
  int err = pthread_mutex_unlock(&objectMutex);
  if(err) {
    cerr << "can't unlock mutex : " << strerror(errno) << endl;
    exit(1);
  }
}

void DConsensus::_reqHandler(ConsensusMessage* msg)
{

  for(map<long,double>::iterator it = msg->stateInfo.begin(); it!=msg->stateInfo.end();it++)
  {
    worldPtr->oStart();
//     cerr<<"hostCatom: "<<hostCatom<<endl;
//     cerr<<"it->first: "<<it->first<<endl;
//     cerr<<"nbr init estimate: "<<neighborEstimates[it->first][msg->arrivalContact]<<endl;
    neighborEstimates[it->first][msg->arrivalContact] = it->second;
//     cerr<<"nbr final estimate: "<<neighborEstimates[it->first][msg->arrivalContact]<<endl;
    worldPtr->oEnd();
  }

  delete msg;
}


void DConsensus::_ackHandler(ConsensusMessage* msg)
{
  waitForReply[msg->arrivalContact]=false;
  delete msg;
}



void DConsensus::_sendHandler(ConsensusMessage* msg)
{ 
  bool changeNeighbor = false;
  for(map<long,double>::iterator it = msg->stateInfo.begin(); it!=msg->stateInfo.end();it++)
  {
    if(neighbor[msg->arrivalContact]!=me->getNeighbor(msg->arrivalContact)) // if neighbor changes
    {
      stateMap[it->first] = stateMap[it->first] - delta[it->first][msg->arrivalContact];
      delta[it->first][msg->arrivalContact] = 0; 
      // change neighborEstimates[it->first][msg->arrivalContact]
      changeNeighbor = true;
    }
    delta[it->first][msg->arrivalContact] = 
	delta[it->first][msg->arrivalContact] - it->second;
  }
  if(changeNeighbor)
    neighbor[msg->arrivalContact] = me->getNeighbor(msg->arrivalContact);
  
  ConsensusMessage* sendmess = new ConsensusMessage("ConsensusmessageHandler",hostCatom,
      MSG_SHAPE_CM_DELTA_ACK);
  if(!me->getFeatureMap()[msg->arrivalContact].getNetworkAdapter()->sendMessage(sendmess))
    ;//delete sendmess;

  delete msg; 
}

void DConsensus::_handleCardinality(ConsensusMessage* msg)
{
  
  if(largestUID < msg->largestUID)
  {
    largestUID = msg->largestUID;
    if(initialStates[-1] == 1)
    {
      initialStates[-1] = 0;
      stateMap[-1]--;
    
    }
  }
}
bool DConsensus::messageHandler(ConsensusMessage* msg)
{
  _handleCardinality(msg);
  
  switch(msg->mtype)
  {
    case MSG_SHAPE_CM_REQ:
    {
      _reqHandler(msg);
      break;
    }
    case MSG_SHAPE_CM_DELTA_REQ:
    {
      _sendHandler(msg);
      break;
    }
    case MSG_SHAPE_CM_DELTA_ACK:
    {
      _ackHandler(msg);
      break;
    }    
    
    
    default:
      delete msg;
  }
  
  return true;
}


void DConsensus::newTick()
{
}
