#ifndef __DISTRIBUTEDCONDITION_H
#define __DISTRIBUTEDCONDITION_H

#include "CodeModule.hxx"
#include "CatomWorld.hxx"
#include "CatomSim.hxx"
#include "DCondParse.hxx"
#include "DCondManager.hxx"
#include <map>
#include <deque>
#include <pthread.h>
#include "Network.hxx"

CODE_MODULE_PROTOTYPE( DistributedCondition, DistributedCondition );
using namespace std;

class CatomWrapper: public ModuleWrapper {
	public:
	CatomSim *catom;
	long sendCount;
	CatomWrapper(CatomSim* c) : catom(c) {id = c->C.getID(); sendCount = 0;}
	virtual set<ModuleWrapper *> neighbors();
	virtual void send(DCMessage* msg, ModuleWrapper *dest);
	virtual VarCode codeForVarname(string varname);
	virtual float getRealVar(VarCode var);
	virtual void setRealVar(VarCode var, float val);
	virtual set<float> getSetVar(VarCode var) {return ModuleWrapper::getSetVar(var);}
	virtual void setSetVar(VarCode var, set<float> val) {ModuleWrapper::setSetVar(var,val);}
	virtual void callFcn(string fname, float arg);
};

extern CatomWorld *worldPtr;
//TODO: make these static members instead
extern MailboxID conditionMessagingBox;
extern map<catomID,ModuleWrapper* > catomWrappers;
extern vector<DCondition*> initialMasters;
extern pthread_mutex_t dc_init_loc;

class ConditionMessage : public Message {
	public:
	DCMessage *payload;
	catomID srcID;
	ConditionMessage(MailboxID mailboxName, DCMessage *dataValue, catomID s) : Message(mailboxName), payload(dataValue), srcID(s) { }
	virtual Message* clone() { return new ConditionMessage(mailboxID, payload,srcID); }
};

class DistributedCondition : public CodeModule {
	public:
	DCondManager *condManager;
	DistributedCondition(catomID _hostCatom):CodeModule(_hostCatom)  {}
	virtual ModuleWrapper *localModule() { return new CatomWrapper(HOSTCATOMSIM); }
	virtual void simulationStart();
	virtual void endTick();	
	bool conditionMsgHandler(ConditionMessage* msg);
};

#endif
