#include <algorithm>
#include <iostream>
#include <errno.h>
#include <string.h>
#include <stdlib.h>

#include "DCondition.hxx"

CODE_MODULE_DECLARATION( DistributedCondition, DistributedCondition );

using namespace std;

MailboxID conditionMessagingBox = "conditionMessagingBox";
map<catomID,ModuleWrapper* > catomWrappers;
vector<DCondition*> initialMasters;
pthread_mutex_t dc_init_lock = PTHREAD_MUTEX_INITIALIZER;

enum {
	kId = 0,
 	kNumNeighbors,kRed,kGreen,kBlue,kAlpha,kTime
};

void DistributedCondition::simulationStart() {
	//set up local module wrapper
	ModuleWrapper *localWrapper = this->localModule();
	pthread_mutex_lock(&dc_init_lock);	//only one thread should insert at a time
	catomWrappers[hostCatom] = localWrapper;
	//parse and add any conditions to initial master list
	if (!initialMasters.size()) {
		//parse individual conditions
		char condNameStr[50] = "DCond";
		unsigned int i = 0;
		do {
			sprintf(condNameStr,"DCond%d",i);
			string cond_str = worldPtr->search_key_value_list(condNameStr);
			if (cond_str != "") {
				DCondition *master = parseCondition(cond_str);
				master->id = i;
				initialMasters.push_back(master);
			}
		} while (i++ < 100);
		
		//parse source file
		string src_str = worldPtr->search_key_value_list("LDP_SRC");
		if (src_str != "") {
			vector<DCondition *>masters = parseFile(src_str);
			for (unsigned k = 0; k < masters.size(); k++) {
				masters[k]->id = initialMasters.size();
				initialMasters.push_back(masters[k]);
			}
		}
	}
	pthread_mutex_unlock(&dc_init_lock);
	
	//set up DCondManager
	condManager = new DCondManager(localWrapper);
	for (unsigned i = 0; i < initialMasters.size(); i++) condManager->addCondition(initialMasters[i]);
	
	
	//register for messages
	HOSTCATOM.mailboxManager.registerHandler(conditionMessagingBox,this,
			(msgHandlerPtr)&DistributedCondition::conditionMsgHandler);
	
}


void DistributedCondition::endTick() {
	condManager->tick();
}

bool DistributedCondition::conditionMsgHandler(ConditionMessage* msg) {
	condManager->messageReceived(msg->payload,catomWrappers[msg->srcID]);
	return false;
}

//----wrapper support functions----------------

set<ModuleWrapper *> CatomWrapper::neighbors() {
	set<ModuleWrapper*> n;
	for (unsigned k = 1; k <= NUM_FEATURES; k++) {    // fixed - Babu
		catomID kthFeatureNeighbor = catom->C.getNeighbor(k);
		if (kthFeatureNeighbor) {
			n.insert((ModuleWrapper*)catomWrappers[kthFeatureNeighbor]);
		}
	}
	return n;
}

void CatomWrapper::send(DCMessage* dc, ModuleWrapper *dest) {
	for (unsigned k = 1; k <= NUM_FEATURES; k++) {
		catomID kthFeatureNeighbor = catom->C.getNeighbor(k);
		if (kthFeatureNeighbor == dest->id) {
			ConditionMessage *msg = new ConditionMessage(conditionMessagingBox, dc, id);
			catom->C.getFeatureMap()[k].getNetworkAdapter()->sendMessage(msg);
			//if (dc->matcher->id == 2) 
				sendCount++;
			return;
		}
	}
}

VarCode CatomWrapper::codeForVarname(string varname) {
	if (varname == "id") 
		return kId;
	else if (varname == "numNeighbors") 
		return kNumNeighbors;
	else if (varname == "red") 
		return kRed;
	else if (varname == "green") 
		return kGreen;
	else if (varname == "blue") 
		return kBlue;
	else if (varname == "alpha") 
		return kAlpha;
	else if (varname == "time") 
		return kTime;
	else return ModuleWrapper::codeForVarname(varname);
}

float CatomWrapper::getRealVar(VarCode var) {
	switch (var) {
		case kId:
			return id;
			break;
		case kTime:
			return worldPtr->current_time;
			break;
		case kNumNeighbors: {
			int numNeighbors = 0;
			for (unsigned k = 1; k <= NUM_FEATURES; k++) {
				catomID kthNeighbor = catom->C.getNeighbor(k); // fixed - Babu
				if (kthNeighbor) {
					numNeighbors++;
				}
			}
			return numNeighbors;
			}
			break;
		default: 
			return ModuleWrapper::getRealVar(var);
	}
	return 0.0;
}

void CatomWrapper::setRealVar(VarCode var, float val) {
	switch (var) {
		case kRed:
			catom->red = (uint8) val;
			break;
		case kGreen:
			catom->green = (uint8) val;
			break;
		case kBlue:
			catom->blue = (uint8) val;
			break;
		case kAlpha:
			catom->alpha = (uint8) val;
			break;
		default:
			ModuleWrapper::setRealVar(var,val);
	}
}


void CatomWrapper::callFcn(string fname, float arg) {
	if (fname == "randomColor") {
		catom->red = rand() % 256;
		catom->green = rand() % 256;
		catom->blue = rand() % 256;
		catom->alpha = rand() % 100;
	}
	else if (fname == "arrow") {
		worldPtr->addLine(id,(long)arg,255,0,0);
	}
	else ModuleWrapper::callFcn(fname,arg);
}
