///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Corporation and Carnegie Mellon University    //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include <iostream>
#include <errno.h>
#include <string.h>

#include <pthread.h>

#include "CubicCA.hxx"
#include "CatomWorld.hxx"
#include "CatomSim.hxx"

CODE_MODULE_DECLARATION( CubicCA, CubicCA );

using namespace std;


static pthread_mutex_t local_lock = PTHREAD_MUTEX_INITIALIZER;
static bool get_root_catom=false;
static Point3D root_loc;
static catomID root_id;


void CubicCA::newTick() {
  if ( get_root_catom ) {
    HOSTCATOM.setColor( 255,0,0,0 );
    pthread_mutex_lock( &local_lock );
    Point3D p = HOSTCATOM.getLocation();
    //p = Point3D( (int)p.getX(), (int)p.getY(), (int)p.getZ() );
    //if ( p.getX() < root_loc.getX() || p.getX() == root_loc.getX() && 
	//(p.getY() < root_loc.getY() || p.getY() == root_loc.getY() && p.getZ() < root_loc.getZ()) ) {
    if ( p.getX()+p.getY()+p.getZ() < root_loc.getX()+root_loc.getY()+root_loc.getZ() ) {
      root_loc = p;
      root_id = hostCatom;
    }
    pthread_mutex_unlock( &local_lock );
  }
}


static void catomAtCallback( void *data, dGeomID o1, dGeomID o2 ) {
  CatomSim *c1 = (CatomSim*) dGeomGetData( o1 );
  CatomSim *c2 = (CatomSim*) dGeomGetData( o2 );
  if (c1==c2) return; //{ cerr<< "HERE1\n"; return; }
  if (!c1) c1=c2;
  if (!c1) return;
  catomID *ptr = (catomID *) data;
  *ptr = c1->C.getID();
}

static catomID getCatomAt( Point3D loc ) {
  catomID retval = 0;
  static dGeomID tmpshape = 0;
  if (!tmpshape) tmpshape = dCreateSphere( 0, 0.1 );
  dGeomSetPosition( tmpshape, loc.getX(), loc.getY(), loc.getZ() );
  dSpaceCollide2( tmpshape, (dGeomID) worldPtr->coll_space, (void*) &retval, catomAtCallback );
  return retval;
}

static void get_root() {
  root_loc = Point3D(1000000,1000000,1000000);
  get_root_catom = true;
  oracleYield();
  oracleYield();
  get_root_catom = false;
}

static vector<octet*> all_octets;
static Point3D layer_v;
static Point3D col_v;
static Point3D up_v;
static double oct_pos;
static octet* oct_root;

static void init_octets( Point3D l_v, Point3D c_v, Point3D u_v, bool is_up ) {
  // ought to delete any octets first
  layer_v = l_v;
  col_v = c_v;
  up_v = u_v;
  oct_pos = is_up ? 1.0 : 0.0;
  get_root();
  if (!is_up) {
    Point3D tmp = root_loc-2*col_v;
    if (tmp.getX() < root_loc.getX() || tmp.getY() < root_loc.getY() )
      root_loc = root_loc + 2*col_v;
  } // else conditions???
  Point3D next_loc = root_loc;
  double SIN = sin( M_PI*0.5*oct_pos );
  double COS = cos( M_PI*0.5*oct_pos );
  oct_root = 0;
  octet* last_layer=NULL;
  octet* last_col=NULL;
  octet* last=NULL;
  octet* next=new octet;
  oct_root=next;
  catomID next_catomID = getCatomAt( next_loc );
  while ( next_catomID ) {
    if (last_layer) last_layer->next_layer=next;
    last_layer=next;
    while ( next_catomID ) {
      if (last_col) last_col->next_col = next;
      last_col = next;
      while ( next_catomID ) {
	if (last) last->next = next;
	last = next;
	next->l1 = getCatomAt(next_loc);
	worldPtr->catomHash[next->l1]->C.setColor(0,255,255,0);
	next->l2 = getCatomAt(next_loc + 2*col_v);
	next->ml1 = getCatomAt(next_loc + 2*(SIN*up_v-COS*col_v));
	next->mt1 = getCatomAt(next_loc + 2*((1.0+SIN)*up_v - COS*col_v));
	next->ml2 = getCatomAt(next_loc + 2*((1.0+COS)*col_v + SIN*up_v));
	next->mt2 = getCatomAt(next_loc + 2*((1.0+COS)*col_v + (1.0+SIN)*up_v));
	next->t1 = getCatomAt(next_loc + 2*(1.0+2.0*SIN)*up_v);
	next->t2 = getCatomAt(next_loc + 2*((1.0+2.0*SIN)*up_v + col_v));
	cerr << "octet: " << next->l1 << " " << next->l2 << " " << next->ml1 << " " << next->mt1 
		<< " " << next->ml2 << " " << next->mt2 << " " << next->t1 << " " << next->t2 << "\n";
	next = new octet;
	next_loc += 4.0*(1.0+SIN)*up_v;
        next_catomID = getCatomAt( next_loc );
      }
      last = NULL;
      next_loc = worldPtr->catomHash[last_col->l1]->C.getLocation() + 4.0*(1.0+COS)*col_v;
      next_catomID = getCatomAt( next_loc );
    }
    last_col = NULL;
    next_loc = worldPtr->catomHash[last_layer->l1]->C.getLocation() + 2.0*layer_v;
    next_catomID = getCatomAt( next_loc );
  }
}


#define SETPOS( a, b ) dBodySetPosition( worldPtr->catomHash[(a)]->body, (b).getX(), (b).getY(), (b).getZ() )
#define ROT0( a ) dQMultiply0( orient, rot, dBodyGetQuaternion( worldPtr->catomHash[(a)]->body ) ); dBodySetQuaternion( worldPtr->catomHash[(a)]->body, orient )
#define ROT1( a ) dQMultiply1( orient, rot, dBodyGetQuaternion( worldPtr->catomHash[(a)]->body ) ); dBodySetQuaternion( worldPtr->catomHash[(a)]->body, orient )



void set_octet( double p ) {
  Point3D axis = up_v.cross(col_v);
  dQuaternion orient, rot;
  dQFromAxisAndAngle( rot, axis.getX(), axis.getY(), axis.getZ(), (p-oct_pos)*M_PI );
  oct_pos = p;
  double SIN = sin( M_PI*0.5*oct_pos );
  double COS = cos( M_PI*0.5*oct_pos );
  Point3D next_loc = root_loc;
  octet *oct_l = oct_root;
  while (oct_l) {
    octet *oct_c = oct_l;
    while (oct_c) {
      octet* oct = oct_c;
      while (oct) {
	SETPOS( oct->l1, next_loc);
	SETPOS( oct->l2, next_loc + 2*col_v);
	SETPOS( oct->ml1, next_loc + 2*(SIN*up_v-COS*col_v));
	ROT0( oct->ml1 );
	SETPOS( oct->mt1, next_loc + 2*((1.0+SIN)*up_v - COS*col_v));
	ROT1( oct->mt1 );
	SETPOS( oct->ml2, next_loc + 2*((1.0+COS)*col_v + SIN*up_v));
	ROT1( oct->ml2 );
	SETPOS( oct->mt2, next_loc + 2*((1.0+COS)*col_v + (1.0+SIN)*up_v));
	ROT0( oct->mt2 );
	SETPOS( oct->t1, next_loc + 2*(1.0+2.0*SIN)*up_v);
	SETPOS( oct->t2, next_loc + 2*((1.0+2.0*SIN)*up_v + col_v));
	next_loc += 4.0*(1.0+SIN)*up_v;
	oct = oct->next;
      }
      next_loc = worldPtr->catomHash[oct_c->l1]->C.getLocation() + 4.0*(1.0+COS)*col_v;
      oct_c = oct_c->next_col;
    }
    next_loc = worldPtr->catomHash[oct_l->l1]->C.getLocation() + 2.0*layer_v;
    oct_l = oct_l->next_layer;
  }
  oracleYield();
  oracleYield();
}

void CubicCA::oracle() {
  oracleYield();
  double a;
  init_octets( Point3D(0,1,0), Point3D(1,0,0), Point3D(0,0,1), 1 );
  for (a=1.0; a>=0.0; a-=0.01) set_octet(a);
  init_octets( Point3D(0,1,0), Point3D(1,0,0), Point3D(0,0,1), 1 );
  for (a=1.0; a>=0.0; a-=0.01) set_octet(a);
  init_octets( Point3D(1,0,0), Point3D(0,1,0), Point3D(0,0,1), 0 );
  for (a=0.0; a<=1.0; a+=0.01) set_octet(a);
  init_octets( Point3D(0,0,1), Point3D(0,1,0), Point3D(1,0,0), 1 );
  for (a=1.0; a>=0.0; a-=0.01) set_octet(a);
  init_octets( Point3D(0,0,1), Point3D(0,1,0), Point3D(1,0,0), 1 );
  for (a=1.0; a>=0.0; a-=0.01) set_octet(a);
}
