// Compensation.hxx
// Nels Beckman
// Feb 28th, 2007
//
// Compensation is an abstract class. It just has an abstract method, run
//   which will be called on all compensations.
// Hopefully this technique will not be too ornerous because I just learned
//   that you can locally define classes in the middle of a function in C++.
//   Here is an example of a potential usage:
//
//int main() {
//
//  class Something : public Compensation {
//  public:
//    virtual void run() { cout<<"Yeah baby!"<<endl; }
//  };
//
//  Something nels;
//  nels.run();
//
//}

#ifndef __COMPENSATION_H
#define __COMPENSATION_H

class Compensation {
  
public:
  // run() should perform the compensating action.
  //   When this class is subclassed, you should define your compensating
  //   actions here.
  virtual void run() = 0;
  virtual ~Compensation() {};
};

#endif
