// CompManager.hxx
// Nels Beckman
// Feb 28th 2007

#ifndef __COMPMANAGER_H
#define __COMPMANAGER_H

#include <stack>
#include <map>
#include <pthread.h>
#include <list>

#include "Debugging/signpost.hxx"

#include "Compensation.hxx"
//#include "Tid.hxx"

#define Tid int

using namespace std;

class CompManager {
protected:
  
  pthread_mutex_t cmStateMutex;

  // The compensations that have already been run on this catom by
  //   the admin thread.
  list<Tid> compsRunList;
  
  // The compensations that need to be run on this catom by the
  //   admin thread.
  list<Tid> compsToRun;
  
  map<Tid, stack<Compensation*> > myComps;
  
public:
  CompManager();

  // The compensations for this transaction will need to be run the next
  //   time runOutstandingComps is called.
  void addOutstandingComp(Tid);
  //
  // collabsToRun.add(tid);

  // pushComp
  // Given a compensation and the Tid within which we are currently
  //   operating, this method stores the Compensation in the
  //   appropriate location.
  void pushComp(Compensation*, Tid);
  //
  // myComps.get(tid).push(comp);

  // exeComps(Tid);
  // Executes all of the compensating actions in the given transaction id.
  void exeComps(Tid);
  //
  // while myComps.get(tid).hasNext()
  // do
  //   myComps.get(tid).top().run();
  //   myComps.get(tid).pop();
  // od
  
  // Runs all of the compensations that are waiting to be run.
  void runOutstandingComps();
  //
  // foreach tid in compsToRun
  // do
  //   exeComps(tid);
  // od
  // compsToRun := new list();
};

#endif
