// CompManager.cxx
// Nels Beckman
// Feb 28th 2007

#include "CompManager.hxx"

CompManager::CompManager() {
  pthread_mutex_init( &cmStateMutex, NULL );
}

void CompManager::addOutstandingComp(Tid tid) {
  pthread_mutex_lock( &cmStateMutex ); 
  compsToRun.push_back(tid);
  pthread_mutex_unlock( &cmStateMutex ); 
}

void CompManager::exeComps(Tid tid) {
  while( !myComps[tid].empty() ) {
    myComps[tid].top()->run();
    
    delete myComps[tid].top();
    myComps[tid].pop();
  }

  // remove this tid
  myComps.erase(tid);
}

void CompManager::pushComp(Compensation* comp, Tid tid) {
  
  if( myComps.find(tid) == myComps.end() ) {
    // This tid hasn't been added yet.
    stack<Compensation*> new_stack;
    new_stack.push(comp);
    
    myComps[tid] = new_stack;
  }
  else {
    // That stack is already there.
    myComps[tid].push(comp);
  }
}

void CompManager::runOutstandingComps() {
  pthread_mutex_lock( &cmStateMutex ); 
  
  for( list<Tid>::iterator iter = compsToRun.begin();
       iter != compsToRun.end();
       iter++ ) {
    
    Tid t = (*iter);
    exeComps(t);
    compsRunList.push_back(t);
  }
  
  compsToRun.clear();
  pthread_mutex_unlock( &cmStateMutex );
}
