#include <iostream>
#include <string.h>

#include "Cator.hxx"
#include "FeatureMapIterator.hxx"

using namespace std;

CODE_MODULE_DECLARATION( Cator, CatorModule );

#define ForAll(i) for( ; !i; ++i)

StateFile::Module* CatorModule::StateFileConstructor() {

  myModule_ = StateFile::Module::getInstance( name_ );
  myModule_->setSkip( true );

  // Check to see if this module has already been setup
  if (myModule_->getVersion())
    return myModule_;

  // If not, set up this module for the first time
  myModule_->setVersion( 1 );
  myModule_->setVersionRange( 1 );

  return myModule_;
}

void CatorModule::newTick() {
  
  Catom * me = &(worldPtr->catomHash[hostCatom]->C);
  // CatomSim * catomSim = worldPtr->catomHash[hostCatom];

  FeatureMapIterator PI( me->getFeatureMap(), &FeatureIsEmpty );

  worldPtr->oStart();

  cout << "Catom " << hostCatom << " empty: ";
  ForAll( PI ) {
    cout << PI.which() << ",";
  }
  cout << endl;
  worldPtr->oEnd();
}

