// Belt.hxx
// Nels Beckman
// April 3rd, 2007
//
// A moving conveyor belt of catoms.

#ifndef __BELT_H
#define __BELT_H

#include <pthread.h>

#include "RPCTemplates.hxx"

CODE_MODULE_PROTOTYPE(Belt,Belt);

using namespace std;

#define NORTH 4
#define SOUTH 3
#define EAST 5
#define WEST 2
#define TOP 1

class NextMove {
public:
  NextMove(catomID _c, featureID _f) : c(_c), f(_f) {}
  catomID c;
  featureID f;
};

class Belt : public RPCCodeModule<Belt> {
  
protected:
  bool token;
  pthread_mutex_t mutex;

  bool changeColor();
  unsigned int randEorW();

public:
  Belt(catomID _hostCatom);
  virtual void thread();

  // NON RPC METHODS
  void start();

  // Tries to get the token. Returns true if succesful.
  bool getToken();

  // Releases the token, no matter who has it.
  void releaseToken();
  
  // Calls the schedule move primitve.
  void scheduleMove(NextMove);

  // Repeatedly check if a neighbor is above you. When he is,
  //   move him to the given next move.
  void waitForTopAndMove(NextMove);

  // RPC METHODS
  // Returns false if no move was sucesfully planned.
  bool recurse(NextMove);

  // Releases the token remotely. Called once a catom has progressed all
  //   the way to the front.
  void urDone();
 
  void remoteMove(NextMove);
};

#endif 
