///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Coproration and Carnegie Mellon University    //
// Contacts: casey.j.helfrich @ intel.com                                    //
//           bdr @ cs.cmu.edu                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////


#ifndef __CODEMODULELIST_HXX
#define __CODEMODULELIST_HXX


#include "CodeModule.hxx"

void CatomSim::loadCodeModules(string module_list) {
  
  // Tokenize the code_module list
  vector<string> moduleTokens;
  const string delimiter = ",";
  string::size_type lastpos = module_list.find_first_not_of(delimiter, 0);
  string::size_type pos = module_list.find_first_of(delimiter, lastpos);
  
  while((pos != string::npos || lastpos != string::npos) && (pos != lastpos)) {
    moduleTokens.push_back(module_list.substr(lastpos, pos-lastpos));
    lastpos = module_list.find_first_not_of(delimiter, pos);
    pos = module_list.find_first_of(delimiter, lastpos);
  }

  // moduleTokens now contains a list of all Code Modules to be loaded

  if(moduleTokens.size() < 1) {
    cerr << "Module List appears invalid..." << endl;
    exit(1);
  }

  bool first_time = false;
  bool failure = false;
  int i = 0;

  if ( CODE_MODULE_DECLARATIONS::module_id_remap == 0 ) {
    first_time = true;
    CODE_MODULE_DECLARATIONS::module_id_remap = 
      new int[ CodeModuleID::max_value + 1 ];
    int k;
    for ( k =0; k<=CodeModuleID::max_value; k++ )
      CODE_MODULE_DECLARATIONS::module_id_remap[ k ] = -1;  // force errors
  }

  vector<string>::iterator currentModule = moduleTokens.begin();
  while(currentModule != moduleTokens.end()) {
    int k;
    CodeModule* cm = 
      CodeModuleListEntry::getModuleByName( *currentModule, C.getID(), &k );

    if ( cm ) {
      codeModules.push_back( cm );
      if (first_time) {
        CODE_MODULE_DECLARATIONS::module_id_remap[ k ] = i++;
        std::cout << "Loaded Code Module: " << *currentModule << std::endl;
      }
    }
    else
    {
      cerr << "Invalid Code Module: " << *currentModule << endl;
      failure = 1;
    }
    currentModule++;
  }
  
  if ( failure ) {
    cerr << "\n It appears that you have specified a CodeModule"
      << "\n that does not exist in this version of the simulator."
      << "\n Please check the README file for details on adding modules." 
      << endl;
    exit(1);
  }
}

#endif /* __CODEMODULELIST_HXX */
