///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Coproration and Carnegie Mellon University    //
// Contacts: casey.j.helfrich @ intel.com                                    //
//           bdr @ cs.cmu.edu                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include "CodeModule.hxx"
#include "CatomSim.hxx"
#include "CatomWorld.hxx"
#include "Debugging.hxx"
#include "SmartYield.hxx"

CodeModule::CodeModule() {
  exit(-1);
}

CodeModule::CodeModule(catomID _hostCatom) : 
  hostCatom(_hostCatom),
  name_(CODE_MODULE_DECLARATIONS::current_module_name) 
{ }

CodeModule::~CodeModule() {  }

void CodeModule::simulationStart() {
  // don't do anything by default
}

void CodeModule::newTick() {
  // don't do anything by default
}

void CodeModule::endTick() {
  // don't do anything by default
}

StateFile::Module* CodeModule::StateFileConstructor() {
  myModule_ = NULL;
  return NULL;
}

void CodeModule::loadModule() {
  // don't do anything by default
}

void CodeModule::saveModule() {
  // don't do anything by default
}

void CodeModule::simulationEnd() {
  // don't do anything by default
}

void CodeModule::oracle() {
  // don't do anything by default
}

void CodeModule::thread() {
  // don't do anything by default

  // I don't know what I want to do by default, but
  // this method should get called by the simulator
  // once at the beginning of the simulator and it
  // will thereafter have to call yield to by itself
  // my main, per-module thread is going to have to
  // wake this one up somehow...
}


// oracle and thread support

// SmartYield structure
extern pt_yield yield;

// flag signifying whether loop is done
// set by DPRSim main loop
extern bool isComplete;
extern bool NC_Oracles;
extern pthread_mutex_t NC_lock;
static list<pthread_t> oracleList;

void oracleExit() {
//  cout << "ENDING ORACLE THREAD\n";
  if (NC_Oracles) {
    oracleList.pop_front();
    pthread_mutex_unlock( &NC_lock );
  }
  decr_nthreads( &yield );
  pthread_exit(NULL);
}

static inline void oracleYieldHelper() {
  do_yield( &yield );
  if (NC_Oracles) {
    pthread_mutex_lock( &NC_lock );
    while (oracleList.front() != pthread_self()) {
      pthread_mutex_unlock( &NC_lock );
      sched_yield();
      pthread_mutex_lock( &NC_lock );
    }
  }
  if (isComplete) oracleExit();
}

static inline void oracleYieldInitial() { oracleYieldHelper(); }

void oracleYield() {
  if (NC_Oracles) {
    oracleList.pop_front();
    oracleList.push_back( pthread_self() );
    pthread_mutex_unlock( &NC_lock );
  }
  oracleYieldHelper();
}

static void* oracleMain( void* m ) {
  CodeModule *cm = (CodeModule*) m;
  // first yield to synchronize start
  //do_yield( &yield );
  oracleYieldInitial();
  if (!isComplete) {
    cm->oracle();
  }
  oracleExit();
  return NULL;
}

// nbeckman
// This method is much like oracleMain. Its job is to do the
//   initial yield required of all threads in the sim and then
//   to call thread(), the long-running thread method of code
//   modules.
//   m should be an instance of a CodeModule.
static void* codeModulePerThreadMain( void* m ) {
  assert( m != NULL );

  CodeModule *cm = (CodeModule*) m;
  
  // first yield
  do_yield( &yield );
  cout<<"Nels: Made it past the first yield."<<endl;
  cm->thread();
  
  // TODO: There needs to be some yield here at the end or removal
  //   of threads from the number of threads being tracked bc
  //   long-running threads are no longer part of the collection at
  //   this point.
  decr_nthreads( &yield );
  return NULL;
}

// nbeckman
// So the idea here is that this method will be called somehow
//   by the simulator. I guess it will be called once for each
//   module at the beginning of the simulator. Its job is basically
//   to start a new thread running codeModuleThreadPerMain method of
//   the given code module. It looks a lot like the oracle method of
//   a similar name.
void startCodeModulePerThread( CodeModule* m ) {

  assert( m != NULL );

#ifdef __THREADED__
  pthread_t tid;

  // Setting stack size
  pthread_attr_t attrs;
  pthread_attr_init(&attrs);
  pthread_attr_setstacksize(&attrs, (1<<15));

  // Incrementing the number of threads that must yield before the
  //   end of a turn.
  incr_nthreads( &yield );

  // Create a thread for this code module.
  {
    int ret;
    if( (ret = pthread_create(&tid, &attrs, 
			      codeModulePerThreadMain, m)) != 0 ) {
      cerr << "Error: unable to create thread for " 
	   << "one catom per thread functionality."<< " :: " 
	   << strerror(ret) << endl;
      exit(0);
    }
  }

  // Hmm... I don't know enough about the way that oracle works to know
  //   if I have to call this.
  catomThreadList.push_back(tid);
  //oracleList.push_bach(tid);
#endif

}

void startCodeModuleOracle( CodeModule* m ) {
//  CodeModule tmp(0);
//  if ( &(m->oracle) == &(tmp.oracle) ) return;
//  cout << "STARTING ORACLE THREAD\n";

#ifdef __THREADED__
  int ret;
  pthread_t tid;

  // Set stack size
  pthread_attr_t attrs;
  pthread_attr_init(&attrs);
  pthread_attr_setstacksize(&attrs, (1<<15));

  incr_nthreads( &yield );  // new: need to increment number of threads that yield
  
  // create a thread for this catom by catomMain
  if( (ret = pthread_create(&tid, &attrs, oracleMain, m)) != 0 ) {
    cerr << "Error: unable to create thread" << " :: " 
	 << strerror(ret) << endl;
    exit(0);
  }
  
  // store thread ID in the list in CatomWorld
  catomThreadList.push_back(tid);
  oracleList.push_back(tid);
#endif
}


// global vars for automatic registration of linked-in modules

CodeModuleListEntry* CodeModuleListEntry::ModuleList = 0;
int* CODE_MODULE_DECLARATIONS::module_id_remap = 0;
int CodeModuleID::max_value=0;
string CODE_MODULE_DECLARATIONS::current_module_name = "";
