// Tools Library
//
// Copyright (C) 2004  Navel Ltd.
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// Contact information:
//  Mailing address:
//    Marios Hadjieleftheriou
//    University of California, Riverside
//    Department of Computer Science
//    Surge Building, Room 310
//    Riverside, CA 92521
//
//  Email:
//    marioh@cs.ucr.edu

#include <Tools.h>

using namespace std;

class MyObject : public Tools::IObject, public Tools::IComparable, public Tools::ISerializable
{
public:
	MyObject(double xlow, double ylow, double xhigh, double yhigh)
		: m_xlow(xlow), m_xhigh(xhigh), m_ylow(ylow), m_yhigh(yhigh) {}

	virtual ~MyObject() {}

	virtual IObject* clone() throw (Tools::NotSupportedException)
	{
		return new MyObject(m_xlow, m_ylow, m_xhigh, m_yhigh);
	}

	virtual bool operator<(const Tools::IComparable& c) const
	{
		const MyObject* po = static_cast<const MyObject*>(&c);
		if (m_xlow < po->m_xlow) return true;
		return false;
	}

	virtual bool operator>(const Tools::IComparable& c) const
	{
		const MyObject* po = static_cast<const MyObject*>(&c);
		if (m_xlow > po->m_xlow) return true;
		return false;
	}

	virtual bool operator==(const Tools::IComparable& c) const
	{
		const MyObject* po = static_cast<const MyObject*>(&c);
		if (m_xlow == po->m_xlow) return true;
		return false;
	}

	virtual unsigned long getByteArraySize()
	{
		return 4 * sizeof(double);
	}

	virtual unsigned long loadFromByteArray(byte* const data)
	{
		byte* ptr = data;
		memcpy(&m_xlow, ptr, sizeof(double));
		ptr += sizeof(double);
		memcpy(&m_ylow, ptr, sizeof(double));
		ptr += sizeof(double);
		memcpy(&m_xhigh, ptr, sizeof(double));
		ptr += sizeof(double);
		memcpy(&m_yhigh, ptr, sizeof(double));
		//data += sizeof(double);
		return getByteArraySize();
	}

	virtual void storeToByteArray(unsigned long& len, byte** data)
	{
		len = getByteArraySize();
		*data = new byte[len];
		byte* ptr = *data;
		memcpy(ptr, &m_xlow, sizeof(double));
		ptr += sizeof(double);
		memcpy(ptr, &m_ylow, sizeof(double));
		ptr += sizeof(double);
		memcpy(ptr, &m_xhigh, sizeof(double));
		ptr += sizeof(double);
		memcpy(ptr, &m_yhigh, sizeof(double));
		//ptr += sizeof(double);
	}

	double m_xlow, m_xhigh, m_ylow, m_yhigh;
};

class MyObjectStream : public Tools::IObjectStream
{
public:
	MyObjectStream(string inputFile) : m_bEOF(false)
	{
		m_fin.open(inputFile.c_str());
		if (! m_fin)
		{
			throw Tools::IllegalArgumentException("Input file not found.");
		}
	}

	virtual Tools::IObject* getNext()
	{
		double d[4];

		m_fin >> d[0] >> d[1] >> d[2] >> d[3];

		if (! m_fin.good())
		{
			m_bEOF = true;
			return 0;
		}

		return new MyObject(d[0], d[1], d[2], d[3]);
	}

	virtual bool hasNext()
	{
		return (! m_bEOF);
	}

	virtual unsigned long size() throw (Tools::NotSupportedException)
	{
		throw Tools::NotSupportedException("Operation not supported.");
	}

	virtual bool rewind() throw (Tools::NotSupportedException)
	{
		try
		{
			m_fin.seekg(0, ios::beg);
			m_bEOF = false;
			return true;
		}
		catch (...)
		{
			return false;
		}
	}

	virtual ~MyObjectStream()
	{
		m_fin.close();
	}

	ifstream m_fin;
	bool m_bEOF;
};

int main(int argc, char** argv)
{
	try
	{
		if (argc != 3)
		{
			cerr << "Usage: " << argv[0] << " input_file buffer_size." << endl;
			return -1;
		}

		unsigned long bufferSize = atol(argv[2]);

		MyObjectStream sin(argv[1]);

		Tools::SmartPointer<Tools::IObjectStream> sout(Tools::externalSort(sin, bufferSize));

		cout << fixed;

		while (sout->hasNext())
		{
			Tools::SmartPointer<MyObject> s(dynamic_cast<MyObject*>(sout->getNext()));
			cout << s->m_xlow << " " << s->m_ylow << " " << s->m_xhigh << " " << s->m_yhigh << endl;
		}
	}
	catch (Tools::Exception& e)
	{
		cerr << "******ERROR******" << endl;
		std::string s = e.what();
		cerr << s << endl;
		return -1;
	}
	catch (...)
	{
		cerr << "******ERROR******" << endl;
		cerr << "other exception" << endl;
		return -1;
	}

	return 0;
}
